/*
  SPDX-FileCopyrightText: 2025-2026 Laurent Montel <montel@kde.org>

  SPDX-License-Identifier: GPL-2.0-or-later
*/

#pragma once
#include "textautogeneratetext_private_export.h"
#include "widgets/view/textautogeneratedelegateutils.h"
#include <QItemDelegate>

namespace TextAutoGenerateText
{
class TEXTAUTOGENERATETEXT_TESTS_EXPORT TextAutoGenerateHistoryListViewDelegate : public QItemDelegate
{
    Q_OBJECT
public:
    explicit TextAutoGenerateHistoryListViewDelegate(QObject *parent = nullptr);
    ~TextAutoGenerateHistoryListViewDelegate() override;

    [[nodiscard]] bool helpEvent(QHelpEvent *helpEvent, QAbstractItemView *view, const QStyleOptionViewItem &option, const QModelIndex &index) override;

    QWidget *createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index) const override;

    void setEditorData(QWidget *editor, const QModelIndex &index) const override;

    void setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index) const override;

    void updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index) const override;
    void paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const override;

    void needUpdateWaitingAnswerAnimation(const QPersistentModelIndex &index,
                                          const QList<TextAutoGenerateMessageWaitingAnswerAnimation::ScaleAndOpacity> &scaleAndOpacities);
    void removeNeedUpdateWaitingAnswerAnimation(const QPersistentModelIndex &index);

    [[nodiscard]] QSize sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const override;

private:
    struct Layout {
        QRect textRect;
        QRect inProgressRect;
        QString title;
        bool isHeader = false;
    };
    TEXTAUTOGENERATETEXT_NO_EXPORT void
    drawInProgressIndicator(QPainter *painter, const QModelIndex &index, const QStyleOptionViewItem &option, const Layout &layout) const;
    [[nodiscard]] TEXTAUTOGENERATETEXT_NO_EXPORT TextAutoGenerateHistoryListViewDelegate::Layout doLayout(const QStyleOptionViewItem &option,
                                                                                                          const QModelIndex &index) const;
    QList<TextAutoGenerateDelegateUtils::IndexScaleAndOpacities> mIndexScaleAndOpacitiesList;
};
}
