/*
   SPDX-FileCopyrightText: 2019-2024 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: LGPL-2.0-or-later
*/

#include "groupsinfojobtest.h"
#include "groups/groupsinfojob.h"
#include "ruqola_restapi_helper.h"
QTEST_GUILESS_MAIN(GroupsInfoJobTest)
using namespace RocketChatRestApi;
GroupsInfoJobTest::GroupsInfoJobTest(QObject *parent)
    : QObject(parent)
{
}

void GroupsInfoJobTest::shouldHaveDefaultValue()
{
    GroupsInfoJob job;
    verifyDefaultValue(&job);
    QVERIFY(job.requireHttpAuthentication());
    QVERIFY(job.roomId().isEmpty());
    QVERIFY(!job.hasQueryParameterSupport());
}

void GroupsInfoJobTest::shouldGenerateRequest()
{
    GroupsInfoJob job;
    job.setRoomId(QStringLiteral("foo"));
    QNetworkRequest request = QNetworkRequest(QUrl());
    verifyAuthentication(&job, request);
    QCOMPARE(request.url(), QUrl(QStringLiteral("http://www.kde.org/api/v1/groups.info?roomId=foo")));
}

void GroupsInfoJobTest::shouldNotStarting()
{
    GroupsInfoJob job;

    RestApiMethod method;
    method.setServerUrl(QStringLiteral("http://www.kde.org"));
    job.setRestApiMethod(&method);

    QNetworkAccessManager mNetworkAccessManager;
    job.setNetworkAccessManager(&mNetworkAccessManager);
    QVERIFY(!job.canStart());
    const QString auth = QStringLiteral("foo");
    const QString userId = QStringLiteral("foo");
    job.setAuthToken(auth);
    QVERIFY(!job.canStart());
    job.setUserId(userId);
    QVERIFY(!job.canStart());
    const QString roomId = QStringLiteral("foo1");
    job.setRoomId(roomId);
    QVERIFY(job.canStart());
}

#include "moc_groupsinfojobtest.cpp"
