/***************************************************************************
                          listenterdialog.cpp  -  description
                             -------------------
    begin                : Tue Feb 1 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@skydsl.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "listenterdialog.h"

ListEnterDialog::ListEnterDialog(QWidget * parent, const char * name, bool modal, WFlags f)
				: QDialog(parent,name,modal)
{
	QFont fnt ("helvetica",10);

	ypos[0] = 10;
	addNum = 0;
	infoLab = new QLabel(i18n("Please enter the sites here :"),this);
	infoLab->setGeometry(10,5,(this->width()-20),30);
	infoLab->setFont(QFont("helvetica",12, QFont::Bold));
	infoLab->setFrameStyle(QFrame::Panel | QFrame::Raised);
	infoLab->setAlignment(AlignCenter);

	helpBut = new QPushButton(this);
	helpBut->setGeometry(this->width()-35,10,20,20);
	helpBut->setPixmap(Icon("help.xpm"));
	connect(helpBut, SIGNAL(clicked()), this, SLOT(showHelp()));
	QToolTip::add(helpBut, i18n("Get Quickhelp"));

	enterFrame = new QFrame(this);
	enterFrame->setFrameStyle( QFrame::Panel | QFrame::Sunken );
	enterFrame->setGeometry(10,40,465,200);

	enter2Frame = new QFrame(enterFrame);
	enter2Frame->setGeometry(2,2,461,196);

	butFrame = new QFrame(this);
	butFrame->setFrameStyle( QFrame::WinPanel | QFrame::Raised );
	butFrame->setGeometry(10,210,465,30);

	addBut = new QPushButton(i18n("Add"), butFrame);
	addBut->setGeometry(10,5,80,20);
	addBut->setFont(fnt);
	connect( addBut, SIGNAL(clicked()), this, SLOT(addSite()));

	rmBut = new QPushButton(i18n("Remove Last"), butFrame);
	rmBut->setGeometry(90,5,110,20);
	rmBut->setFont(fnt);
  	rmBut->setEnabled(false);
	connect( rmBut, SIGNAL(clicked()), this, SLOT(rmLast()));

	rmallBut = new QPushButton(i18n("Remove All"), butFrame);
	rmallBut->setGeometry(200,5,110,20);
	rmallBut->setFont(fnt);
  	rmallBut->setEnabled(false);
	connect( rmallBut, SIGNAL(clicked()), this, SLOT(rmAll()));

	protChoose[addNum] = new QComboBox (enter2Frame);
	protChoose[addNum]->setGeometry(10,ypos[0],70,20);
	protChoose[addNum]->insertItem("http://");
	protChoose[addNum]->insertItem("ftp://");
	connect( protChoose[addNum], SIGNAL(activated(int)), this, SLOT(enableAnon(int)));

	siteLine[addNum] = new MyLineEdit(enter2Frame);
	siteLine[addNum]->setGeometry(85,ypos[0],350,20);
	
	ftpBox[addNum] = new QCheckBox("Anon", enter2Frame);
	ftpBox[addNum]->setGeometry(435,ypos[0],50,20);
	ftpBox[addNum]->setChecked(true);
	ftpBox[addNum]->hide();
	QToolTip::add(ftpBox[addNum], i18n("Check this button, if you want to use anonymous Ftp.\n"
					"If not, you have to enter the username and password before the adress:\n"
					"username:password@ftp.host.com"));

	enterScroll = new QScrollBar(0,0,10,30,0,QScrollBar::Vertical,this);
	enterScroll->setGeometry(475,40,15,200);
	connect(enterScroll, SIGNAL(valueChanged(int)), this, SLOT(resizeEnterFrame(int)));

	applyBut = new QPushButton(i18n("Apply"), this);
	applyBut->setGeometry(340,275,70,20);
	applyBut->setFont(fnt);

	cancelBut = new QPushButton(i18n("Cancel"), this);
	cancelBut->setGeometry(420,275,70,20);
	cancelBut->setFont(fnt);
	connect(cancelBut, SIGNAL(clicked()), this, SLOT(cancelApp()));
}

ListEnterDialog::~ListEnterDialog()
{
}

void ListEnterDialog::resizeEvent(QResizeEvent *re)
{
	infoLab->setGeometry(10,5,(this->width()-20),30);
	helpBut->move(this->width()-35,10);
	enterFrame->setGeometry(10,40,this->width()-35,this->height()-100);
	enter2Frame->setGeometry(2,2,this->width()-39,this->height()-104);
	butFrame->setGeometry(10,this->height()-60,this->width()-20,30);
	enterScroll->setGeometry(this->width()-25,40,15,this->height()-100);
	applyBut->setGeometry(this->width()-160,this->height()-25,70,20);
	cancelBut->setGeometry(this->width()-80,this->height()-25,70,20);
	for ( int i=0; i <= addNum ; i++) {
			siteLine[i]->setGeometry(85,(ypos[i]-enterScroll->value()),this->width()-185,20);
			ftpBox[i]->setGeometry(this->width()-95,(ypos[i]-enterScroll->value()),50,20);
		if ( i == addNum ) {
			if ( enter2Frame->height() <= siteLine[i]->pos().y()+20 ) {
			enterScroll->setRange(0,((siteLine[i]->pos().y()+20)- enter2Frame->height()));
			}
		}
	}
}

void ListEnterDialog::resizeEnterFrame(int value)
{
	for ( int i=0 ; i <= addNum ; i++ ) {
		protChoose[i]->move(10,(ypos[i]-value));
		siteLine[i]->move(85,(ypos[i]-value));
		ftpBox[i]->move(this->width()-100,(ypos[i]-value));
	}
}

void ListEnterDialog::addSite()
{
	enterScroll->setValue(0);
	if ( addNum == 199 ) {
		QMessageBox::warning(this, i18n("Too much sites !"),
				i18n("Sorry, but KWebGet just supports lists of\n"
					  "maximum 200 pages !") );
		return;
	}
	addNum++;
	ypos[addNum] = ypos[addNum-1]+20;

	if ( addNum >> 0 ) {
	  	rmBut->setEnabled(true);
	  	rmallBut->setEnabled(true);
	  }

	protChoose[addNum] = new QComboBox (enter2Frame);
	protChoose[addNum]->setGeometry(10,ypos[addNum],70,20);
	protChoose[addNum]->insertItem("http://");
	protChoose[addNum]->insertItem("ftp://");
	connect(protChoose[addNum], SIGNAL(activated(int)), this, SLOT(enableAnon(int)));

	ftpBox[addNum] = new QCheckBox("Anon", enter2Frame);
	ftpBox[addNum]->setGeometry(435,ypos[0],50,20);
	ftpBox[addNum]->setChecked(true);
	ftpBox[addNum]->hide();
	QToolTip::add(ftpBox[addNum], i18n("Check this button, if you want to use anonymous Ftp.\n"
					"If not, you have to enter the username and password before the adress:\n"
					"username:password@ftp.host.com"));

	siteLine[addNum] = new MyLineEdit(enter2Frame);
	siteLine[addNum]->setGeometry(85,ypos[addNum],350,20);
	connect(siteLine[addNum], SIGNAL(focusIn()), this, SLOT(getTextFocus()));

	protChoose[addNum]->show();
	siteLine[addNum]->show();

	this->resizeEvent(0);
	enterScroll->setValue(((siteLine[addNum]->pos().y()+20)- enter2Frame->height()));
}

// Slot, to remove the last Line
void ListEnterDialog::rmLast()
{
	enterScroll->setValue(0);
  // There is no need to remove the first line
  if ( addNum >> 0 ) {
	// First, I have to shrink the ScrollBar-Range
	if ( enter2Frame->height() <= siteLine[addNum]->pos().y()+20 ) {
		enterScroll->setRange(0,((siteLine[addNum-1]->pos().y()+20)- enter2Frame->height()));
	}
	// Then I have to remove the last Line ( if its empty )
	QString lastText;
	lastText = siteLine[addNum]->text();
	if ( !lastText.isEmpty() ) {
		switch (QMessageBox::warning(this, i18n("Question"),
				i18n("Are you sure ?"),
				i18n("Yes"), i18n("No"), 0,0,1))
		{
			case 0:
				break;
			case 1:
				return;
		}
	}
	disconnect(siteLine[addNum], SIGNAL(focusIn()), this, SLOT(getTextFocus()));
	disconnect( protChoose[addNum], SIGNAL(activated(int)), this, SLOT(enableAnon(int)));
	delete(siteLine[addNum]);
	delete(protChoose[addNum]);
	delete(ftpBox[addNum]);
	addNum--;
	if ( addNum == 0 ) {
	  	rmBut->setEnabled(false);
	  	rmallBut->setEnabled(false);
	}
  } else {
  	rmBut->setEnabled(false);
  	rmallBut->setEnabled(false);
  }
  enterScroll->setValue(((siteLine[addNum]->pos().y()+20)- enter2Frame->height()));
}

void ListEnterDialog::getTextFocus()
{
	for ( int i=0; i <= addNum ; i++ ) {
		if ( this->sender() == siteLine[i] ) {
			if  ( (siteLine[i]->pos().y()+20) - (enter2Frame->height() ) >= 5 ) {
			  enterScroll->setValue(0);
			  enterScroll->setValue(((siteLine[i]->pos().y()+20)- enter2Frame->height()));
			  }
		  }
	}
}

void ListEnterDialog::rmAll()
{
	QString tmp;
	bool allEmpty = true;
	for ( int i=0; i <= addNum ; i++) {
		tmp = siteLine[i]->text();
		if ( !tmp.isEmpty() )
			allEmpty = false;
	}
	if ( !allEmpty ) {
		switch ( QMessageBox::warning(this, i18n("Delete All Entrys ?"),
				i18n("Are you sure to delete all entrys ?"),
				i18n("Yes"), i18n("No"), 0,0,1))
		{
			case 0:
				break;
			case 1:
				return;
				break;
		}
	}
	enterScroll->setValue(0);
	for ( int i=1; i <= addNum ; i++ ) {
		disconnect(siteLine[i], SIGNAL(focusIn()), this, SLOT(getTextFocus()));
		disconnect( protChoose[addNum], SIGNAL(activated(int)), this, SLOT(enableAnon(int)));
		delete(siteLine[i]);
		delete(protChoose[i]);
		delete(ftpBox[i]);
	}
	siteLine[0]->setText("");
	protChoose[0]->setCurrentItem(0);
	addNum = 0;
  	rmBut->setEnabled(false);
  	rmallBut->setEnabled(false);
}

void ListEnterDialog::cancelApp()
{
	emit canceled();
	this->hide();
}

void ListEnterDialog::closeEvent(QCloseEvent *ce)
{
	// Nothing happens, if the close-Button [X] is pressed !
}

void ListEnterDialog::createLines(int lines)
{
	addNum = 0;
	for (int i=0; i <= (lines-1) ; i++) {
		addSite();
	}
}

void ListEnterDialog::enableAnon(int index)
{
	for ( int i=0; i <= addNum ; i++ ){
		if ( this->sender() == protChoose[i] ) {
			if ( !index ) {
				ftpBox[i]->hide();
			} else {
				ftpBox[i]->show();
			}
		}
	}
	this->resizeEvent(0);
}

void ListEnterDialog::rmAllCancel()
{
	for ( int i=1; i <= addNum ; i++ ) {
		disconnect(siteLine[i], SIGNAL(focusIn()), this, SLOT(getTextFocus()));
		disconnect( protChoose[addNum], SIGNAL(activated(int)), this, SLOT(enableAnon(int)));
		delete(siteLine[i]);
		delete(protChoose[i]);
		delete(ftpBox[i]);
	}
	siteLine[0]->setText("");
	protChoose[0]->setCurrentItem(0);
	ftpBox[0]->hide();
	addNum = 0;
  	rmBut->setEnabled(false);
  	rmallBut->setEnabled(false);
}

void ListEnterDialog::showHelp()
{
	QMessageBox::information(this, i18n("How to use this ?"),
			i18n("Here you can enter a list of sites or files to download.\n\n"
			"If you choose the Ftp-Protocol for a site, there is a Checkbox "
			"called 'Anon'.\nIf it is checked, KWebGet will login as anonymous "
			"to this site.\nIf you don't want this, you have to type the username "
			"and password\nin front of the hostname like this:\n"
			"\tusername:password@ftp.host.com   !!!"));
}