/***************************************************************************
                          outputwidget.cpp  -  description
                             -------------------
    begin                : Tue Jan 25 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@skydsl.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "outputwidget.h"

#include "../pics/runpix0.xpm"
#include "../pics/runpix1.xpm"
#include "../pics/runpix2.xpm"
#include "../pics/runpix3.xpm"
#include "../pics/runpix4.xpm"
#include "../pics/runpix5.xpm"
#include "../pics/runpix6.xpm"
#include "../pics/runpix7.xpm"
#include "../pics/runpix8.xpm"
#include "../pics/runpix9.xpm"
#include "../pics/runpix10.xpm"
#include "../pics/runpix11.xpm"
#include "../pics/stoppix.xpm"

OutputWidget::OutputWidget(QWidget * parent, const char * name, bool modal, WFlags f)
			: QDialog (parent, name, modal)
{
	tmr = 0;
	dec = true;
	stopPix = ((const char **)stoppix);
	runPix[0] = ((const char **)runpix0);
	runPix[1] = ((const char **)runpix1);
	runPix[2] = ((const char **)runpix2);
	runPix[3] = ((const char **)runpix3);
	runPix[4] = ((const char **)runpix4);
	runPix[5] = ((const char **)runpix5);
	runPix[6] = ((const char **)runpix6);
	runPix[7] = ((const char **)runpix7);
	runPix[8] = ((const char **)runpix8);
	runPix[9] = ((const char **)runpix9);
	runPix[10] = ((const char **)runpix10);
	runPix[11] = ((const char **)runpix11);
	QFrame *outFrame = new QFrame(this);
	outFrame->setGeometry(10,10,580,260);
	outFrame->setFrameStyle( QFrame::WinPanel | QFrame::Sunken);

	outScreen = new QMultiLineEdit(outFrame);
	outScreen->setReadOnly(true);
	outScreen->setGeometry(2,2,576,256);
	outScreen->insertLine(i18n("Welcome to your KWebGet - Project\n"
				"Project started ...."));

	statPixLab = new QLabel (this);
	statPixLab->setFrameStyle( QFrame::Panel | QFrame::Sunken );
	statPixLab->setGeometry(520,0,70,10);

	outDismiss = new QPushButton(i18n("Dismiss"), this);
	outDismiss->setGeometry(265,275,70,20);
	outDismiss->hide();

	outCancel = new QPushButton(i18n("Cancel"), this);
	outCancel->setGeometry(265,275,70,20);

	noScroll = new QCheckBox(i18n("Autoscroll"), this);
	noScroll->setGeometry(10,278,90,20);
	noScroll->setChecked(true);
}

OutputWidget::~OutputWidget()
{
}

void OutputWidget::timerEvent( QTimerEvent *ev)
{
	if (( tmr <= 11 )&&( dec )) {
		statPixLab->setPixmap(runPix[tmr]);
		tmr++;
		if ( tmr == 11 )
			dec = false;
	} else if (( tmr >= 0 ) && ( !dec )){
		statPixLab->setPixmap(runPix[tmr]);
		tmr--;
		if ( tmr == 0 )
			dec = true;
	}
}

void OutputWidget::closeEvent(QCloseEvent *e)
{
	if ( scheduling )
		this->hide();
}

void OutputWidget::getSchedInfo(bool sched)
{
	scheduling = sched;
}