/***************************************************************************
                          prefdialog.h  -  description
                             -------------------
    begin                : Wed Jan 26 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@skydsl.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PREFDIALOG_H
#define PREFDIALOG_H

#include <kapp.h>
#include <ktmainwindow.h>
#include <kiconloader.h>
#include <kfiledialog.h>

#include <qwidget.h>
#include <qdialog.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qdir.h>
#include <qmessagebox.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qtabdialog.h>
#include <qcheckbox.h>

/**
  *@author Frank von Daak
  */

class PrefDialog : public QDialog  {
   Q_OBJECT
public: 
	PrefDialog(QWidget * parent=0, const char * name=0, bool modal=FALSE, WFlags f=0);
	~PrefDialog();

	QWidget *pathConf, *startupConf, *proxyConf, *proxySetup, *loginConf;
	QPushButton *wgetBinBut;
	QLineEdit *wgetBinLine;
	KFileDialog *getWget;
	QRadioButton *wizBut, *advBut, *selBut;
	QTabDialog *prefTab, *proxyTab;

	QLineEdit *httpProxyusrLine, *httpProxypassLine, *httpProxyAdressLine,
			  *httpProxyPortLine, *emailLine;
	QCheckBox *httpProxyBox, *httpProxyloginBox;
	QLineEdit *ftpProxyAdressLine,
			  *ftpProxyPortLine;
	QCheckBox *ftpProxyBox, *storePassBut;
	QLabel *httpProxyusrLab, *httpProxypassLab;

private:
	void closeEvent(QCloseEvent *ce);
	void setPathConf();
	void setStartupConf();
	void setProxyConf();
	void setProxySetup();
	void setLoginConf();

public slots:
	void getWgetPath();
	void getHttpProxyLogin();
	void enableHttpProxy();
	void enableFtpProxy();
};

#endif
