/***************************************************************************
                          kfilereplacedoc.cpp  -  description
                             -------------------
    begin                : sam oct 16 15:28:00 CEST 1999
    copyright            : (C) 1999 by Franois Dupoux
    email                : fdupoux@lemel.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
// include files for Qt
#include <qdir.h>
#include <qfileinfo.h>
#include <qwidget.h>

// include files for KDE
#include <kapp.h>
#include <kmsgbox.h>

// application specific includes
#include <kfilereplacedoc.h>
#include "kfilereplace.h"
#include "kfilereplaceview.h"
#include "newproject1dlg.h"
#include "newproject2dlg.h"

QList<KFileReplaceView>* KFileReplaceDoc::viewList = 0L;


// ===========================================================================================================================
KFileReplaceDoc::KFileReplaceDoc(QWidget *parent, const char* name):QObject(parent, name)
{
	if( !viewList )
		viewList = new QList<KFileReplaceView>;
	viewList->setAutoDelete(true);

	// Initialize project data
	*m_szProjectDirectory = 0;
	*m_szProjectFilter = 0;
	m_bMinSize = false;
	m_bMaxSize = false;
	m_nMinSize = 0;
	m_nMaxSize = 0;
	m_nTypeOfAccess = 0;
	m_bMinDate = false;
	m_bMaxDate = false;

}

// ===========================================================================================================================
KFileReplaceDoc::~KFileReplaceDoc()
{
}

// ===========================================================================================================================
void KFileReplaceDoc::addView(KFileReplaceView* m_pView)
{
	viewList->append(m_pView);
}

// ===========================================================================================================================
void KFileReplaceDoc::removeView(KFileReplaceView* m_pView)
{
	viewList->remove(m_pView);
}

// ===========================================================================================================================
const QString& KFileReplaceDoc::getPathName() const
{
	return m_path;
}

// ===========================================================================================================================
void KFileReplaceDoc::slotUpdateAllViews(KFileReplaceView* pSender)
{
	KFileReplaceView* w;
	if(viewList)
	{
		for( w = viewList->first(); w; w = viewList->next() )
		{ if( w != pSender)
				w->repaint();
		}
	}

}

// ===========================================================================================================================
void KFileReplaceDoc::pathName( const char* path_name)
{
	m_path=path_name;
}

// ===========================================================================================================================
void KFileReplaceDoc::title( const char* title)
{
	m_title=title;
}

// ===========================================================================================================================
const QString& KFileReplaceDoc::getTitle() const
{
	return m_title;
}


// ===========================================================================================================================
void KFileReplaceDoc::closeDocument()
{
	deleteContents();
}

// ===========================================================================================================================
bool KFileReplaceDoc::newDocument()
{
	NewProject1Dlg dlg1(viewList->first());
	NewProject2Dlg dlg2(viewList->first());
  QString strAdding;
  int nRes;

BeginNewDoc:

	if (dlg1.exec() == QDialog::Rejected) // If Cancel
		return false;

	// Get the Directory and the Filter
	sprintf(m_szProjectDirectory, "%s", dlg1.m_strDir.data());
	sprintf(m_szProjectFilter, "%s", dlg1.m_strFilter.data());

	// Do the user choosed to have criters ?
	if (dlg1.m_bCriters)
	{	nRes = dlg2.exec();
		
		if (nRes == QDialog::Rejected) // If Cancel
			return false;	

		if (nRes == QDialog::Accepted) // If Continue
		{	m_nTypeOfAccess = dlg2.m_nTypeOfAccess;
			
			m_bMinDate = dlg2.m_bMinDate;
			m_bMaxDate = dlg2.m_bMaxDate;
			m_qdMinDate = dlg2.m_qdMinDate;
			m_qdMaxDate = dlg2.m_qdMaxDate;
			
			m_bMinSize = dlg2.m_bMinSize;
			m_bMaxSize = dlg2.m_bMaxSize;
			m_nMinSize = dlg2.m_nMinSize;
			m_nMaxSize = dlg2.m_nMaxSize;
		}

		if (nRes == 2) // If Back
		{	goto BeginNewDoc;
		}
	}

	b_modified=false;
	m_path=QDir::homeDirPath();
	m_title.sprintf("[%s, %s]", m_szProjectDirectory, m_szProjectFilter);
	return true;
}

// ===========================================================================================================================
bool KFileReplaceDoc::openDocument(const char* filename, const char* format)
{
	QFileInfo fileInfo(filename);
	m_title=fileInfo.fileName();
	m_path=fileInfo.absFilePath();	
	/////////////////////////////////////////////////
	// TODO: Add your document opening code here
	/////////////////////////////////////////////////
	
	b_modified=false;
	return true;
}

// ===========================================================================================================================
bool KFileReplaceDoc::saveDocument(const char* filename, const char* format)
{

	/////////////////////////////////////////////////
	// TODO: Add your document saving code here
	/////////////////////////////////////////////////

	b_modified=false;
	return true;
}

// ===========================================================================================================================
void KFileReplaceDoc::deleteContents()
{
	/////////////////////////////////////////////////
	// TODO: Add implementation to delete the document contents
	/////////////////////////////////////////////////

}

































