/***************************************************************************
                          resource.h  -  description
                             -------------------
    begin                : sam oct 16 15:28:00 CEST 1999
    copyright            : (C) 1999 by Franois Dupoux
    email                : fdupoux@lemel.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef RESOURCE_H
#define RESOURCE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

///////////////////////////////////////////////////////////////////
// resource.h  -- contains macros used for commands


///////////////////////////////////////////////////////////////////
// COMMAND VALUES FOR MENUBAR AND TOOLBAR ENTRIES


///////////////////////////////////////////////////////////////////
// File-menu entries
#define ID_FILE_NEW_WINDOW          10010
#define ID_FILE_NEW                 10020
#define ID_FILE_SEARCH              10030
#define ID_FILE_REPLACE             10040
#define ID_FILE_STOP                10050
#define ID_FILE_SAVE                10060
#define ID_FILE_QUIT                10070


///////////////////////////////////////////////////////////////////
// Strings-menu entries
#define ID_STRINGS_ADD              11010
#define ID_STRINGS_DEL              11020
#define ID_STRINGS_EMPTY            11030
#define ID_STRINGS_SAVE							11040
#define ID_STRINGS_LOAD							11050
#define ID_STRINGS_INVERTCUR				11060
#define ID_STRINGS_INVERTALL				11070
#define ID_STRINGS_EDIT							11080


///////////////////////////////////////////////////////////////////
// Strings-menu entries
#define ID_OPTIONS_RECURSIVE        12010
#define ID_OPTIONS_BAKUP            12020
#define ID_OPTIONS_CASESENSITIVE    12030


///////////////////////////////////////////////////////////////////
// View-menu entries                    
#define ID_VIEW_TOOLBAR             13010
#define ID_VIEW_STATUSBAR           13020


///////////////////////////////////////////////////////////////////
// Result-menu entries                    
#define ID_RESULT_INFO              14010
#define ID_RESULT_OPEN              14020
#define ID_RESULT_DIROPEN           14030
#define ID_RESULT_DELETE            14040

///////////////////////////////////////////////////////////////////
// Help-menu entries
#define ID_HELP_CONTENTS            1002
#define ID_HELP                     15000
#define ID_HELP_WEBSITE             15010
#define ID_HELP_ABOUT               15020

///////////////////////////////////////////////////////////////////
// General application values
#define ID_STATUS_MSG               1001

#define TAB_FILES                   0
#define TAB_TEXT                    1
#define TAB_DATESIZE                2
#define TAB_OPTIONS                 3

#define OPERATION_SEARCH						1
#define OPERATION_REPLACE						2

#define MAX_MESSAGE                 128
#define MAX_TEXTLEN                 256
#define MAX_STRINGSINCOMBO          10
#define MAX_STRINGSTOSEARCHREP      256

///////////////////////////////////////////////////////////////////
// Create cases for entries and connect them with their functions
#define ON_CMD(id, cmd_class_function)		case id:cmd_class_function ;break;
#define ON_STATUS_MSG(id, message)				case id:  slotStatusHelpMsg(message);break;


#endif // RESOURCE_H

