/**
 * descriptionwidget.h
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */
#ifndef DESCRIPTIONWIDGET_H
#define DESCRIPTIONWIDGET_H

#include <qwidget.h>

class QLabel;
class QTextEdit;

namespace KConfigEditor
{
    class EntryToken;

    class DescriptionWidget : public QWidget
    {
        Q_OBJECT
    public:
        DescriptionWidget( QWidget *parent );

        QString shortDescr() const;
        QString longDescr() const;

    public slots:
        void setShortDescr( const QString &text );
        void setLongDescr( const QString &text );
        void setFromToken( EntryToken *token );

    private:
        QLabel    *m_shortDescr;
        QTextEdit *m_longDescr;
    };
}

#endif
