//////////////////////////////////////////////////////////////////////////////
//
//    KEXIFUTILS.CPP
//
//    Copyright (C) 2002-2004 Renchi Raju <renchi at pooh.tam.uiuc.edu>
//                            Gilles CAULIER <caulier dot gilles at free.fr>
//                            Ralf Hoelzer <kde at ralfhoelzer.com>
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//////////////////////////////////////////////////////////////////////////////

#ifndef KEXIFLISTVIEW_H
#define KEXIFLISTVIEW_H

#include <klistview.h>
#include <qptrlist.h>

class KExifEntry;

class KExifListView : public KListView {

    Q_OBJECT

public:

    KExifListView(QWidget* parent);
    ~KExifListView();

    void addItems(const QPtrList<KExifEntry>& entryList);

private slots:

    void slot_selectionChanged(QListViewItem *item);

signals:

    void signal_itemDescription(const QString& desc);

};

#endif
