<?php
/**
 * $Horde: horde/admin/phpshell.php,v 1.11 2003/06/14 04:28:20 chuck Exp $
 *
 * Copyright 1999-2003 Chuck Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 */

define('HORDE_BASE', dirname(__FILE__) . '/..');
require_once HORDE_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/Menu.php';
require_once HORDE_BASE . '/lib/Help.php';

if (!Auth::isAdmin()) {
    Horde::fatal('Forbidden.', __FILE__, __LINE__);
}

Horde::compressOutput();

$title = _("PHP Shell");
require HORDE_TEMPLATES . '/common-header.inc';
require HORDE_TEMPLATES . '/admin/common-header.inc';

$apps = $registry->listApps();
$application = Horde::getFormData('app', 'horde');
?>
<form action="<?php echo $_SERVER['PHP_SELF'] ?>" method="post">
<?php Horde::pformInput() ?>

<div class="header">Application</div><br />
<select name="app">
<?php foreach ($apps as $app): ?>
  <option value="<?php echo $app ?>"<?php if ($application == $app) echo ' selected="selected"' ?>><?php echo $registry->getParam('name', $app) ?></option>
<?php endforeach; ?>
</select><br /><br />
<?php

if ($command = trim(Horde::getFormData('php'))) {
    if (@file_exists($registry->getParam('fileroot', $application) . '/lib/base.php')) {
        include $registry->getParam('fileroot', $application) . '/lib/base.php';
    } else {
        $registry->pushApp($application);
    }
    echo '<div class="header">' . _("PHP Code") . ':</div><br />';
    $pretty = Horde::bufferOutput('highlight_string', "<?php\n" . $command);
    echo '<table cellpadding="4" border="0"><tr><td class="text">' . preg_replace('|.*&lt;\?php<br />|', '', $pretty) . '</td></tr></table>';

    echo '<br /><div class="header">' . _("Results") . ':</div><br />';
    echo '<table cellpadding="4" border="0"><tr><td class="text"><pre>';
    eval($command);
    echo '</pre></td></tr></table><br />';
}
?>

<textarea class="fixed" name="php" rows="10" cols="60">
<?php if (!empty($command)) echo htmlspecialchars($command) ?></textarea>
<br />
<input type="submit" class="button" value="<?php echo _("Execute") ?>">
<?php if ($conf['user']['online_help'] && $browser->hasFeature('javascript')): ?>
    <?php Help::javascript(); ?>
    <td class="header" align="right"><?php echo Help::link('admin', 'admin-phpshell') ?></td>
<?php endif; ?>

</form>
<?php

require HORDE_TEMPLATES . '/common-footer.inc';
