<?php
/**
 * Maintenance module that presents a TOS Agreement page to user.
 * If user does not accept terms, user is not allowed to login.
 *
 * $Horde: imp/lib/Maintenance/Task/tos_agreement.php,v 1.6 2003/07/15 15:19:52 chuck Exp $
 *
 * Copyright 2002-2003 Michael Slusarz <slusarz@bigworm.colorado.edu>
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 *
 * @author  Michael Slusarz <slusarz@bigworm.colorado.edu>
 * @version $Revision: 1.6 $
 * @since   IMP 4.0
 * @package horde.maintenance
 */
class Maintenance_Task_tos_agreement extends Maintenance_Task {

    /**
     * The style of the maintenance page output.
     *
     * @var integer $_display_type
     */
    var $_display_type = MAINTENANCE_OUTPUT_AGREE;

    /**
     * Determine if user agreed with the terms or not.  If the user does not
     * agree, log him/her out immediately.
     *
     * @access public
     */
    function doMaintenance()
    {
        $result = Horde::getFormData('not_agree');
        if (isset($result)) {
           header('Location: ' . Horde::applicationUrl(IMP::logoutUrl('login.php', 'failed'), true));
           exit;
        }
    }

    /**
     * Returns the TOS agreement for display on the maintenance page.
     *
     * @access public
     *
     * @return string  The terms of service agreement.
     */
    function describeMaintenance()
    {
        global $conf;

        if (empty($conf['tos']['file'])) {
            Horde::fatal(PEAR::raiseError(sprintf(_("Terms of Service file not specified in conf.php"))), __FILE__, __LINE__);
        }

        $fp = @fopen($conf['tos']['file'], 'r');
        $contents = @fread($fp, filesize($conf['tos']['file']));
        @fclose($fp);
        return $contents;
    }

}
