<?php
/**
 * $Horde: kronolith/delevent.php,v 1.33 2003/05/22 21:48:28 chuck Exp $
 *
 * Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('KRONOLITH_BASE', dirname(__FILE__));
require_once KRONOLITH_BASE . '/lib/base.php';

$calendar = &Kronolith_Driver::factory($conf['calendar']['driver'], $conf['calendar']['params']);
$calendar->open(Horde::getFormData('calendar'));
$event = &$calendar->getEventObject(Horde::getFormData('eventID'));
if (!$event) {
    if (($url = Horde::getFormData('url')) === null) {
        $url = Horde::applicationUrl($prefs->getValue('defaultview') . '.php', true);
    }
    header('Location: ' . $url);
    exit;
} elseif ($event->hasRecurType(KRONOLITH_RECUR_NONE) &&
    !$prefs->getValue('confirm_delete')) {
    header('Location: ' . Horde::applicationUrl('deleventaction.php?' . $_SERVER['QUERY_STRING'], 1));
    exit;
}

if ($timestamp = Horde::getFormData('timestamp')) {
    $month = date('n', $timestamp);
    $year = date('Y', $timestamp);
    $day = date('j', $timestamp);
} else {
    $month = Horde::getFormData('month', date('n'));
    $day = Horde::getFormData('mday', date('j'));
    $year = Horde::getFormData('year', date('Y'));
}

$url = Horde::getFormData('url');

$title = sprintf(_("Delete %s"), $event->getTitle());
$js_onLoad = null;

require KRONOLITH_TEMPLATES . '/common-header.inc';
Kronolith::menu();
if ($event->hasRecurType(KRONOLITH_RECUR_NONE)) {
    require KRONOLITH_TEMPLATES . '/delete/one.inc';
} else {
    require KRONOLITH_TEMPLATES . '/delete/delete.inc';
}
require KRONOLITH_TEMPLATES . '/common-footer.inc';
