<?php
/**
 * Implementation of Horde_Block api to show notes summary.
 *
 * @package horde.block
 *
 * $Horde: mnemo/lib/Block/summary.php,v 1.4 2003/05/22 03:41:21 chuck Exp $
 */
class mnemo_summary_Block extends Horde_Block {

    function mnemo_summary_Block($params = array()) 
    {
        $this->_params = $params;
        $this->_app = 'mnemo';
        $this->_type = 'summary';
    }

    function isEditable() 
    {
        return false;
    }

    function _title() 
    {
        global $registry;
        $html  = Horde::link(Horde::url($registry->getInitialPage(), true), $registry->getParam('name'), 'header') . $registry->getParam('name') . '</a> - ';
        $html .= Horde::link(Horde::applicationUrl('memo.php?actionID=' . MNEMO_ADD_MEMO, true), _("New Note"), 'smallheader') . Horde::img('mnemo.gif', _("New Note"), 'hspace="5"', Horde::url($registry->getParam('graphics'), true, -1)) . _("New Note") . '</a>';

        return $html;
    }
    
    function _content() 
    {
        require_once dirname(__FILE__) . '/../base.php';
        global $registry, $prefs, $conf;

        if (!isset($conf['storage']['driver']) ||
            !isset($conf['storage']['params'])) {
            return PEAR::raiseError('Not configured');
        }

        $html = '<table border="0" cellpadding="0" cellspacing="0" width="100%">';
        $colors = Mnemo::categoryColors();

        $summaryCategories = explode(';', $prefs->getValue('summary_categories'));
        if ($summaryCategories != array('')) {
            $categories = array();
            foreach ($summaryCategories as $summaryColumn) {
                list($categories[],) = explode(',', $summaryColumn);
            }
        }

        $memos = _mnemo_list();
        foreach ($memos as $id => $memo) {
            if (isset($categories) && !in_array($memo['category'], $categories)) {
                continue;
            }

            $html .= '  <tr>';

            if ($prefs->getValue('summary_show_colors')) {
                $color = isset($colors[$memo['category']]) ? $colors[$memo['category']] : '#ffffff';
                $priority_cell = '<td width="20" align="center" style="background-color:' . $color . '">&nbsp;&nbsp;&nbsp;</td>';
                $spacer_cell = '<td width="3">&nbsp;</td>';
                $html .= $priority_cell . $spacer_cell;
            }

            $html .= '<td class="text">';
            $viewurl = Horde::addParameter('view.php', 'memo=' . $memo['memo_id']);
            $viewurl = Horde::addParameter($viewurl, 'memolist=' . $memo['memolist_id']);
            $html .= Horde::link(Horde::applicationUrl($viewurl, true), $memo['desc']) . htmlspecialchars($memo['desc']) . '</a>';
            $html .= "</td></tr>\n";
        }
        if (!count($memos)) {
            $html .= sprintf('<tr><td><i>%s</i></td></tr>', _("No notes to display"));
        }
        $html .= '</table>';

        return $html;
    }

}
