<?php
/**
 * Mnemo base inclusion file.
 *
 * $Horde: mnemo/lib/base.php,v 1.22 2003/04/23 13:52:13 jan Exp $
 *
 * This file brings in all of the dependencies that every Mnemo
 * script will need and sets up objects that all scripts use.
 */

// Find the base file path of Horde
@define('HORDE_BASE', dirname(__FILE__) . '/../..');

// Find the base file path of Mnemo
@define('MNEMO_BASE', dirname(__FILE__) . '/..');

// Registry
require_once HORDE_BASE . '/lib/Registry.php';
$registry = &Registry::singleton();
$registry->pushApp('mnemo');
$conf = &$GLOBALS['conf'];
@define('MNEMO_TEMPLATES', $registry->getParam('templates'));

// Horde base libraries
require_once HORDE_BASE . '/lib/Horde.php';
require_once HORDE_BASE . '/lib/Auth.php';
require_once HORDE_BASE . '/lib/Text.php';
require_once HORDE_BASE . '/lib/Help.php';

// Don't allow access unless there is a Horde login or guests are
// allowed.
if (!Auth::isAuthenticated() && !$registry->allowGuests()) {
    Horde::authenticationFailureRedirect();
}

// Mnemo base libraries
require_once MNEMO_BASE . '/lib/Mnemo.php';
require_once MNEMO_BASE . '/lib/Driver.php';

// Browser detection library
require_once HORDE_BASE . '/lib/Browser.php';
$browser = &Browser::singleton();

// Notification system
require_once HORDE_BASE . '/lib/Notification.php';
$notification = &Notification::singleton();
$notification->attach('status');

// Create a share instance.
require_once HORDE_BASE . '/lib/Share.php';
$GLOBALS['mnemo_shares'] = &Horde_Share::singleton($registry->getApp());

// Update the preference for which notepads to display. If the user
// doesn't have any selected notepads for view then fall back to some
// available notepad.
$GLOBALS['display_notepads'] = unserialize($GLOBALS['prefs']->getValue('display_notepads'));
if (($d_note = Horde::getFormData('display_notepad')) !== null) {
    if (in_array($d_note, $GLOBALS['display_notepads'])) {
        $key = array_search($d_note, $GLOBALS['display_notepads']);
        unset($GLOBALS['display_notepads'][$key]);
    } else {
        $GLOBALS['display_notepads'][] = $d_note;
    }
    $GLOBALS['prefs']->setValue('display_notepads', serialize($GLOBALS['display_notepads']));
}

// Make sure all task lists exist now, to save on checking later.
$_temp = $GLOBALS['display_notepads'];
$_all = Mnemo::listNotepads();
$GLOBALS['display_notepads'] = array();
foreach ($_temp as $id) {
    if (isset($_all[$id])) {
        $GLOBALS['display_notepads'][] = $id;
    }
}
$GLOBALS['prefs']->setValue('display_notepads', serialize($GLOBALS['display_notepads']));

// Make sure we have at least one notepad to work with.
if (count($GLOBALS['display_notepads']) == 0) {
    // Find a memo list to fall back on
    $lists = Mnemo::listNotepads(true);
    if (count($lists) > 0) {
        if (array_key_exists(Auth::getAuth(), $lists)) {
            // User's personal memo list
            $GLOBALS['display_notepads'] = array(Auth::getAuth());
        } else {
            // Some other memo list they own
           $GLOBALS['display_notepads'] = array(array_pop(array_keys($lists)));
        }
    } elseif (Auth::getAuth()) {
        // Create a personal memo list
        $GLOBALS['display_notepads'] = array(Auth::getAuth());

        // If this share doesn't exist then create it.
        if (!$GLOBALS['mnemo_shares']->exists(Auth::getAuth())) {
            require_once HORDE_BASE . '/lib/Identity.php';
            $identity = &new Identity();
            $name = $identity->getValue('fullname');
            if (trim($name) == '') {
                $name = Auth::removeHook(Auth::getAuth());
            }
            $share = $GLOBALS['mnemo_shares']->newShare(Auth::getAuth());
            $share->setOwner(Auth::getAuth(), false);
            $share->setShareName(sprintf(_("%s's Notepad"), $name), false);
            $GLOBALS['mnemo_shares']->addShare($share);
        }
    }
    $GLOBALS['prefs']->setValue('display_notepads', serialize($GLOBALS['display_notepads']));
}
