<?php
/**
 * $Horde: mnemo/list.php,v 1.16 2003/07/04 16:52:10 chuck Exp $
 *
 * Copyright 2001-2003 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

@define('MNEMO_BASE', dirname(__FILE__));
require_once MNEMO_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/Image.php';

/* Get the current action ID. */
$actionID = Horde::getFormData('actionID');

/* Sort out the sorting values. */
if (Horde::getFormData('sortby') !== null) {
    $prefs->setValue('sortby', Horde::getFormData('sortby'));
}
if (Horde::getFormData('sortdir') !== null) {
   $prefs->setValue('sortdir', Horde::getFormData('sortdir'));
}

/* Get the full, sorted notepad. */
$memos = Mnemo::listMemos(MEMO_ANY, $prefs->getValue('sortby'),
                          $prefs->getValue('sortdir'));

/* Page variables. */
$i = 0;
$title = _("Current Notepad");

switch ($actionID) {
case MNEMO_SEARCH_MEMOS:
    /* If we're searching, only list those notes that match the
        search result. */
    /* Get the search parameters. */
    $pattern = Horde::getFormData('search_pattern');
    $search_desc = (Horde::getFormData('search_desc') == 'on');
    $search_body = (Horde::getFormData('search_body') == 'on');

    if (!empty($pattern) && ($search_body || $search_desc)) {
        $pattern = '/' . preg_quote($pattern, '/') . '/i';
        $search_result = array();
        foreach ($memos as $memo_id => $memo) {
            if (($search_desc && preg_match($pattern, $memo['desc'])) || 
                ($search_body && preg_match($pattern, $memo['body']))) {
                $search_result[$memo_id] = $memo;
            }
        }

        /* Reassign $memos to the search result. */
        $memos = $search_result;
        $title = _("Search Results");
    }
    break;
}

require MNEMO_TEMPLATES . '/common-header.inc';
Mnemo::menu();
require MNEMO_TEMPLATES . '/list/javascript.inc';
require MNEMO_TEMPLATES . '/list/header.inc';

$colors = Mnemo::categoryColors();

if (count($memos) > 0) {
    require MNEMO_TEMPLATES . '/list/memo_headers.inc';

    foreach ($memos as $memo_id => $memo) {
        $color = isset($colors[$memo['category']]) ? $colors[$memo['category']] : '#ffffff';

        $viewurl = Horde::addParameter('view.php', 'memo=' . $memo['memo_id']);
        $viewurl = Horde::addParameter($viewurl, 'memolist=' . $memo['memolist_id']);

        $memourl = Horde::addParameter('memo.php', 'memo=' . $memo['memo_id']);
        $memourl = Horde::addParameter($memourl, 'memolist=' . $memo['memolist_id']);
        $share = $GLOBALS['mnemo_shares']->getShare($memo['memolist_id']);

        require MNEMO_TEMPLATES . '/list/memo_summaries.inc';
    }

    require MNEMO_TEMPLATES . '/list/memo_footers.inc';
} else {
    require MNEMO_TEMPLATES . '/list/empty.inc';
}

require MNEMO_TEMPLATES . '/list/footer.inc';
require MNEMO_TEMPLATES . '/common-footer.inc';
