<?php
/**
 * This class represent a view of mulitple free busy information.
 *
 * $Horde: moment/lib/View.php,v 1.7 2003/08/06 03:45:26 chuck Exp $
 *
 * Copyright 2003 Mike Cochrane <mike@graftonhall.co.nz>
 *
 * See the enclosed file LICENCE for license information.
 *
 * @author Mike Cochrane <mike@graftonhall.co.nz>
 * @package freebusy
 */
class Moment_View {

    var $_requiredMembers = array();
    var $_optionalMembers = array();

    /**
     * Attempts to return a concrete Moment_View instance based on $view.
     *
     * @param string    $view       The type of concrete Moment_View subclass
     *                              to return.
     *
     * @return mixed    The newly created concrete Moment_View instance, or
     *                  false on an error.
     */
    function &factory($view)
    {
        $driver = basename($view);
        require_once dirname(__FILE__) . '/View/' . $view . '.php';
        $class = 'Moment_View_' . $view;
        if (class_exists($class)) {
            return new $class($user, $params);
        } else {
            return false;
        }
    }

    /**
     * Attempts to return a reference to a concrete Moment_View instance
     * based on $view.  It wil only create a new instance if no
     * Moment_View instance with the same parameters currently exists.
     *
     * This method must be invoked as: $var = &Moment_View::singleton()
     *
     * @param string    $view       The type of concrete Moment_View subclass
     *                              to return.
     *
     * @return mixed    The created concrete Moment_View instance, or
     *                  false on an error.
     */
    function &singleton($view)
    {
        static $instances;

        if (!isset($instances)) {
            $instances = array();
        }

        if (!isset($instances[$view])) {
            $instances[$view] = &Moment_View::factory($view);
        }

        return $instances[$view];
    }

    function addRequiredMember(&$vFreebusy)
    {
        $this->_requiredMembers[] = $vFreebusy;
    }

    function addOptionalMember(&$vFreebusy)
    {
        $this->_optionalMembers[] = $vFreebusy;
    }

}
