<?php
/**
 * $Horde: turba/addlink.php,v 1.6 2003/07/08 02:41:05 mikec Exp $
 *
 * Copyright 2002-2003 Marcus I. Ryan <marcus@riboflavin.net>
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('TURBA_BASE', dirname(__FILE__));
require_once TURBA_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/Menu.php';

$return_url = Horde::getFormData('url');
$link_type = Horde::getFormData('link_type');
$reverse = (substr($link_type, -8) == '/reverse') ? '/reverse' : '';
if (!empty($reverse)) {
    $link_type = substr($link_type, 0, -8);
}
$from_application = Horde::getFormData('from_application');
$from_parameters = @unserialize(Horde::getFormData('from_parameters'));
$to_application = Horde::getFormData('to_application');

switch (Horde::getFormData('actionID')) {
case 'addlink_add':
    if (!empty($to_application)) {
        require_once HORDE_BASE . '/lib/Links.php';
        $links = &Horde_Links::singleton($registry->getApp());

        $to_parameters = @unserialize(Horde::getFormData('to_parameters'));
        if (!empty($reverse)) {
            $status = $links->addLink($to_application, $to_parameters, $from_application, $from_parameters, $link_type);
        } else {
            $status = $links->addLink($from_application, $from_parameters, $to_application, $to_parameters, $link_type);
        }

        if (is_a($status, 'PEAR_Error')) {
            $notification->push($status, 'horde.error');
        } elseif ($registry->hasMethod($to_application . '/getLinkSummary')) {
            $notification->push(sprintf(_("Added a %s link to %s."), $link_type,
                                        $registry->call($to_application . '/getLinkSummary', $to_parameters)), 'horde.success');
        } else {
            $notification->push(_("Link added."), 'horde.success');
        }

        header('Location: ' . $return_url);
        exit;
    }
    break;

case 'addlink_cancel':
    $notification->push(_("Link canceled."), 'horde.message');
    header('Location: ' . $return_url);
    exit;
}

/* Get the lists of address books through the API. */
$source_list = $registry->call('contacts/sources');

// If we self-submitted, use that source. Otherwise, choose a good
// source.
if (!($source = Horde::getFormData('source'))) {
    if ($prefs->getValue('add_source')) {
        // The most likely personal address book is the one we add to.
        $source = $prefs->getValue('add_source');
    } elseif ($prefs->getValue('search_sources')) {
        // If we can't/don't add, do we search?  If so take the first.
        $search_sources = $prefs->getValue('search_sources');
        $source = $search_sources[0];
    }
}
if (empty($source) || !isset($source_list[$source])) {
    $source = key($source_list);
}

/* Get the search as submitted (defaults to '' which should list everyone). */
$search = Horde::getFormData('search');
$apiargs = array();
$apiargs['addresses'] = array($search);
$apiargs['addressbooks'] = array($source);
$apiargs['fields'] = array();

if ($search_fields_pref = $prefs->getValue('search_fields')) {
    foreach (explode("\n", $search_fields_pref) as $s) {
        $s = trim($s);
        $s = explode("\t", $s);
        if (!empty($s[0]) && ($s[0] == $source)) {
            $apiargs['fields'][array_shift($s)] = $s;
            break;
        }
    }
}

$results = $registry->call('contacts/search', $apiargs);

/* The results list returns an array for each source searched - at
   least that's how it looks to me. Make it all one array instead. */
$addresses = array();
if (!PEAR::isError($results)) {
    foreach ($results as $r) {
        $addresses = array_merge($addresses, $r);
    }
}

/* If self-submitted, preserve the currently selected users encoded by
   javascript to pass as value|text. */
$selected_addresses = array();
foreach ($_GET as $key => $value) {
    if (substr($key, 0, 2) == 'sa') {
        $a = explode('|', $value);
        $selected_addresses[$a[0]] = $a[1];
    }
}

/* Set the default list display (name or email). */
$display = Horde::getFormData('display', 'name');

/* Display the form. */
$tabindex = 1;
$title = _("Contact List");
$js_onLoad = null;
require TURBA_TEMPLATES . '/common-header.inc';
require TURBA_TEMPLATES . '/addlink/menu.inc';
$notification->notify();
require TURBA_TEMPLATES . '/addlink/contacts.inc';
require TURBA_TEMPLATES . '/common-footer.inc';
