<?php
/**
 * $Horde: turba/displayobject.php,v 1.31 2003/05/22 19:42:42 chuck Exp $
 *
 * Turba: Copyright 2000-2003 Charles J. Hagenbuch <chuck@horde.org>
 *
 * You should have received a copy of the GNU Public
 * License along with this package; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

define('TURBA_BASE', dirname(__FILE__));
require_once TURBA_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/Form.php';
require_once TURBA_BASE . '/lib/Renderer.php';
require_once TURBA_BASE . '/lib/Source.php';
require_once TURBA_BASE . '/lib/ObjectView.php';
require_once TURBA_BASE . '/lib/ObjectForm.php';
require_once HORDE_BASE . '/lib/Links.php';

$links = &Horde_Links::singleton($registry->getApp());
$renderer = &new Turba_Renderer();
$vars = &Horde_Form::getDefaultVars();

$source = $vars->getVar('source');
if (!isset($cfgSources[$source])) {
    $notification->push(_("The object you requested does not exist."));
    header('Location: ' . Horde::applicationUrl($prefs->getValue('initial_page'), true));
    exit;
}

$driver = &Turba_Source::singleton($source, $cfgSources[$source]);

/* Get the form object. */
$displayform = &Horde_Form::singleton('ObjectForm', $vars);

/* Set the object from the key requested. */
$key = $vars->getVar('key');
$object = $driver->getObject($key);
if (is_a($object, 'PEAR_Error')) {
    $notification->push($object->getMessage(), 'horde.error');
    header('Location: ' . Horde::applicationUrl($prefs->getValue('initial_page'), true));
    exit;
}

/* Check permissions on this object. */
$readonly = false;
if (!Turba::checkPermissions($object, 'object', _PERMS_READ)) {
    $notification->push(_("You do not have permission to view this object."), 'horde.error');
    header('Location: ' . Horde::applicationUrl($prefs->getValue('initial_page'), true));
    exit;
}

$renderer->setObject($object);
$view = &new Turba_ObjectView($object);
$view->setFormVariables($displayform);

$vars = array();
/* Get the values through the AbstractObject class. */
foreach ($object->attributes as $info_key => $info_val) {
    $vars[$info_key] = $object->getValue($info_key);
}
$vars = &new Horde_Form_Vars(array('object' => $vars));
if ($title = $vars->getVar('object[name]')) {
    $displayform->setTitle($title);
}

$js_onLoad = null;
require TURBA_TEMPLATES . '/common-header.inc';
Turba::menu();
$displayform->renderInactive($renderer, $vars);
if ($links->listLinkTypes()) {
    $links->viewLinks(array('source' => $source,
                            'id' => $key));
}
require TURBA_TEMPLATES . '/common-footer.inc';
