/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.BarRenderer;
import com.jrefinery.chart.CategoryItemRenderer;
import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.Marker;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.chart.urls.CategoryURLGenerator;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.StatisticalCategoryDataset;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class VerticalStatisticalBarRenderer
extends BarRenderer
implements CategoryItemRenderer {
    public VerticalStatisticalBarRenderer() {
        this(null, null);
    }

    public VerticalStatisticalBarRenderer(CategoryToolTipGenerator categoryToolTipGenerator) {
        this(categoryToolTipGenerator, null);
    }

    public VerticalStatisticalBarRenderer(CategoryURLGenerator categoryURLGenerator) {
        this(null, categoryURLGenerator);
    }

    public VerticalStatisticalBarRenderer(CategoryToolTipGenerator categoryToolTipGenerator, CategoryURLGenerator categoryURLGenerator) {
        super(categoryToolTipGenerator, categoryURLGenerator);
    }

    public void initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, ValueAxis valueAxis, CategoryDataset categoryDataset, ChartRenderingInfo chartRenderingInfo) {
        super.initialise(graphics2D, rectangle2D, categoryPlot, valueAxis, categoryDataset, chartRenderingInfo);
        this.calculateCategoryAndItemSpans(graphics2D, rectangle2D, categoryPlot, categoryDataset, rectangle2D.getWidth());
    }

    public void drawRangeMarker(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D, Shape shape) {
        double d = valueAxis.translateValueToJava2D(marker.getValue(), rectangle2D);
        Line2D.Double double_ = new Line2D.Double(rectangle2D.getMinX(), d, rectangle2D.getMaxX(), d);
        graphics2D.setPaint(marker.getOutlinePaint());
        graphics2D.draw(double_);
    }

    public void drawCategoryItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, Object object, int n2, Object object2) {
        if (!(categoryDataset instanceof StatisticalCategoryDataset)) {
            throw new IllegalArgumentException("VerticalStatisticalBarRenderer.drawCategoryItem() : the data should be of type StatisticalCategoryDataSet only.");
        }
        StatisticalCategoryDataset statisticalCategoryDataset = (StatisticalCategoryDataset)categoryDataset;
        double d = rectangle2D.getX() + rectangle2D.getWidth() * categoryPlot.getIntroGapPercent();
        int n3 = categoryDataset.getCategoryCount();
        int n4 = categoryDataset.getSeriesCount();
        if (n3 > 1) {
            d = d + (double)n2 * (this.categorySpan / (double)n3) + ((double)n2 * (this.categoryGapSpan / (double)(n3 - 1)) + (double)n * this.itemSpan / (double)(n3 * n4));
            if (n4 > 1) {
                d += (double)n * this.itemGapSpan / (double)(n3 * (n4 - 1));
            }
        } else {
            d += (double)n * this.itemSpan / (double)(n3 * n4);
            if (n4 > 1) {
                d += (double)n * this.itemGapSpan / (double)(n3 * (n4 - 1));
            }
        }
        Number number = statisticalCategoryDataset.getMeanValue(n, object);
        double d2 = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D);
        double d3 = Math.min(this.zeroInJava2D, d2);
        double d4 = this.itemWidth;
        double d5 = Math.abs(d2 - this.zeroInJava2D);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d3, d4, d5);
        Paint paint = categoryPlot.getSeriesPaint(n);
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (this.itemWidth > 3.0) {
            graphics2D.setStroke(categoryPlot.getSeriesStroke(n));
            graphics2D.setPaint(categoryPlot.getSeriesOutlinePaint(n));
            graphics2D.draw(double_);
        }
        double d6 = statisticalCategoryDataset.getStdDevValue(n, object).doubleValue();
        double d7 = valueAxis.translateValueToJava2D(number.doubleValue() + d6, rectangle2D);
        double d8 = valueAxis.translateValueToJava2D(number.doubleValue() - d6, rectangle2D);
        Line2D.Double double_2 = null;
        double_2 = new Line2D.Double(d + d4 / 2.0, d8, d + d4 / 2.0, d7);
        graphics2D.draw(double_2);
        double_2 = new Line2D.Double(d + d4 / 2.0 - 5.0, d7, d + d4 / 2.0 + 5.0, d7);
        graphics2D.draw(double_2);
        double_2 = new Line2D.Double(d + d4 / 2.0 - 5.0, d8, d + d4 / 2.0 + 5.0, d8);
        graphics2D.draw(double_2);
    }

    public boolean hasItemGaps() {
        return true;
    }

    public int barWidthsPerCategory(CategoryDataset categoryDataset) {
        return categoryDataset.getSeriesCount();
    }

    public Rectangle2D getAxisArea(Rectangle2D rectangle2D) {
        return rectangle2D;
    }
}

