/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.AbstractSeriesDataset;
import com.jrefinery.data.DatasetUtilities;
import com.jrefinery.data.IntervalCategoryDataset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;

public class DefaultIntervalCategoryDataset
extends AbstractSeriesDataset
implements IntervalCategoryDataset {
    private String[] seriesNames;
    private Object[] categories;
    private Number[][] startData;
    private Number[][] endData;

    public DefaultIntervalCategoryDataset(double[][] dArray, double[][] dArray2) {
        this(DatasetUtilities.createNumberArray2D(dArray), DatasetUtilities.createNumberArray2D(dArray2));
    }

    public DefaultIntervalCategoryDataset(Number[][] numberArray, Number[][] numberArray2) {
        this(null, null, numberArray, numberArray2);
    }

    public DefaultIntervalCategoryDataset(String[] stringArray, Number[][] numberArray, Number[][] numberArray2) {
        this(stringArray, null, numberArray, numberArray2);
    }

    public DefaultIntervalCategoryDataset(String[] stringArray, Object[] objectArray, Number[][] numberArray, Number[][] numberArray2) {
        this.startData = numberArray;
        this.endData = numberArray2;
        if (numberArray != null && numberArray2 != null) {
            String string = "com.jrefinery.data.resources.DataPackageResources";
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string);
            int n = numberArray.length;
            if (n != numberArray2.length) {
                String string2 = "DefaultIntervalCategoryDataset: the number of series in the start value dataset does not match the number of series in the end value dataset.";
                throw new IllegalArgumentException(string2);
            }
            if (n > 0) {
                if (stringArray != null) {
                    if (stringArray.length != n) {
                        throw new IllegalArgumentException("DefaultIntervalCategoryDataset: the number of series names does not match the number of series in the data.");
                    }
                    this.seriesNames = stringArray;
                } else {
                    String string3 = resourceBundle.getString("series.default-prefix") + " ";
                    this.seriesNames = this.generateNames(n, string3);
                }
                int n2 = numberArray[0].length;
                if (n2 != numberArray2[0].length) {
                    String string4 = "DefaultIntervalCategoryDataset: the number of categories in the start value dataset does not match the number of categories in the end value dataset.";
                    throw new IllegalArgumentException(string4);
                }
                if (objectArray != null) {
                    if (objectArray.length != n2) {
                        throw new IllegalArgumentException("DefaultIntervalCategoryDataset: the number of categories does not match the number of categories in the data.");
                    }
                    this.categories = objectArray;
                } else {
                    String string5 = resourceBundle.getString("categories.default-prefix") + " ";
                    this.categories = this.generateNames(n2, string5);
                }
            } else {
                this.seriesNames = null;
                this.categories = null;
            }
        }
    }

    public int getSeriesCount() {
        int n = 0;
        if (this.startData != null) {
            n = this.startData.length;
        }
        return n;
    }

    public String getSeriesName(int n) {
        if (n >= this.getSeriesCount() || n < 0) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.getSeriesName(int): no such series.");
        }
        return this.seriesNames[n];
    }

    public void setSeriesNames(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.setSeriesNames(): null not permitted.");
        }
        if (stringArray.length != this.getSeriesCount()) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.setSeriesNames(): the number of series names does not match the data.");
        }
        this.seriesNames = stringArray;
        this.fireDatasetChanged();
    }

    public int getCategoryCount() {
        int n = 0;
        if (this.startData != null && this.getSeriesCount() > 0) {
            n = this.startData[0].length;
        }
        return n;
    }

    public List getCategories() {
        if (this.categories == null) {
            return new ArrayList();
        }
        return Collections.unmodifiableList(Arrays.asList(this.categories));
    }

    public void setCategories(Object[] objectArray) {
        if (objectArray == null) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.setCategories(...): null not permitted.");
        }
        if (objectArray.length != this.startData[0].length) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.setCategories(...): the number of categories does not match the data.");
        }
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == null) {
                throw new IllegalArgumentException("DefaultIntervalCategoryDataset.setCategories(...): null category not permitted.");
            }
            ++n;
        }
        this.categories = objectArray;
        this.fireDatasetChanged();
    }

    public Number getValue(int n, Object object) {
        return this.getEndValue(n, object);
    }

    public Number getStartValue(int n, Object object) {
        if (n < 0 || n >= this.getSeriesCount()) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.getValue(...): series index out of range.");
        }
        if (object == null) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.getValue(...): null category not allowed.");
        }
        int n2 = this.getCategoryIndex(object);
        if (n2 < 0) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.getValue(...): unknown category.");
        }
        return this.startData[n][n2];
    }

    public Number getEndValue(int n, Object object) {
        if (n < 0 || n >= this.getSeriesCount()) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.getValue(...): series index out of range.");
        }
        if (object == null) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.getValue(...): null category not allowed.");
        }
        int n2 = this.getCategoryIndex(object);
        if (n2 < 0) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.getValue(...): unknown category.");
        }
        return this.endData[n][n2];
    }

    public void setStartValue(int n, Object object, Number number) {
        if (n < 0 || n > this.getSeriesCount()) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.setValue: series outside valid range.");
        }
        int n2 = this.getCategoryIndex(object);
        if (n2 < 0) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.setValue: unrecognised category.");
        }
        this.startData[n][n2] = number;
        this.fireDatasetChanged();
    }

    public void setEndValue(int n, Object object, Number number) {
        if (n < 0 || n > this.getSeriesCount()) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.setValue: series outside valid range.");
        }
        int n2 = this.getCategoryIndex(object);
        if (n2 < 0) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.setValue: unrecognised category.");
        }
        this.endData[n][n2] = number;
        this.fireDatasetChanged();
    }

    private int getCategoryIndex(Object object) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.categories.length) {
            if (object.equals(this.categories[n2])) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    private String[] generateNames(int n, String string) {
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            String string2;
            stringArray[n2] = string2 = string + (n2 + 1);
            ++n2;
        }
        return stringArray;
    }
}

