/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.AbstractSeriesDataset;
import com.jrefinery.data.WindDataItem;
import com.jrefinery.data.WindDataset;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class DefaultWindDataset
extends AbstractSeriesDataset
implements WindDataset {
    private List seriesNames;
    private List allSeriesData;

    public DefaultWindDataset() {
        this.seriesNames = new ArrayList();
        this.allSeriesData = new ArrayList();
    }

    public DefaultWindDataset(Object[][][] objectArray) {
        this(DefaultWindDataset.seriesNameListFromDataArray((Object[][])objectArray), objectArray);
    }

    public DefaultWindDataset(String[] stringArray, Object[][][] objectArray) {
        this(Arrays.asList(stringArray), objectArray);
    }

    public DefaultWindDataset(List list, Object[][][] objectArray) {
        this.seriesNames = list;
        int n = objectArray.length;
        this.allSeriesData = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            ArrayList<WindDataItem> arrayList = new ArrayList<WindDataItem>();
            int n3 = objectArray[n2].length;
            int n4 = 0;
            while (n4 < n3) {
                Object object = objectArray[n2][n4][0];
                if (object != null) {
                    Serializable serializable;
                    Number number = null;
                    if (object instanceof Number) {
                        number = (Number)object;
                    } else if (object instanceof Date) {
                        serializable = (Date)object;
                        number = new Long(serializable.getTime());
                    } else {
                        number = new Integer(0);
                    }
                    serializable = (Number)objectArray[n2][n4][1];
                    Number number2 = (Number)objectArray[n2][n4][2];
                    arrayList.add(new WindDataItem(number, (Number)serializable, number2));
                }
                ++n4;
            }
            Collections.sort(arrayList);
            this.allSeriesData.add(n2, arrayList);
            ++n2;
        }
    }

    public int getSeriesCount() {
        return this.allSeriesData.size();
    }

    public int getItemCount(int n) {
        List list = (List)this.allSeriesData.get(n);
        return list.size();
    }

    public String getSeriesName(int n) {
        return this.seriesNames.get(n).toString();
    }

    public Number getXValue(int n, int n2) {
        List list = (List)this.allSeriesData.get(n);
        WindDataItem windDataItem = (WindDataItem)list.get(n2);
        return windDataItem.x;
    }

    public Number getYValue(int n, int n2) {
        return this.getWindForce(n, n2);
    }

    public Number getWindDirection(int n, int n2) {
        List list = (List)this.allSeriesData.get(n);
        WindDataItem windDataItem = (WindDataItem)list.get(n2);
        return windDataItem.windDir;
    }

    public Number getWindForce(int n, int n2) {
        List list = (List)this.allSeriesData.get(n);
        WindDataItem windDataItem = (WindDataItem)list.get(n2);
        return windDataItem.windForce;
    }

    public static List seriesNameListFromDataArray(Object[][] objectArray) {
        int n = objectArray.length;
        ArrayList<String> arrayList = new ArrayList<String>(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add("Series " + (n2 + 1));
            ++n2;
        }
        return arrayList;
    }
}

