/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.swing.JComboBox;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.NodeListModel;
import org.openide.explorer.view.NodeRenderer;
import org.openide.explorer.view.Visualizer;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;

public class ChoiceView
extends JComboBox
implements Externalizable {
    static final long serialVersionUID = 2522310031223476067L;
    private transient ExplorerManager manager;
    private transient PropertyIL iListener;
    private transient NodeListModel model;
    private boolean showExploredContext = true;

    public ChoiceView() {
        this.initializeChoice();
    }

    private void initializeChoice() {
        this.setRenderer(new NodeRenderer());
        this.model = this.createModel();
        this.setModel(this.model);
        this.iListener = new PropertyIL();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(new Boolean(this.showExploredContext));
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.showExploredContext = (Boolean)objectInput.readObject();
    }

    protected NodeListModel createModel() {
        return new NodeListModel();
    }

    public void setShowExploredContext(boolean bl) {
        this.showExploredContext = bl;
        this.updateChoice();
    }

    public boolean getShowExploredContext() {
        return this.showExploredContext;
    }

    public void addNotify() {
        this.manager = ExplorerManager.find(this);
        this.manager.addVetoableChangeListener(this.iListener);
        this.manager.addPropertyChangeListener(this.iListener);
        this.updateChoice();
        this.addActionListener(this.iListener);
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeActionListener(this.iListener);
        this.manager.removeVetoableChangeListener(this.iListener);
        this.manager.removePropertyChangeListener(this.iListener);
    }

    private void updateSelection() {
        Node[] nodeArray = this.manager.getSelectedNodes();
        if (nodeArray.length > 0) {
            this.setSelectedItem(VisualizerNode.getVisualizer(null, nodeArray[0]));
        } else {
            this.setSelectedItem(this.showExploredContext ? this.manager.getExploredContext() : this.manager.getRootContext());
        }
    }

    private void updateChoice() {
        if (this.showExploredContext) {
            this.model.setNode(this.manager.getExploredContext());
        } else {
            this.model.setNode(this.manager.getRootContext());
        }
        this.updateSelection();
    }

    final class PropertyIL
    implements PropertyChangeListener,
    VetoableChangeListener,
    ActionListener {
        PropertyIL() {
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            Node[] nodeArray;
            if ("selectedNodes".equals(propertyChangeEvent.getPropertyName()) && (nodeArray = (Node[])propertyChangeEvent.getNewValue()).length > 1) {
                throw new PropertyVetoException("", propertyChangeEvent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            block6: {
                block7: {
                    block5: {
                        block4: {
                            ChoiceView.this.removeActionListener(this);
                            try {
                                if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                                    Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
                                    ChoiceView.this.updateSelection();
                                    Object var4_3 = null;
                                    break block4;
                                }
                                if (!ChoiceView.this.showExploredContext && "rootContext".equals(propertyChangeEvent.getPropertyName())) {
                                    ChoiceView.this.updateChoice();
                                    break block5;
                                }
                                if (!ChoiceView.this.showExploredContext || !"exploredContext".equals(propertyChangeEvent.getPropertyName())) break block6;
                                ChoiceView.this.updateChoice();
                                break block7;
                            }
                            catch (Throwable throwable) {
                                Object var4_7 = null;
                                ChoiceView.this.addActionListener(this);
                                throw throwable;
                            }
                        }
                        ChoiceView.this.addActionListener(this);
                        return;
                    }
                    Object var4_4 = null;
                    ChoiceView.this.addActionListener(this);
                    return;
                }
                Object var4_5 = null;
                ChoiceView.this.addActionListener(this);
                return;
            }
            Object var4_6 = null;
            ChoiceView.this.addActionListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            int n = ChoiceView.this.getSelectedIndex();
            if (n < 0 || n >= ChoiceView.this.model.getSize()) {
                return;
            }
            Node node = Visualizer.findNode(ChoiceView.this.model.getElementAt(n));
            ChoiceView.this.manager.removeVetoableChangeListener(this);
            ChoiceView.this.manager.removePropertyChangeListener(this);
            try {
                try {
                    ChoiceView.this.manager.setSelectedNodes(new Node[]{node});
                }
                catch (PropertyVetoException propertyVetoException) {
                    ChoiceView.this.updateChoice();
                    Object var6_5 = null;
                    ChoiceView.this.manager.addVetoableChangeListener(this);
                    ChoiceView.this.manager.addPropertyChangeListener(this);
                }
                Object var6_4 = null;
                ChoiceView.this.manager.addVetoableChangeListener(this);
                ChoiceView.this.manager.addPropertyChangeListener(this);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                ChoiceView.this.manager.addVetoableChangeListener(this);
                ChoiceView.this.manager.addPropertyChangeListener(this);
                throw throwable;
            }
        }
    }
}

