/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Dialog;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.IOException;
import java.util.TooManyListenersException;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.openide.ErrorManager;
import org.openide.explorer.view.DragDropUtilities;
import org.openide.explorer.view.ExplorerDnDManager;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

abstract class ExplorerDragSupport
implements DragSourceListener,
DragGestureListener {
    boolean active = false;
    DragGestureRecognizer defaultGesture;
    protected JComponent comp;
    ExplorerDnDManager exDnD = ExplorerDnDManager.getDefault();
    static /* synthetic */ Class class$java$awt$Dialog;

    ExplorerDragSupport() {
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        Node[] nodeArray = this.obtainNodes(dragGestureEvent);
        if (nodeArray == null || nodeArray.length == 0) {
            return;
        }
        int n = 2;
        int n2 = 0;
        while (n2 < nodeArray.length) {
            if (n == 2 && !nodeArray[n2].canCut()) {
                n = 1;
            }
            if (n == 1 && !nodeArray[n2].canCopy()) {
                n = 0;
            }
            ++n2;
        }
        this.exDnD = ExplorerDnDManager.getDefault();
        this.exDnD.setAllowedDragActions(n);
        int n3 = dragGestureEvent.getDragAction();
        boolean bl = this.canDrag(n3, n);
        try {
            Transferable transferable;
            if (n == 2) {
                transferable = DragDropUtilities.getNodeTransferable(nodeArray, 2);
                this.exDnD.setDraggedTransferable(transferable, true);
                transferable = DragDropUtilities.getNodeTransferable(nodeArray, 1);
                this.exDnD.setDraggedTransferable(transferable, false);
            } else {
                transferable = DragDropUtilities.getNodeTransferable(nodeArray, 1);
                this.exDnD.setDraggedTransferable(transferable, false);
            }
            this.exDnD.setDraggedNodes(nodeArray);
            Dialog dialog = (Dialog)SwingUtilities.getAncestorOfClass(class$java$awt$Dialog == null ? (class$java$awt$Dialog = ExplorerDragSupport.class$("java.awt.Dialog")) : class$java$awt$Dialog, this.comp);
            if (dialog != null && dialog.isModal()) {
                this.exDnD.setDnDActive(false);
                return;
            }
            dragGestureEvent.startDrag(DragDropUtilities.chooseCursor(n3, bl), Utilities.loadImage("org/openide/resources/cursorscopysingle.gif"), new Point(16, 16), transferable, this);
            this.exDnD.setDnDActive(true);
        }
        catch (InvalidDnDOperationException invalidDnDOperationException) {
            ErrorManager errorManager = ErrorManager.getDefault();
            Throwable throwable = errorManager.annotate(new Throwable(invalidDnDOperationException.getMessage()), "JDK bug #4656769. You have to restart window manager.");
            errorManager.notify(16, throwable);
            this.exDnD.setDnDActive(false);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(iOException);
            this.exDnD.setDnDActive(false);
        }
    }

    private boolean canDrag(int n, int n2) {
        switch (n2) {
            case 2: {
                return true;
            }
            case 1: 
            case 3: 
            case 0x40000000: {
                return n != 2;
            }
        }
        return n == 0;
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        dragSourceDragEvent.getDragSourceContext().setCursor(DragDropUtilities.chooseCursor(dragSourceDragEvent.getDropAction(), this.canDrag(dragSourceDragEvent.getUserAction(), this.exDnD.getAllowedDragActions())));
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        dragSourceDragEvent.getDragSourceContext().setCursor(DragDropUtilities.chooseCursor(dragSourceDragEvent.getDropAction(), this.canDrag(dragSourceDragEvent.getUserAction(), this.exDnD.getAllowedDragActions())));
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
        dragSourceEvent.getDragSourceContext().setCursor(DragDropUtilities.chooseCursor(dragSourceEvent.getDragSourceContext().getSourceActions(), false));
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        this.exDnD.setDraggedTransferable(null, true);
        this.exDnD.setDraggedTransferable(null, false);
        this.exDnD.setDraggedNodes(null);
    }

    public void activate(boolean bl) {
        if (this.active == bl) {
            return;
        }
        this.active = bl;
        DragGestureRecognizer dragGestureRecognizer = this.getDefaultGestureRecognizer();
        if (bl) {
            dragGestureRecognizer.setSourceActions(this.exDnD.getSupportedDragActions());
            try {
                dragGestureRecognizer.removeDragGestureListener(this);
                dragGestureRecognizer.addDragGestureListener(this);
            }
            catch (TooManyListenersException tooManyListenersException) {
                throw new IllegalStateException("Too many listeners for drag gesture.");
            }
        } else {
            dragGestureRecognizer.removeDragGestureListener(this);
        }
    }

    DragGestureRecognizer getDefaultGestureRecognizer() {
        if (this.defaultGesture == null) {
            DragSource dragSource = DragSource.getDefaultDragSource();
            this.defaultGesture = dragSource.createDefaultDragGestureRecognizer(this.comp, this.exDnD.getSupportedDragActions(), this);
        }
        return this.defaultGesture;
    }

    abstract Node[] obtainNodes(DragGestureEvent var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

