/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.WeakSet;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.windows.TopComponent;

public abstract class NodeAction
extends CallableSystemAction {
    private static final long serialVersionUID = -5672895970450115226L;
    private static final String PROP_HAS_LISTENERS = "hasListeners";
    private static final String PROP_LAST_NODES = "lastNodes";
    private static final String PROP_LAST_ENABLED = "lastEnabled";
    private static NodesL l;
    private static final Set listeningActions;

    protected void initialize() {
        super.initialize();
        this.putProperty(PROP_HAS_LISTENERS, Boolean.FALSE);
        this.putProperty("enabled", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNotify() {
        super.addNotify();
        this.putProperty(PROP_HAS_LISTENERS, Boolean.TRUE);
        Set set = listeningActions;
        synchronized (set) {
            if (l == null) {
                l = new NodesL();
            }
            if (listeningActions.isEmpty()) {
                l.setActive(true);
            }
            listeningActions.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeNotify() {
        Set set = listeningActions;
        synchronized (set) {
            listeningActions.remove(this);
            if (listeningActions.isEmpty()) {
                l.setActive(false);
            }
        }
        this.putProperty(PROP_HAS_LISTENERS, Boolean.FALSE);
        this.putProperty("enabled", null);
        super.removeNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        Object object;
        Node[] nodeArray = null;
        Boolean bl = null;
        Object object2 = this.getLock();
        synchronized (object2) {
            bl = (Boolean)this.getProperty("enabled");
            if (bl == null) {
                nodeArray = NodeAction.getActivatedNodes(this.surviveFocusChange());
                object = (Reference)this.getProperty(PROP_LAST_NODES);
                if (object != null && ((Reference)object).get() == nodeArray) {
                    bl = (Boolean)this.getProperty(PROP_LAST_ENABLED);
                    if (((Boolean)this.getProperty(PROP_HAS_LISTENERS)).booleanValue()) {
                        this.putProperty("enabled", bl);
                    }
                }
            }
        }
        if (bl == null) {
            bl = nodeArray != null && this.enable(nodeArray) ? Boolean.TRUE : Boolean.FALSE;
            object = this.getLock();
            synchronized (object) {
                this.putProperty(PROP_LAST_NODES, new WeakReference<Node[]>(nodeArray));
                this.putProperty(PROP_LAST_ENABLED, bl);
                if (((Boolean)this.getProperty(PROP_HAS_LISTENERS)).booleanValue()) {
                    this.putProperty("enabled", bl);
                }
            }
        }
        return bl;
    }

    public void setEnabled(boolean bl) {
        this.putProperty(PROP_LAST_ENABLED, null);
        this.putProperty(PROP_LAST_NODES, null);
        if (((Boolean)this.getProperty(PROP_HAS_LISTENERS)).booleanValue()) {
            super.setEnabled(bl);
        } else {
            this.putProperty("enabled", null, true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2 = object = actionEvent == null ? null : actionEvent.getSource();
        if (object instanceof Node) {
            this.performAction(new Node[]{(Node)object});
        } else if (object instanceof Node[]) {
            this.performAction((Node[])object);
        } else {
            this.performAction();
        }
    }

    public void performAction() {
        this.performAction(this.getActivatedNodes());
    }

    public final Node[] getActivatedNodes() {
        TopComponent.Registry registry = CallbackSystemAction.getRegistry();
        if (registry != null) {
            return registry.getActivatedNodes();
        }
        ExplorerManager explorerManager = CallbackSystemAction.getExplorerManager();
        if (explorerManager != null) {
            return explorerManager.getSelectedNodes();
        }
        return new Node[0];
    }

    protected boolean surviveFocusChange() {
        return true;
    }

    protected abstract void performAction(Node[] var1);

    protected abstract boolean enable(Node[] var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void maybeFireEnabledChange() {
        boolean bl = false;
        Object object = this.getLock();
        synchronized (object) {
            if (this.getProperty("enabled") != null) {
                this.putProperty("enabled", null);
                bl = true;
            }
        }
        if (bl) {
            this.firePropertyChange("enabled", null, null);
        }
    }

    private static Node[] getActivatedNodes(boolean bl) {
        TopComponent.Registry registry = CallbackSystemAction.getRegistry();
        if (registry != null) {
            if (bl) {
                return registry.getActivatedNodes();
            }
            return registry.getCurrentNodes();
        }
        ExplorerManager explorerManager = CallbackSystemAction.getExplorerManager();
        if (explorerManager != null) {
            return explorerManager.getSelectedNodes();
        }
        return new Node[0];
    }

    static {
        listeningActions = new WeakSet(100);
    }

    private static final class NodesL
    implements PropertyChangeListener {
        private boolean chgSFC = false;
        private boolean chgNSFC = false;

        void setActive(boolean bl) {
            TopComponent.Registry registry = CallbackSystemAction.getRegistry();
            if (registry != null) {
                if (bl) {
                    registry.addPropertyChangeListener(this);
                } else {
                    registry.removePropertyChangeListener(this);
                    this.forget(true);
                    this.forget(false);
                }
            } else {
                ExplorerManager explorerManager = CallbackSystemAction.getExplorerManager();
                if (explorerManager != null) {
                    if (bl) {
                        explorerManager.addPropertyChangeListener(this);
                    } else {
                        explorerManager.removePropertyChangeListener(this);
                        this.forget(true);
                        this.forget(false);
                    }
                }
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            boolean bl = false;
            if (string == null || string.equals("activatedNodes")) {
                this.chgSFC = true;
                bl = true;
            }
            if (string == null || string.equals("currentNodes")) {
                this.chgNSFC = true;
                bl = true;
            }
            if (string == null || string.equals("selectedNodes")) {
                this.chgSFC = true;
                this.chgNSFC = true;
                bl = true;
            }
            if (bl) {
                this.update();
            }
        }

        public void update() {
            if (this.chgSFC) {
                this.forget(true);
                this.chgSFC = false;
            }
            if (this.chgNSFC) {
                this.forget(false);
                this.chgNSFC = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void forget(boolean bl) {
            Iterator iterator;
            ArrayList arrayList;
            Set set = listeningActions;
            synchronized (set) {
                arrayList = new ArrayList(listeningActions.size());
                iterator = listeningActions.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                NodeAction nodeAction = (NodeAction)iterator.next();
                if (nodeAction.surviveFocusChange() != bl) continue;
                nodeAction.maybeFireEnabledChange();
            }
        }
    }
}

