/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM /export/home/sean/sandbox/1.0/mozilla/dom/public/idl/range/nsIDOMRange.idl
 */

#ifndef __gen_nsIDOMRange_h__
#define __gen_nsIDOMRange_h__


#ifndef __gen_domstubs_h__
#include "domstubs.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif

/* starting interface:    nsIDOMRange */
#define NS_IDOMRANGE_IID_STR "a6cf90ce-15b3-11d2-932e-00805f8add32"

#define NS_IDOMRANGE_IID \
  {0xa6cf90ce, 0x15b3, 0x11d2, \
    { 0x93, 0x2e, 0x00, 0x80, 0x5f, 0x8a, 0xdd, 0x32 }}

class NS_NO_VTABLE nsIDOMRange : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IDOMRANGE_IID)

  /**
   * CompareHow group
   * Passed as a parameter to the compareBoundaryPoints method.
   */
  enum { START_TO_START = 0U };

  enum { START_TO_END = 1U };

  enum { END_TO_START = 2U };

  enum { END_TO_END = 3U };

  /* readonly attribute nsIDOMNode startContainer; */
  NS_IMETHOD GetStartContainer(nsIDOMNode * *aStartContainer) = 0;

  /* readonly attribute long startOffset; */
  NS_IMETHOD GetStartOffset(PRInt32 *aStartOffset) = 0;

  /* readonly attribute nsIDOMNode endContainer; */
  NS_IMETHOD GetEndContainer(nsIDOMNode * *aEndContainer) = 0;

  /* readonly attribute long endOffset; */
  NS_IMETHOD GetEndOffset(PRInt32 *aEndOffset) = 0;

  /* readonly attribute boolean collapsed; */
  NS_IMETHOD GetCollapsed(PRBool *aCollapsed) = 0;

  /* readonly attribute nsIDOMNode commonAncestorContainer; */
  NS_IMETHOD GetCommonAncestorContainer(nsIDOMNode * *aCommonAncestorContainer) = 0;

  /**
     * Sets the attributes describing the start of the Range. The start 
     * position of a Range is guaranteed to never be after the end position.
     * To enforce this restriction, if the start is set to be at a position
     * after the end, the Range is collapsed to that position
     * @param parent      The Parent Node value. This parameter must not be null. 
     * @param offset      start offset value.
     */
  /* void setStart (in nsIDOMNode parent, in long offset); */
  NS_IMETHOD SetStart(nsIDOMNode *parent, PRInt32 offset) = 0;

  /**
     * Sets the start position to be before the specified node.
     * @param sibling     Range starts before sibling Node. 
     */
  /* void setStartBefore (in nsIDOMNode sibling); */
  NS_IMETHOD SetStartBefore(nsIDOMNode *sibling) = 0;

  /**
     * Sets the start position to be after the specified node.
     * @param sibling     Range starts after sibling Node. 
     */
  /* void setStartAfter (in nsIDOMNode sibling); */
  NS_IMETHOD SetStartAfter(nsIDOMNode *sibling) = 0;

  /**
     * Sets the attributes describing the end of a Range.  If the
     * end is set to be at a position before the start, the Range
     * is collapsed to that position.
     * @param parent      The Parent Node value. This parameter must not be null. 
     * @param offset      end offset value.
     */
  /* void setEnd (in nsIDOMNode parent, in long offset); */
  NS_IMETHOD SetEnd(nsIDOMNode *parent, PRInt32 offset) = 0;

  /**
     * Sets the end position to be before the specified node
     * @param sibling     Range ends before sibling Node. 
     */
  /* void setEndBefore (in nsIDOMNode sibling); */
  NS_IMETHOD SetEndBefore(nsIDOMNode *sibling) = 0;

  /**
     * Sets the end position to be after the specified node
     * @param sibling     Range ends before sibling Node. 
     */
  /* void setEndAfter (in nsIDOMNode sibling); */
  NS_IMETHOD SetEndAfter(nsIDOMNode *sibling) = 0;

  /**
     * Collapse a Range onto one of its boundary-points 
     * @param toStart     If TRUE. collapses the Range onto its start,
     *                    if FALSE, collapses onto its end.
     */
  /* void collapse (in boolean toStart); */
  NS_IMETHOD Collapse(PRBool toStart) = 0;

  /**
     * Select a node and its contents.  Replaces the 
     * contents of the range with this node.
     * @param n           The Node to select.
     */
  /* void selectNode (in nsIDOMNode n); */
  NS_IMETHOD SelectNode(nsIDOMNode *n) = 0;

  /**
     * Select the contents within a node.  Replace the 
     * contents of the range with this node's contents.
     * @param n           Node to select from. 
     */
  /* void selectNodeContents (in nsIDOMNode n); */
  NS_IMETHOD SelectNodeContents(nsIDOMNode *n) = 0;

  /**
     * Compare the boundary-points of two Ranges in a document.
     * @param how         parameter from CompareHow group, how the boundary points
     *                    are to be compared. 
     * @param srcRange    the range which will have its boundary points compared. 
     * Return Value:      -1, 0 or 1 depending on whether the corresponding 
     *                    boundary-point of the Range is before, equal to, or after the
     *                    corresponding boundary-point of sourceRange. 
     */
  /* long compareBoundaryPoints (in unsigned short how, in nsIDOMRange srcRange); */
  NS_IMETHOD CompareBoundaryPoints(PRUint16 how, nsIDOMRange *srcRange, PRInt32 *_retval) = 0;

  /**
     * Removes the contents of a Range from the containing document or document
     * fragment without returning a reference to the removed content.
     */
  /* void deleteContents (); */
  NS_IMETHOD DeleteContents(void) = 0;

  /**
     * Moves the contents of a Range from the containing document or document
     * fragment to a new DocumentFragment. 
     * Return Value:      A DocumentFragment containing the extracted contents. 
     */
  /* nsIDOMDocumentFragment extractContents (); */
  NS_IMETHOD ExtractContents(nsIDOMDocumentFragment **_retval) = 0;

  /**
     * Duplicates the contents of a Range  
     * Return Value:      A DocumentFragment that contains content equivalent to this Range. 
     */
  /* nsIDOMDocumentFragment cloneContents (); */
  NS_IMETHOD CloneContents(nsIDOMDocumentFragment **_retval) = 0;

  /**
     * Inserts a node into the Document or DocumentFragment at the start of the Range.
     * If the container is a Text node, this will be split at the start of the Range.
     * Adjacent Text nodes will not be automatically merged.
     * @param n           The node to insert at the start of the Range 
     */
  /* void insertNode (in nsIDOMNode n); */
  NS_IMETHOD InsertNode(nsIDOMNode *n) = 0;

  /**
     * Reparents the contents of the Range to the given node and inserts
     * the node at the position of the start of the Range. 
     * @param n          The node to surround the contents with.
     */
  /* void surroundContents (in nsIDOMNode n); */
  NS_IMETHOD SurroundContents(nsIDOMNode *n) = 0;

  /**
     * Produces a new Range whose boundary-points are equal to the
     * boundary-points of the Range. 
     * Return Value:      The duplicated Range. 
     */
  /* nsIDOMRange cloneRange (); */
  NS_IMETHOD CloneRange(nsIDOMRange **_retval) = 0;

  /**
     * Called to indicate that the Range is no longer in use and that
     * the implementation may relinquish any resources associated with
     * this Range. Subsequent calls to any methods or attribute getters
     * on this Range will result in a DOMException being thrown with an
     * error code of INVALID_STATE_ERR. 
     */
  /* void detach (); */
  NS_IMETHOD Detach(void) = 0;

  /**
     * Returns the contents of a Range as a string. This string contains
     * only the data characters, not any markup. 
     * Return Value:      The contents of the Range.
     */
  /* DOMString toString (); */
  NS_IMETHOD ToString(nsAString & _retval) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIDOMRANGE \
  NS_IMETHOD GetStartContainer(nsIDOMNode * *aStartContainer); \
  NS_IMETHOD GetStartOffset(PRInt32 *aStartOffset); \
  NS_IMETHOD GetEndContainer(nsIDOMNode * *aEndContainer); \
  NS_IMETHOD GetEndOffset(PRInt32 *aEndOffset); \
  NS_IMETHOD GetCollapsed(PRBool *aCollapsed); \
  NS_IMETHOD GetCommonAncestorContainer(nsIDOMNode * *aCommonAncestorContainer); \
  NS_IMETHOD SetStart(nsIDOMNode *parent, PRInt32 offset); \
  NS_IMETHOD SetStartBefore(nsIDOMNode *sibling); \
  NS_IMETHOD SetStartAfter(nsIDOMNode *sibling); \
  NS_IMETHOD SetEnd(nsIDOMNode *parent, PRInt32 offset); \
  NS_IMETHOD SetEndBefore(nsIDOMNode *sibling); \
  NS_IMETHOD SetEndAfter(nsIDOMNode *sibling); \
  NS_IMETHOD Collapse(PRBool toStart); \
  NS_IMETHOD SelectNode(nsIDOMNode *n); \
  NS_IMETHOD SelectNodeContents(nsIDOMNode *n); \
  NS_IMETHOD CompareBoundaryPoints(PRUint16 how, nsIDOMRange *srcRange, PRInt32 *_retval); \
  NS_IMETHOD DeleteContents(void); \
  NS_IMETHOD ExtractContents(nsIDOMDocumentFragment **_retval); \
  NS_IMETHOD CloneContents(nsIDOMDocumentFragment **_retval); \
  NS_IMETHOD InsertNode(nsIDOMNode *n); \
  NS_IMETHOD SurroundContents(nsIDOMNode *n); \
  NS_IMETHOD CloneRange(nsIDOMRange **_retval); \
  NS_IMETHOD Detach(void); \
  NS_IMETHOD ToString(nsAString & _retval); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIDOMRANGE(_to) \
  NS_IMETHOD GetStartContainer(nsIDOMNode * *aStartContainer) { return _to GetStartContainer(aStartContainer); } \
  NS_IMETHOD GetStartOffset(PRInt32 *aStartOffset) { return _to GetStartOffset(aStartOffset); } \
  NS_IMETHOD GetEndContainer(nsIDOMNode * *aEndContainer) { return _to GetEndContainer(aEndContainer); } \
  NS_IMETHOD GetEndOffset(PRInt32 *aEndOffset) { return _to GetEndOffset(aEndOffset); } \
  NS_IMETHOD GetCollapsed(PRBool *aCollapsed) { return _to GetCollapsed(aCollapsed); } \
  NS_IMETHOD GetCommonAncestorContainer(nsIDOMNode * *aCommonAncestorContainer) { return _to GetCommonAncestorContainer(aCommonAncestorContainer); } \
  NS_IMETHOD SetStart(nsIDOMNode *parent, PRInt32 offset) { return _to SetStart(parent, offset); } \
  NS_IMETHOD SetStartBefore(nsIDOMNode *sibling) { return _to SetStartBefore(sibling); } \
  NS_IMETHOD SetStartAfter(nsIDOMNode *sibling) { return _to SetStartAfter(sibling); } \
  NS_IMETHOD SetEnd(nsIDOMNode *parent, PRInt32 offset) { return _to SetEnd(parent, offset); } \
  NS_IMETHOD SetEndBefore(nsIDOMNode *sibling) { return _to SetEndBefore(sibling); } \
  NS_IMETHOD SetEndAfter(nsIDOMNode *sibling) { return _to SetEndAfter(sibling); } \
  NS_IMETHOD Collapse(PRBool toStart) { return _to Collapse(toStart); } \
  NS_IMETHOD SelectNode(nsIDOMNode *n) { return _to SelectNode(n); } \
  NS_IMETHOD SelectNodeContents(nsIDOMNode *n) { return _to SelectNodeContents(n); } \
  NS_IMETHOD CompareBoundaryPoints(PRUint16 how, nsIDOMRange *srcRange, PRInt32 *_retval) { return _to CompareBoundaryPoints(how, srcRange, _retval); } \
  NS_IMETHOD DeleteContents(void) { return _to DeleteContents(); } \
  NS_IMETHOD ExtractContents(nsIDOMDocumentFragment **_retval) { return _to ExtractContents(_retval); } \
  NS_IMETHOD CloneContents(nsIDOMDocumentFragment **_retval) { return _to CloneContents(_retval); } \
  NS_IMETHOD InsertNode(nsIDOMNode *n) { return _to InsertNode(n); } \
  NS_IMETHOD SurroundContents(nsIDOMNode *n) { return _to SurroundContents(n); } \
  NS_IMETHOD CloneRange(nsIDOMRange **_retval) { return _to CloneRange(_retval); } \
  NS_IMETHOD Detach(void) { return _to Detach(); } \
  NS_IMETHOD ToString(nsAString & _retval) { return _to ToString(_retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIDOMRANGE(_to) \
  NS_IMETHOD GetStartContainer(nsIDOMNode * *aStartContainer) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetStartContainer(aStartContainer); } \
  NS_IMETHOD GetStartOffset(PRInt32 *aStartOffset) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetStartOffset(aStartOffset); } \
  NS_IMETHOD GetEndContainer(nsIDOMNode * *aEndContainer) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetEndContainer(aEndContainer); } \
  NS_IMETHOD GetEndOffset(PRInt32 *aEndOffset) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetEndOffset(aEndOffset); } \
  NS_IMETHOD GetCollapsed(PRBool *aCollapsed) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCollapsed(aCollapsed); } \
  NS_IMETHOD GetCommonAncestorContainer(nsIDOMNode * *aCommonAncestorContainer) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCommonAncestorContainer(aCommonAncestorContainer); } \
  NS_IMETHOD SetStart(nsIDOMNode *parent, PRInt32 offset) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetStart(parent, offset); } \
  NS_IMETHOD SetStartBefore(nsIDOMNode *sibling) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetStartBefore(sibling); } \
  NS_IMETHOD SetStartAfter(nsIDOMNode *sibling) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetStartAfter(sibling); } \
  NS_IMETHOD SetEnd(nsIDOMNode *parent, PRInt32 offset) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetEnd(parent, offset); } \
  NS_IMETHOD SetEndBefore(nsIDOMNode *sibling) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetEndBefore(sibling); } \
  NS_IMETHOD SetEndAfter(nsIDOMNode *sibling) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetEndAfter(sibling); } \
  NS_IMETHOD Collapse(PRBool toStart) { return !_to ? NS_ERROR_NULL_POINTER : _to->Collapse(toStart); } \
  NS_IMETHOD SelectNode(nsIDOMNode *n) { return !_to ? NS_ERROR_NULL_POINTER : _to->SelectNode(n); } \
  NS_IMETHOD SelectNodeContents(nsIDOMNode *n) { return !_to ? NS_ERROR_NULL_POINTER : _to->SelectNodeContents(n); } \
  NS_IMETHOD CompareBoundaryPoints(PRUint16 how, nsIDOMRange *srcRange, PRInt32 *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->CompareBoundaryPoints(how, srcRange, _retval); } \
  NS_IMETHOD DeleteContents(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteContents(); } \
  NS_IMETHOD ExtractContents(nsIDOMDocumentFragment **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->ExtractContents(_retval); } \
  NS_IMETHOD CloneContents(nsIDOMDocumentFragment **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->CloneContents(_retval); } \
  NS_IMETHOD InsertNode(nsIDOMNode *n) { return !_to ? NS_ERROR_NULL_POINTER : _to->InsertNode(n); } \
  NS_IMETHOD SurroundContents(nsIDOMNode *n) { return !_to ? NS_ERROR_NULL_POINTER : _to->SurroundContents(n); } \
  NS_IMETHOD CloneRange(nsIDOMRange **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->CloneRange(_retval); } \
  NS_IMETHOD Detach(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->Detach(); } \
  NS_IMETHOD ToString(nsAString & _retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->ToString(_retval); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsDOMRange : public nsIDOMRange
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIDOMRANGE

  nsDOMRange();
  virtual ~nsDOMRange();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsDOMRange, nsIDOMRange)

nsDOMRange::nsDOMRange()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsDOMRange::~nsDOMRange()
{
  /* destructor code */
}

/* readonly attribute nsIDOMNode startContainer; */
NS_IMETHODIMP nsDOMRange::GetStartContainer(nsIDOMNode * *aStartContainer)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute long startOffset; */
NS_IMETHODIMP nsDOMRange::GetStartOffset(PRInt32 *aStartOffset)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIDOMNode endContainer; */
NS_IMETHODIMP nsDOMRange::GetEndContainer(nsIDOMNode * *aEndContainer)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute long endOffset; */
NS_IMETHODIMP nsDOMRange::GetEndOffset(PRInt32 *aEndOffset)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean collapsed; */
NS_IMETHODIMP nsDOMRange::GetCollapsed(PRBool *aCollapsed)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIDOMNode commonAncestorContainer; */
NS_IMETHODIMP nsDOMRange::GetCommonAncestorContainer(nsIDOMNode * *aCommonAncestorContainer)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setStart (in nsIDOMNode parent, in long offset); */
NS_IMETHODIMP nsDOMRange::SetStart(nsIDOMNode *parent, PRInt32 offset)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setStartBefore (in nsIDOMNode sibling); */
NS_IMETHODIMP nsDOMRange::SetStartBefore(nsIDOMNode *sibling)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setStartAfter (in nsIDOMNode sibling); */
NS_IMETHODIMP nsDOMRange::SetStartAfter(nsIDOMNode *sibling)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setEnd (in nsIDOMNode parent, in long offset); */
NS_IMETHODIMP nsDOMRange::SetEnd(nsIDOMNode *parent, PRInt32 offset)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setEndBefore (in nsIDOMNode sibling); */
NS_IMETHODIMP nsDOMRange::SetEndBefore(nsIDOMNode *sibling)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setEndAfter (in nsIDOMNode sibling); */
NS_IMETHODIMP nsDOMRange::SetEndAfter(nsIDOMNode *sibling)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void collapse (in boolean toStart); */
NS_IMETHODIMP nsDOMRange::Collapse(PRBool toStart)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void selectNode (in nsIDOMNode n); */
NS_IMETHODIMP nsDOMRange::SelectNode(nsIDOMNode *n)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void selectNodeContents (in nsIDOMNode n); */
NS_IMETHODIMP nsDOMRange::SelectNodeContents(nsIDOMNode *n)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* long compareBoundaryPoints (in unsigned short how, in nsIDOMRange srcRange); */
NS_IMETHODIMP nsDOMRange::CompareBoundaryPoints(PRUint16 how, nsIDOMRange *srcRange, PRInt32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void deleteContents (); */
NS_IMETHODIMP nsDOMRange::DeleteContents()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMDocumentFragment extractContents (); */
NS_IMETHODIMP nsDOMRange::ExtractContents(nsIDOMDocumentFragment **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMDocumentFragment cloneContents (); */
NS_IMETHODIMP nsDOMRange::CloneContents(nsIDOMDocumentFragment **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void insertNode (in nsIDOMNode n); */
NS_IMETHODIMP nsDOMRange::InsertNode(nsIDOMNode *n)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void surroundContents (in nsIDOMNode n); */
NS_IMETHODIMP nsDOMRange::SurroundContents(nsIDOMNode *n)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIDOMRange cloneRange (); */
NS_IMETHODIMP nsDOMRange::CloneRange(nsIDOMRange **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void detach (); */
NS_IMETHODIMP nsDOMRange::Detach()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* DOMString toString (); */
NS_IMETHODIMP nsDOMRange::ToString(nsAString & _retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIDOMRange_h__ */
