/*************************************************************************
 *
 *  $RCSfile: iothreads.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: jbu $ $Date: 2001/03/16 08:40:43 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <stdio.h>
#include <list>

#include <com/sun/star/uno/Sequence.hxx>
#include <com/sun/star/corba/giop/RequestHeader_1_2.hpp>
#include <com/sun/star/corba/giop/ReplyHeader_1_2.hpp>

#include <osl/thread.hxx>

#include <bridges/remote/context.h>
#include <bridges/remote/unmarshal.hxx>



namespace bridges_remote
{

class OWriterThread;

class OReaderThread :
	public ::osl::Thread
{
public:
	OReaderThread( remote_Connection *pConnection ,
				   void ( SAL_CALL * doRequest ) ( void * ),
				   uno_Environment *pEnvRemote,
				   OWriterThread *pWriterThread );
	~OReaderThread();
	
	virtual void SAL_CALL run();
	virtual void SAL_CALL onTerminated();

	void destroyYourself()
		{ m_bDestroyMyself = sal_True; }
	void sendMessageError();
	void abort();
	
private:
	remote_Connection *m_pConnection;
	void ( SAL_CALL * m_doRequest ) ( void * );
	uno_Environment *m_pEnvRemote;
	OWriterThread *m_pWriterThread;
	sal_Int32 m_nMessageErrorCount;
	sal_Bool m_bDestroyMyself;
};

class OWriterThread :
	public ::osl::Thread
{
public:
	OWriterThread( remote_Connection *pConnection );
	~OWriterThread(  );
	
	virtual void SAL_CALL run();

	void enqueue( const ::com::sun::star::uno::Sequence< sal_Int8 > &seq );

	void abort();
private:
	::osl::Mutex m_mutex;
	oslCondition m_oslCondition;

	sal_Bool m_bAbort;
	remote_Connection *m_pConnection;
	::std::list < ::com::sun::star::uno::Sequence< sal_Int8 > > m_lst;
	
};

class RequestInfo
{
public:
	RequestInfo( uno_Environment *pEnvRemote,
				 const ::com::sun::star::uno::Sequence< sal_Int8 > &,
				 sal_Bool bIsLittleEndian );

	~RequestInfo( );
public:
	uno_Environment *m_pEnvRemote; // Weak
	::com::sun::star::corba::giop::RequestHeader_1_2 m_requestHeader;
	::com::sun::star::uno::Sequence< sal_Int8 > m_seqBody;
	Unmarshal m_unmarshal;
	sal_Bool m_bIsLittleEndian;
	
};

class ReplyInfo
{
public:
	ReplyInfo( uno_Environment *pEnvRemote,
			   const ::com::sun::star::uno::Sequence< sal_Int8 > &,
			   sal_Bool bIsLittleEndian );
	~ReplyInfo( );
	
public:
	uno_Environment *m_pEnvRemote; 
	::com::sun::star::corba::giop::ReplyHeader_1_2   m_replyHeader;
	::com::sun::star::uno::Sequence< sal_Int8 > m_seqBody;
	Unmarshal m_unmarshal;
	sal_Bool m_bIsLittleEndian;
};

void SAL_CALL sendCloseConnection( uno_Environment *pEnvUno );


//--------------------------------------------
// the bridge internal per environment data
//--------------------------------------------




}

