/*************************************************************************
 *
 *  $RCSfile: cntvwitm.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2003/04/17 16:57:35 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CNTVWITM_HXX
#define _CNTVWITM_HXX

#ifndef _CNTWIDS_HRC
#include <svtools/cntwids.hrc>
#endif
#ifndef _SVTOOLS_CENUMITM_HXX
#include <svtools/cenumitm.hxx>
#endif
#ifndef _SVTOOLS_CUSTRITM_HXX
#include <svtools/custritm.hxx>
#endif


namespace chaos {

//============================================================================

enum CntOpenMode
{
	CNT_OPEN_ALL,     	// result all children
	CNT_OPEN_FOLDERS, 	// result only folders
	CNT_OPEN_DOCUMENT, 	// open document content
						// 	-> fill WID_[MESSAGE|DOCUMENT]BODY item (obsolete)
						//  -> fill a given data sink interface implementation
	CNT_OPEN_DOCUMENTS, // result only documents */
	CNT_OPEN_CLOSE_ALL,
	CNT_OPEN_RENOTIFY_GRANDCHILDREN,
	CNT_OPEN_CANCEL_OPEN,
	CNT_OPEN_MODE_COUNT
};

// Compatibility.
#define CNT_OPEN_MESSAGE	CNT_OPEN_DOCUMENT
#define CNT_OPEN_MESSAGES	CNT_OPEN_DOCUMENTS

//============================================================================

class CntNameItem : public CntUnencodedStringItem
{
private:
	String 						aRealName;

public:

								TYPEINFO();

								CntNameItem()
									: CntUnencodedStringItem() {}
								CntNameItem( USHORT nWhich, const String& rStr )
									: CntUnencodedStringItem( nWhich, rStr ) {}
								CntNameItem( const CntNameItem& rItm )
									: CntUnencodedStringItem( rItm )
								{
									aRealName = rItm.aRealName;
								}

	void			 			SetValue( const String& rNewVal )
								{
									CntUnencodedStringItem::SetValue( rNewVal );
									aRealName.Erase();
								}

	const String&				GetRealName() const;

	virtual int 			 	operator==( const SfxPoolItem& ) const;
	virtual int					Compare( const SfxPoolItem &rWith ) const;

	virtual USHORT				GetVersion(USHORT) const;

	virtual SfxPoolItem*	 	Clone( SfxItemPool* pPool=0 ) const;
	virtual SfxPoolItem*	 	Create( SvStream&, USHORT ) const;
	virtual SvStream&		 	Store( SvStream&, USHORT ) const;

	virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePresentation,
									SfxMapUnit eCoreMetric,
									SfxMapUnit ePresentationMetric,
									XubString &rText,
                                    const IntlWrapper * = 0 ) const;
};

//============================================================================

enum CntPriority
{
	CNT_PRIO_HIGHEST = 1,
	CNT_PRIO_HIGH	 = 2,
	CNT_PRIO_NORMAL  = 3,
	CNT_PRIO_LOW 	 = 4,
	CNT_PRIO_LOWEST  = 5
};

class CntPriorityItem : public CntEnumItem
{
public:
								TYPEINFO();

								CntPriorityItem(
									USHORT nWhich = WID_PRIORITY,
									CntPriority ePrio = CNT_PRIO_NORMAL );

								CntPriorityItem(
									USHORT nWhich,
									const String& rValue );

	virtual SfxPoolItem*	 	Clone( SfxItemPool* pPool=0 ) const;
	virtual SfxPoolItem*	 	Create( SvStream&, USHORT ) const;
	virtual SvStream&		 	Store( SvStream&, USHORT ) const;
	virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePresentation,
									SfxMapUnit eCoreMetric,
									SfxMapUnit ePresentationMetric,
									XubString &rText,
                                    const IntlWrapper * = 0 ) const;

	virtual USHORT			 	GetValueCount() const;
	virtual String			 	GetValueTextByPos( USHORT nPos ) const;

	String						GetValueText() const;

	CntPriorityItem& 			operator=(const CntPriorityItem& rPrio )
	{
        SetValue( rPrio.GetValue() );
        return *this;
    }
	virtual int					Compare( const SfxPoolItem &rWith ) const;

	virtual	BOOL PutValue  ( const com::sun::star::uno::Any& rVal,
						     BYTE nMemberId = 0 );
	virtual	BOOL QueryValue( com::sun::star::uno::Any& rVal,
							 BYTE nMemberId = 0 ) const;
};

//============================================================================

} // namespace chaos

#endif
