/*************************************************************************
 *
 *  $RCSfile: segmentheap.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: jb $ $Date: 2002/02/11 14:55:52 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "segmentheap.hxx"

#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif

// -----------------------------------------------------------------------------	

namespace configmgr
{
// -----------------------------------------------------------------------------	
    namespace memory
    {
    // -------------------------------------------------------------------------
        const Heap::Size c_nMaxHeapSize = 0x40000000;
        const Heap::Size c_nGrowFactor  = 2;

    // -------------------------------------------------------------------------

        SegmentHeap::~SegmentHeap()
        {
            m_heap.destroyLock(m_lock);
        }
    // -------------------------------------------------------------------------

        void SegmentHeap::init()
        {
            m_lock = m_heap.createLock();
            m_base = m_heap.base();

            OSL_ENSURE(m_lock,"Could not create heap lock");
        }
    // -------------------------------------------------------------------------

        Heap::Address SegmentHeap::allocateMore(Size _sz)
        {
            Size nCurSize = m_heap.size();

            OSL_ENSURE(_sz <= c_nMaxHeapSize,"Cannot allocate: Allocation request too large");
            if (_sz > c_nMaxHeapSize) return 0;

            Size nCurSizeLimit = (c_nMaxHeapSize-_sz)/c_nGrowFactor;
            OSL_ENSURE(nCurSize < nCurSizeLimit,"Allocation will reach heap limit");

            Size nNewSize = (nCurSize < nCurSizeLimit ) 
                                ? nCurSize * c_nGrowFactor + _sz 
                                : c_nMaxHeapSize;

            if (m_heap.grow(nNewSize))
            {
                m_base = m_heap.base();

                Address aResult = m_heap.allocate(_sz);

                OSL_ENSURE(aResult,"Cannot allocate even after growing heap");

                return aResult;
            }
            else
            {
                OSL_ENSURE(false,"Cannot allocate: Heap could not be grown");
                return 0;
            }
        }
    // -------------------------------------------------------------------------
    }
// -----------------------------------------------------------------------------	
} // namespace configmgr


