/*************************************************************************
 *
 *  $RCSfile: ConfigTest.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:13:43 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

import java.lang.Object;                      
import java.util.StringTokenizer;                     
import java.util.Vector;
import java.text.DateFormat;

import java.io.*;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.IBridge;
import com.sun.star.uno.XInterface;
import com.sun.star.util.XChangesBatch;
import com.sun.star.container.XNameReplace;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnector;
import com.sun.star.uno.XNamingService;

public class ConfigTest extends Thread implements com.sun.star.util.XChangesListener
{
	// Global Things
	// the size of the tabulator
	String                           tab                 = "  ";	
	String                           sScriptFile         = "";
	String                           sOutPut             = "";
	int                              ieinzug             = 0;
	private XMultiServiceFactory     myConfigProvider    = null;	
	java.util.Hashtable              myConfigItems       = new java.util.Hashtable();	
	XMultiServiceFactory             myServiceManager    = null;
    String                           output              = "";	
    java.io.BufferedWriter           bufWriter           = null;
    StringBuffer                     outputBuffer        = new StringBuffer();
//---------------------------------------------------------------------------
	/**
    * ConfigTest
    * 
    * 
    * 
    */	
	ConfigTest(String myScriptFile, XMultiServiceFactory myServiceManager)
	{
	    //super(); 
	    this.sScriptFile = myScriptFile;
	    this.myServiceManager = myServiceManager;	
	    this.setName(myScriptFile.substring(0,myScriptFile.indexOf(".")));
	}
//---------------------------------------------------------------------------
	/**
    * run
    * 
    * 
    * 
    */
	public void run()
	{    
        readConfigSection(this.sScriptFile);
        setOutPut();
	    createConfigManager();
	    doTest(this.sScriptFile);	    
	    outputOutput();
	}
//---------------------------------------------------------------------------
	/**
    * setOutput
    * 
    * 
    * 
    */
	private void setOutPut()
	{    
        try
        {
            if ( myConfigItems.get("output").equals("file"))
            {
                sOutPut = "file";
            }
            else
            {
                sOutPut = "screen";
            }
        }
        catch(Exception e)
        {
            sOutPut = "screen";
        }
        
	}
//------------------------------------------------
	/**
    * createConfigManager
    * @param myConnection - a connection to a StarOffice
    * 
    * 
    */
	private void createConfigManager()
    {        
	    Object [] ConInfo = new Object[]
        {
            new com.sun.star.beans.PropertyValue("user",0,myConfigItems.get("user"),com.sun.star.beans.PropertyState.DIRECT_VALUE),
            new com.sun.star.beans.PropertyValue("password",0,myConfigItems.get("password"),com.sun.star.beans.PropertyState.DIRECT_VALUE)
        };
        try
        {
            Object rConfigProv = myServiceManager.createInstanceWithArguments("com.sun.star.configuration.ConfigurationProvider",ConInfo);                                		    
		    if(rConfigProv != null)
		    {
    		    myConfigProvider  = (com.sun.star.lang.XMultiServiceFactory)UnoRuntime.queryInterface(com.sun.star.lang.XMultiServiceFactory.class, rConfigProv);							    						     
    		    if (myConfigProvider == null)
    		    {
    			    myprintln("Could not query XMultiServiceFactory from ConfigProvider");
		            this.stop();    
    		    }
		    }
		    else
		    {
    		    myprintln("No ConfigProvider created");
		        this.stop();
		    }
	    }
	    catch(Exception e)
	    {
		    myprintln("No ConfigProvider created");
		    myprintln(e.toString());
		    myprintln(getTargetMessages(e));
		    this.stop();
	    }  
    }
//-------------------------------------------------------------------------
    /**
    * doTest
    * do the test
    * @param sScriptFile
    */
  	private void doTest(String sScriptFile)
    {
		XInterface          xCfgUpdateAccess    = null;
		XNameReplace        xNameReplace    	= null;
		BufferedReader      inFile              = null;
		String              sReadLine           = "";
		int                 iIndex              = 0;
		
		try 
		{
		    inFile = new BufferedReader(new FileReader(new File(sScriptFile)));
		    
		    // search the testsection in the scriptfile. skip the other		
		    sReadLine = inFile.readLine();
		    iIndex = sReadLine.indexOf("// test section start");
		    while(iIndex == -1)
		    {
			    sReadLine = inFile.readLine();
			    iIndex = sReadLine.indexOf("// test section start");
		    }			
		    
// Reading lines from file
            sReadLine = (inFile.readLine()).trim();
		    while(sReadLine != null)
		    {
                sReadLine = sReadLine.trim();
//        COMMENTS        //
		        if(sReadLine.startsWith("//"))
		        {
    		        myprintln(sReadLine);
		        }		        
//        READ NODE        //
		        else if(sReadLine.startsWith("ReadNode"))
		        {
    		        myprintln("COMMAND: " + sReadLine);																
			        StringTokenizer st = new StringTokenizer(sReadLine.substring((sReadLine.indexOf("(")+1), sReadLine.lastIndexOf(")")), ",");
			        int noOfTokens = st.countTokens();
			        String startNodeName=st.nextToken();			        
			        int outputDepth = -1;
			        if(noOfTokens == 2)
			        {                 
    			        String newString = st.nextToken().trim();				
				        outputDepth = Integer.parseInt(newString);						   
			        }			        
	                readNodes(startNodeName,outputDepth);        
		        }
//        READ VALUE        //
		        else if(sReadLine.startsWith("ReadValue"))
		        {
    		        myprintln("COMMAND: " + sReadLine);																
			        StringTokenizer st = new StringTokenizer(sReadLine.substring((sReadLine.indexOf("(")+1), sReadLine.lastIndexOf(")")), ",");
			        //int noOfTokens = st.countTokens();
			        String sNodeValueName = st.nextToken();
			        String NodeName = sNodeValueName.substring(0,sNodeValueName.lastIndexOf("/"));
			        String ValueName = sNodeValueName.substring(sNodeValueName.lastIndexOf("/")+1);
                    readValue(sNodeValueName);
		        }
//        UPDATE NODE DIRECT        //
		        else if(sReadLine.startsWith("UpdateNodeDirect"))
				{
				    try
				    {
				        myprintln("COMMAND: " + sReadLine);																
					    StringTokenizer st = new StringTokenizer(sReadLine.substring((sReadLine.indexOf("(")+1), sReadLine.lastIndexOf(")")), ",");
					    String sValueName=st.nextToken();
					    String sNewValue=st.nextToken();
					    updateNode(sValueName,sNewValue,1);
					}
					catch(Exception e)
					{
					    myprintln("Exception while UpdateNodeDirect");
					    myprintln(e.toString());
					}
				}
//        BEGIN UPDATE        //
				else if(sReadLine.startsWith("BeginUpdate"))
				{
					    myprintln("COMMAND: " + sReadLine);																
					    StringTokenizer st = new StringTokenizer(sReadLine.substring((sReadLine.indexOf('(')+1), sReadLine.lastIndexOf(')')), ",");
					    String startNodeName=st.nextToken();
					    // getting StartNode  (third parameter could be depth)
	                    xCfgUpdateAccess = (XInterface) myConfigProvider.createInstanceWithArguments("com.sun.star.configuration.ConfigurationUpdateAccess", new Object[]{startNodeName, new Integer(-1)});					
				}
//        UPDATE NODE        //
				else if(sReadLine.startsWith("UpdateNode"))
				{
				    try
				    {
				        myprintln("COMMAND: " + sReadLine);																
					    StringTokenizer st = new StringTokenizer(sReadLine.substring((sReadLine.indexOf("(")+1), sReadLine.lastIndexOf(")")), ",");
					    String sValueName=st.nextToken();
					    String sNewValue=st.nextToken();
					    updateNode(sValueName,sNewValue,2,xCfgUpdateAccess );
					}
					catch(Exception e)
					{
					    myprintln("Exception while UpdateNode");
					    myprintln(e.toString());
					}
				}
//        END UPDATE        //
				else if(sReadLine.startsWith("EndUpdate"))
				{
					try
					{    	
                        myprintln("COMMAND: " + sReadLine);
                        XChangesBatch xChangesBatch = (com.sun.star.util.XChangesBatch)UnoRuntime.queryInterface(com.sun.star.util.XChangesBatch.class, xCfgUpdateAccess);
				    	if(xChangesBatch.hasPendingChanges())
				    	{
				    		xChangesBatch.commitChanges();
				    		//myprintln("The changes have been commmitted");
				    	}
				    	else
				    	{
				    		myprintln("There are no changes to commmit");
				    	}
					}
					catch(Exception e)
					{    
						myprintln("Exception while commit the changes");						                        						
					}
				}
//        DO        //
				else if(sReadLine.startsWith("Do"))
		        {
    		        
    		        try
    		        {
    		            myprintln("COMMAND: " + sReadLine);																
			            StringTokenizer st = new StringTokenizer(sReadLine.substring((sReadLine.indexOf("(")+1), sReadLine.lastIndexOf(")")), ";");
			            int noOfTokens = st.countTokens();
			            int noOfLoops = Integer.parseInt(st.nextToken());			            
			            String sCommand = st.nextToken();
			            for ( int i = 1; i <= noOfLoops ;i++)
			            {
			                if ( sCommand.startsWith("ReadNode") )
			                {			                
			                    StringTokenizer st2 = new StringTokenizer(sCommand.substring((sCommand.indexOf("(")+1), sCommand.lastIndexOf(")")), ",");			                
			                    myprintln("COMMAND: " + sCommand);
			                    int noOfTokens2 = st2.countTokens();
			                    String startNodeName=st2.nextToken();
			                    int outputDepth = -1;
			                    if(noOfTokens2 == 2)
			                    {                 
    			                    String newString = st2.nextToken().trim();				
				                    outputDepth = Integer.parseInt(newString);						   
			                    }			                
			                    readNodes(startNodeName,outputDepth);        
			                }
			                if ( sCommand.startsWith("ReadValue") )
			                {			                
			                    StringTokenizer st2 = new StringTokenizer(sCommand.substring((sCommand.indexOf("(")+1), sCommand.lastIndexOf(")")), ",");			                
			                    String startNodeName=st2.nextToken();
			                    int outputDepth = -1;                                                                      
			                    myprintln("COMMAND: " + sCommand);
			                    readValue(startNodeName);        
			                }
			                else if ( sCommand.startsWith("UpdateNodeDirect"))
			                {
			                    myprintln("COMMAND: " + sCommand);			                
					            StringTokenizer st2 = new StringTokenizer(sCommand.substring((sCommand.indexOf("(")+1), sCommand.lastIndexOf(")")), ",");
					            String sValueName=st2.nextToken();
					            String sNewValue=st2.nextToken();
					            updateNode(sValueName,sNewValue,1);
			                }			            
			                else if ( sCommand.startsWith("UpdateNode"))
			                {
			                    myprintln("COMMAND: " + sReadLine);																
					            StringTokenizer st2 = new StringTokenizer(sCommand.substring((sCommand.indexOf("(")+1), sCommand.lastIndexOf(")")), ",");
					            String sValueName=st2.nextToken();
					            String sNewValue=st2.nextToken();
					            updateNode(sValueName,sNewValue,2,xCfgUpdateAccess );
			                }
			            }
			        }
			        catch (Exception e)
			        {
			            System.out.println(e);			        
			        }
		        }				
//        WAIT        //		        		        
		        else if(sReadLine.startsWith("Wait"))
		        {
    		        myprintln("COMMAND: " + sReadLine);																
			        StringTokenizer st = new StringTokenizer(sReadLine.substring((sReadLine.indexOf("(")+1), sReadLine.lastIndexOf(")")), ",");			        
			        int secToWait = Integer.parseInt(st.nextToken());
			        java.lang.Thread.sleep(secToWait * 1000);
		        }
//        ADD NODE        //		        
		        else if(sReadLine.startsWith("AddNode"))
		        {
    		        try
    		        {
    		            myprintln("COMMAND: " + sReadLine);																
			            StringTokenizer st = new StringTokenizer(sReadLine.substring((sReadLine.indexOf("(")+1), sReadLine.lastIndexOf(")")), ",");			        			        			        
			            String startNodeName = st.nextToken();
			            String sNewNodeName = st.nextToken();
			            
			            XInterface myCfgUpdateAccess = (XInterface) myConfigProvider.createInstanceWithArguments("com.sun.star.configuration.ConfigurationUpdateAccess", new Object[]{startNodeName, new Integer(-1)});								        
			            
			            com.sun.star.lang.XServiceInfo myServicex = (com.sun.star.lang.XServiceInfo)UnoRuntime.queryInterface(com.sun.star.lang.XServiceInfo.class, myCfgUpdateAccess);					    
			            String [] xx = myServicex.getSupportedServiceNames();
			            
			            com.sun.star.lang.XServiceInfo myService = (com.sun.star.lang.XServiceInfo)UnoRuntime.queryInterface(com.sun.star.lang.XServiceInfo.class, myCfgUpdateAccess);					    
			            boolean bSupport = myService.supportsService("com.sun.star.configuration.ConfigurationContainer");
			            //boolean bSupport = true;
			            
			            if(bSupport)
			            {
			                // create a new empty node
			                com.sun.star.lang.XSingleServiceFactory myFac = (com.sun.star.lang.XSingleServiceFactory)UnoRuntime.queryInterface(com.sun.star.lang.XSingleServiceFactory.class, myCfgUpdateAccess);					    
			                XInterface myNewChild = (XInterface)myFac.createInstance();     			            
			                
			                // query the namecontainer on the node and insert it			            
    			            com.sun.star.container.XNameContainer myNameContainer = (com.sun.star.container.XNameContainer)UnoRuntime.queryInterface(com.sun.star.container.XNameContainer.class, myCfgUpdateAccess);					    
	    		            myNameContainer.insertByName(sNewNodeName,myNewChild);
		    	            
		    	            // commit the changes
			                com.sun.star.util.XChangesBatch xChangesBatch = (com.sun.star.util.XChangesBatch)UnoRuntime.queryInterface(com.sun.star.util.XChangesBatch.class, myCfgUpdateAccess);					    
		                    xChangesBatch.commitChanges();
			            }
			            else
			            {
			                myprintln("ERROR: " + startNodeName + " didn't support addNode");																
			            }			            
			            
			        }
			        catch (Exception e)
			        {
			            myprintln(e.toString());
			            myprintln(getTargetMessages(e));
			        }
			    }
//        REMOVE NODE        //		        
		        else if(sReadLine.startsWith("RemoveNode"))
		        {
    		        try
    		        {
    		            myprintln("COMMAND: " + sReadLine);																
			            StringTokenizer st = new StringTokenizer(sReadLine.substring((sReadLine.indexOf("(")+1), sReadLine.lastIndexOf(")")), ",");			        			        			        
			            String startNodeName = st.nextToken();
			            String sNodeName = st.nextToken();
			            
			            XInterface myCfgUpdateAccess = (XInterface) myConfigProvider.createInstanceWithArguments("com.sun.star.configuration.ConfigurationUpdateAccess", new Object[]{startNodeName, new Integer(-1)});								        
			            
			            com.sun.star.lang.XServiceInfo myServicex = (com.sun.star.lang.XServiceInfo)UnoRuntime.queryInterface(com.sun.star.lang.XServiceInfo.class, myCfgUpdateAccess);					    
			            String [] xx = myServicex.getSupportedServiceNames();
			            
			            com.sun.star.lang.XServiceInfo myService = (com.sun.star.lang.XServiceInfo)UnoRuntime.queryInterface(com.sun.star.lang.XServiceInfo.class, myCfgUpdateAccess);					    
			            //boolean bSupport = myService.supportsService("com.sun.star.configuration.ConfigurationContainer");
			            boolean bSupport = true;
			            
			            if(bSupport)
			            {
			                // query the namecontainer on the node and remove the given nodename
    			            com.sun.star.container.XNameContainer myNameContainer = (com.sun.star.container.XNameContainer)UnoRuntime.queryInterface(com.sun.star.container.XNameContainer.class, myCfgUpdateAccess);					    
	    		            myNameContainer.removeByName(sNodeName);
		    	            
		    	            // commit the changes
			                com.sun.star.util.XChangesBatch xChangesBatch = (com.sun.star.util.XChangesBatch)UnoRuntime.queryInterface(com.sun.star.util.XChangesBatch.class, myCfgUpdateAccess);					    
		                    xChangesBatch.commitChanges();
			            }
			            else
			            {
			                myprintln("ERROR: " + startNodeName + " didn't support removeNode");																
			            }			            
			            
			        }
			        catch (Exception e)
			        {
			            myprintln(e.toString());
			            myprintln(getTargetMessages(e));
			        }			        
		        }				
		        
		    sReadLine = inFile.readLine();
		    }
		}
		catch (Exception e)
		{
		    myprintln(getTargetMessages(e));
		}
    }
//-------------------------------------------------------------------------
    /**
    * readNodes
    * read the Nodes from the given Startnodes
    * @param the node
    */	
	private void readNodes(String startNodeName,int outputDepth)
	{
	    try
	    {
	        XInterface xCfgAccess = (XInterface) myConfigProvider.createInstanceWithArguments("com.sun.star.configuration.ConfigurationAccess", new Object[]{startNodeName, new Integer(outputDepth)});            
  		    readNodes((com.sun.star.container.XNameAccess)UnoRuntime.queryInterface(com.sun.star.container.XNameAccess.class,xCfgAccess),0);
  		}
  		catch(Exception e)
  		{
  		    myprintln(e.toString());
  		    myprintln(getTargetMessages(e));
  		    myprintln("User = " + myConfigItems.get("user"));
  		}
	}
//-------------------------------------------------------------------------
    /**
    * readNodes
    * read the Nodes from the given Startnodes
    * @param xNode - the startnode as a XNameAccess
    * @param indents - 
    */	
	private void readNodes(com.sun.star.container.XNameAccess xNode, int indents)
	{
		try
		{  			
  			String[] aNodeNames = xNode.getElementNames();                                               			
            for(int i=0; i < aNodeNames.length; i++)
            {
            	Object returnNode =  xNode.getByName(aNodeNames[i]);
				if(returnNode instanceof com.sun.star.uno.XInterface)
				{
					//CASE: INNER NODE: calling 						
					
					//starttag     
					indent(indents);
					myprintln("<" + aNodeNames[i] + ">");								                            			
					//the depth is missing call with (i-1)
			        readNodes( (com.sun.star.container.XNameAccess)UnoRuntime.queryInterface(com.sun.star.container.XNameAccess.class,returnNode), (indents+1));
			        
                    //endtag
					indent(indents);
					myprintln("</" + aNodeNames[i] + ">");								                            										
				}
				else
				{                                     
					//CASE: VALUE NODE: giving out the value
					
					//starttag
					indent(indents);
					myprintln("<" + aNodeNames[i] + ">");
					//System.out.print(" type=\"" + returnNode.getClass().getName() + "\"");
                           
                    //value         
					indent(indents);
					myprintln(tab+returnNode);
                    
                    //endtag
					indent(indents);
					myprintln("</" + aNodeNames[i] + ">");
				}															
			}
		}
		catch(Throwable t){                                     
			myprintln("6");						                        
			t.printStackTrace();
		}
	}
//-------------------------------------------------------------------------		
 	// formating the output, writes node depth depending indent   
	private void indent(int indents){
        //myprintln(indents);
        for(int i=0;i<indents;i++)
			myprint(tab,false);				              
	}
//-------------------------------------------------------------------------	
    /**
    * updateNodeDirect
    * update a node immediatly
    * @param sValueName - the name of the value    
    * @param sValue     - the value
    * @param iMode      - the mode of the update<br>
    * 1 = immediatly, send commit <br>
    * 2 = send no commit
    */
    private void updateNode(String sNodeValueName , String sValue, int iMode)
    {
        updateNode(sNodeValueName, sValue, iMode, null);
    }
//-------------------------------------------------------------------------	
    /**
    * updateNodeDirect
    * update a node immediatly
    * @param sValueName         the name of the value    
    * @param sValue             the value
    * @param iMode              the mode of the update<br>
    * 1 = immediatly, send commit <br>
    * 2 = send no commit
    * @param myCfgUpdateAccess  the CfgAccess for mode 2
    */
    private void updateNode(String sNodeValueName , String sValue, int iMode, XInterface myCfgUpdateAccess)
    {
        String                                  sNodeName       = "";
        String                                  sValueName      = "";
        com.sun.star.container.XNameReplace     xNameReplace    = null;
        com.sun.star.util.XChangesBatch         xChangesBatch   = null;
        
        try
	    {
	        sNodeName = sNodeValueName.substring(0,sNodeValueName.lastIndexOf("/")); 		    
	        sValueName = sNodeValueName.substring(sNodeValueName.lastIndexOf("/")+1); 		    
            if (iMode == 1)
		    {
                Object [] oCreateInfo = new Object[]{sNodeName,new Integer(-1)};
                XInterface xCfgUpdateAccess = (XInterface)myConfigProvider.createInstanceWithArguments("com.sun.star.configuration.ConfigurationUpdateAccess", oCreateInfo);		   
		        xNameReplace = (com.sun.star.container.XNameReplace)UnoRuntime.queryInterface(com.sun.star.container.XNameReplace.class, xCfgUpdateAccess);					    
		        xNameReplace.replaceByName(sValueName, sValue);		    
		        xChangesBatch = (com.sun.star.util.XChangesBatch)UnoRuntime.queryInterface(com.sun.star.util.XChangesBatch.class, xCfgUpdateAccess);					    
		        xChangesBatch.commitChanges();
		        // notify ( geht noch nicht -> bugs )
		        // com.sun.star.util.XChangesNotifier myChangesNotifier = (com.sun.star.util.XChangesNotifier)UnoRuntime.queryInterface(com.sun.star.util.XChangesNotifier.class, xCfgUpdateAccess);					    
		        // com.sun.star.util.XChangesListener myChangesListener = (com.sun.star.util.XChangesListener)UnoRuntime.queryInterface(com.sun.star.util.XChangesListener.class, xChangesBatch);					    
		        // myChangesNotifier.addChangesListener(myChangesListener);
		        //
		    }
		    else if ( iMode == 2)
		    {
		        xNameReplace = (com.sun.star.container.XNameReplace)UnoRuntime.queryInterface(com.sun.star.container.XNameReplace.class, myCfgUpdateAccess);					    
		        xNameReplace.replaceByName(sValueName, sValue);
		    }		    
	    }
	    catch(Exception e)
	    {
	        myprintln(e.toString());
	        myprintln("     " + getTargetMessages(e));
	    }
    }
//-------------------------------------------------------------------------	    
    /**
    * getTargetMessages
    * get the target messages form a TargetException
    * @param MyE    - the exception      
    */
    private String getTargetMessages(Exception MyE)
    {
        String sMyE = MyE.toString();
        String ret = "";
		if ( sMyE.indexOf("InvocationTargetException") != -1)
		{
		    java.lang.reflect.InvocationTargetException xx = (java.lang.reflect.InvocationTargetException) MyE;
		    ret = (xx.getTargetException()).toString();
		}
		return ret;
	}
//--------------------------------------------------------------------    
    /**
    * readValue
    * read the value
    * @param sNodeValueName
    */
    private void readValue(String sNodeValueName)
    {
        if(sNodeValueName.endsWith("/"))
        {
            sNodeValueName = sNodeValueName.substring(0, sNodeValueName.length() - 1);
        }
        String sNodeName = sNodeValueName.substring(0,sNodeValueName.lastIndexOf("/"));
		String sValueName = sNodeValueName.substring(sNodeValueName.lastIndexOf("/")+1);
		String sValue = "";
        try
        {
            XInterface xCfgAccess = (XInterface) myConfigProvider.createInstanceWithArguments("com.sun.star.configuration.ConfigurationAccess", new Object[]{sNodeName, new Integer(-1)});            
  		    com.sun.star.container.XNameAccess xNode = (com.sun.star.container.XNameAccess)UnoRuntime.queryInterface(com.sun.star.container.XNameAccess.class,xCfgAccess);
  		    // PropertySet ( geht noch nicht -> bug )
  		    // com.sun.star.beans.XPropertySetInfo xNodeProper = (com.sun.star.beans.XPropertySetInfo)UnoRuntime.queryInterface(com.sun.star.beans.XPropertySetInfo.class,xCfgAccess);
  		    //
  		    Object myNode = xNode.getByName(sValueName);
            if (myNode instanceof XInterface)
            {
                myprintln("It's a node not a value");
            }
            else
            {
                sValue = (xNode.getByName(sValueName)).toString();
  		        myprintln(sNodeValueName + ": " + sValue);
  		    }
  		}
  		catch (Exception e)
  		{}  		
    }
//--------------------------------------------------------------------    
    /**
    * readConfigSection
    * read the config section from the testscriptfile
    * @param sScriptFile     - the scriptfile 
    */
    private void readConfigSection(String sScriptFile)
    {   
		BufferedReader          inFile              = null;
		int                     findConfigSection   = 0;
		int                     findConfigEnd       = 0;
		String                  sReadLine           = "";
		String                  sKey                = "";
		String                  sValue              = "";
		//StringTokenizer         StringToken         = null;
		int                     iIndex              = 0;		
		
		try
		{
		    inFile = new BufferedReader(new FileReader(new File(sScriptFile)));	  
		    
		    while ( findConfigSection != -1)
		    {
    		    sReadLine = inFile.readLine();
    		    findConfigSection = sReadLine.indexOf("// common parameters start");
    		    if (findConfigSection != -1)
    		    {
    			    sReadLine = inFile.readLine();
    			    findConfigEnd = sReadLine.indexOf("// common parameters end");
    			    while (findConfigEnd == -1)
    			    {    			           			    
    			        iIndex = sReadLine.indexOf("=");
    			        sKey = sReadLine.substring(0, iIndex);
    		            sValue = sReadLine.substring(iIndex+1);
    		            myConfigItems.put(sKey.trim(), sValue.trim());    		        
    		            sReadLine = inFile.readLine();
    			        findConfigEnd = sReadLine.indexOf("// common parameters end");
    		        }
    		        break;
    		    }
		    }
		    
		}
		catch( Exception e)
		{
		    myprintln(e.toString());
		}		
	}
//--------------------------------------------------------------------    
    /**
    * outputOutput
    * 
    * 
    */
    private void outputOutput()
    {   
		BufferedReader          inFile              = null;
		int                     findConfigSection   = 0;
		int                     findConfigEnd       = 0;
		String                  sReadLine           = "";
		String                  sKey                = "";
		String                  sValue              = "";
		//StringTokenizer         StringToken         = null;
		int                     iIndex              = 0;		
		
		if( sOutPut.equals("file") )
		{		    
		    try
		    {
		        java.text.DateFormat myDate = DateFormat.getDateTimeInstance();
		        java.util.Calendar myCalendar = myDate.getCalendar();
		        int iDay = myCalendar.get(java.util.Calendar.DAY_OF_MONTH);
		        int iMonth = myCalendar.get(java.util.Calendar.MONTH)+1;
		        int iYear = myCalendar.get(java.util.Calendar.YEAR)+80;
		        int iHours = myCalendar.get(java.util.Calendar.HOUR);
		        int iMinutes = myCalendar.get(java.util.Calendar.MINUTE);
		        int iSeconds = myCalendar.get(java.util.Calendar.SECOND);
    		    
		        String sFileName = this.getName() + ".out";
    		    
		        File f1 = new File(sFileName);
		        bufWriter = new java.io.BufferedWriter(new FileWriter(f1));
		        bufWriter.write("****************************************************");
		        bufWriter.newLine();		    
		        bufWriter.write("*   Output file for testscript : " + this.getName());
		        bufWriter.newLine();		    
		        bufWriter.write("*   Output from : " + (new java.util.Date()).toString());
		        bufWriter.newLine();		    
		        bufWriter.write("*   User = " + myConfigItems.get("user"));
		        bufWriter.newLine();		    
		        bufWriter.write("*   Password = " + myConfigItems.get("password"));
		        bufWriter.newLine();
		        bufWriter.write("****************************************************");
		        bufWriter.newLine();		    
		        bufWriter.write(outputBuffer.toString());
		        bufWriter.close();
		    }
		    catch( Exception e)
		    {
		        System.out.println(e.toString());
		    }		
	    }
	    else
	    {
	        System.out.println(outputBuffer.toString());
	    }
	}
//--------------------------------------------------------------------    
    /**
    * myprintln
    * 
    * 
    */
    private void myprintln(String content)
    {   
		myprint(content,true);
	}
//--------------------------------------------------------------------    
    /**
    * myprint
    * 
    * 
    */
    private void myprint(String content, boolean newLine)
    {   
		//BufferedReader          inFile              = null;
		//int                     findConfigSection   = 0;
		//int                     findConfigEnd       = 0;
		//String                  sReadLine           = "";
		//String                  sKey                = "";
		//String                  sValue              = "";
		//StringTokenizer         StringToken         = null;
		//int                     iIndex              = 0;		
		
		try
		{
		    outputBuffer.append(content);		    
		    if (newLine == true)
		    {
		        outputBuffer.append("\r\n");
		    }		    
		}
		catch( Exception e)
		{
		    System.out.println(e);
		}		
	}
	//   Erweiterungen von com.sun.star.util.XChangesListener   //
	public void changesOccurred(com.sun.star.util.ChangesEvent Event)
	{
	    System.out.println("changesoccured");
	}
	public void disposing(com.sun.star.lang.EventObject Event)
	{
	}
}	
