/*************************************************************************
 *
 *  $RCSfile: YUsers.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: oj $ $Date: 2002/11/28 10:27:20 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CONNECTIVITY_MYSQL_USERS_HXX_
#include "mysql/YUsers.hxx"
#endif
#ifndef _CONNECTIVITY_MYSQL_USER_HXX_
#include "mysql/YUser.hxx"
#endif
#ifndef CONNECTIVITY_MYSQL_TABLE_HXX
#include "mysql/YTable.hxx"
#endif
#ifndef _COM_SUN_STAR_SDBC_XROW_HPP_
#include <com/sun/star/sdbc/XRow.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_XRESULTSET_HPP_
#include <com/sun/star/sdbc/XResultSet.hpp>
#endif
#ifndef _CONNECTIVITY_SDBCX_IREFRESHABLE_HXX_
#include "connectivity/sdbcx/IRefreshable.hxx"
#endif
#ifndef _COMPHELPER_TYPES_HXX_
#include <comphelper/types.hxx>
#endif
#ifndef _DBHELPER_DBEXCEPTION_HXX_
#include "connectivity/dbexception.hxx"
#endif
#ifndef _CONNECTIVITY_DBTOOLS_HXX_
#include "connectivity/dbtools.hxx"
#endif
#ifndef CONNECTIVITY_CONNECTION_HXX
#include "TConnection.hxx"
#endif

using namespace ::comphelper;
using namespace connectivity;
using namespace connectivity::mysql;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;
//	using namespace ::com::sun::star::sdbcx;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::container;
using namespace ::com::sun::star::lang;
typedef connectivity::sdbcx::OCollection OCollection_TYPE;

OUsers::OUsers( ::cppu::OWeakObject& _rParent,
				::osl::Mutex& _rMutex,
				const TStringVector &_rVector,
				const ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection >& _xConnection,
				connectivity::sdbcx::IRefreshableUsers* _pParent) 
	: sdbcx::OCollection(_rParent,sal_True,_rMutex,_rVector)
	,m_xConnection(_xConnection)
	,m_pParent(_pParent)
{
}
// -----------------------------------------------------------------------------

Reference< XNamed > OUsers::createObject(const ::rtl::OUString& _rName)
{
	return new OMySQLUser(m_xConnection,_rName);
}
// -------------------------------------------------------------------------
void OUsers::impl_refresh() throw(RuntimeException)
{
	m_pParent->refreshUsers();
}
// -------------------------------------------------------------------------
Reference< XPropertySet > OUsers::createEmptyObject()
{
	OUserExtend* pNew = new OUserExtend(m_xConnection);
	return pNew;
}
// -------------------------------------------------------------------------
Reference< XNamed > OUsers::cloneObject(const Reference< XPropertySet >& _xDescriptor)
{
	Reference< XNamed > xName(_xDescriptor,UNO_QUERY);		
	OSL_ENSURE(xName.is(),"Must be a XName interface here !");
	return xName.is() ? createObject(xName->getName()) : Reference< XNamed >();
}
// -------------------------------------------------------------------------
// XAppend
void OUsers::appendObject( const Reference< XPropertySet >& descriptor )
{
	::rtl::OUString aSql	= ::rtl::OUString::createFromAscii("GRANT USAGE ON * TO ");
	::rtl::OUString aQuote	= m_xConnection->getMetaData()->getIdentifierQuoteString(  );
	::rtl::OUString sUserName;
	descriptor->getPropertyValue(OMetaConnection::getPropMap().getNameByIndex(PROPERTY_ID_NAME)) >>= sUserName;
	aSql += ::dbtools::quoteName(aQuote,sUserName)
				+ ::rtl::OUString::createFromAscii(" @\"%\" ");
	::rtl::OUString sPassword;
	descriptor->getPropertyValue(OMetaConnection::getPropMap().getNameByIndex(PROPERTY_ID_PASSWORD)) >>= sPassword;
	if ( sPassword.getLength() )
	{
		aSql += ::rtl::OUString::createFromAscii(" IDENTIFIED BY '");
		aSql += sPassword;
		aSql += ::rtl::OUString::createFromAscii("'");
	}

	Reference< XStatement > xStmt = m_xConnection->createStatement(  );
	if(xStmt.is())
		xStmt->execute(aSql);
	::comphelper::disposeComponent(xStmt);
}
// -------------------------------------------------------------------------
// XDrop
void OUsers::dropObject(sal_Int32 _nPos,const ::rtl::OUString _sElementName)
{
	{
		::rtl::OUString aSql	= ::rtl::OUString::createFromAscii("REVOKE ALL ON * FROM ");
		::rtl::OUString aQuote	= m_xConnection->getMetaData()->getIdentifierQuoteString(  );
		aSql += ::dbtools::quoteName(aQuote,_sElementName);

		Reference< XStatement > xStmt = m_xConnection->createStatement(  );
		if(xStmt.is())
			xStmt->execute(aSql);
		::comphelper::disposeComponent(xStmt);
	}
}

// -------------------------------------------------------------------------
