#ifndef _SSODLG_HXX_
#define _SSODLG_HXX_

#ifndef _SV_DIALOG_HXX
#include <vcl/dialog.hxx>
#endif
#ifndef _SV_FIXED_HXX
#include <vcl/fixed.hxx>
#endif
#ifndef _SV_EDIT_HXX
#include <vcl/edit.hxx>
#endif
#ifndef _SV_BUTTON_HXX
#include <vcl/button.hxx>
#endif


class SSOLoginDialog : public ModalDialog
{
	private:
		static const ::rtl::OUString	sBmpFile;

		FixedImage						mLogo;
		FixedText						mMessage;
		FixedText						mUserNameLabel;
		Edit							mUserNameEdit;
		FixedText						mPasswordLabel;
		Edit							mPasswordEdit;
		CheckBox						mSavePasswordCheckBox;
		FixedLine						mLine;
		OKButton						mLoginButton;
		CancelButton					mCancelButton;

	public:
		SSOLoginDialog( Window * inParent, ResMgr * inResMgr );
		~SSOLoginDialog();

		String	GetName( void ) const
			{ return mUserNameEdit.GetText(); };
		void	SetName( const String & inName )
			{ mUserNameEdit.SetText( inName ); };

		String	GetPassword( void ) const
			{ return mPasswordEdit.GetText(); };

		BOOL	IsSavePassword( void ) const
			{ return mSavePasswordCheckBox.IsChecked(); };


	private:
		void LoadLogo( void );
};

#endif // _SSODLG_HXX_
