/*************************************************************************
 *
 *  $RCSfile: adrbeam.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:01:46 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <vos/mutex.hxx>
#include <tools/urlobj.hxx>
#include <usr/weak.hxx>
#include <usr/reflserv.hxx>
#include <usr/factoryhlp.hxx>
#include <usr/services.hxx>
#include <usr/smart2uno.hxx>
#include <toolkit/unoiface.hxx>
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASERECORDSTATUS_HXX_
#include <smart/com/sun/star/data/DatabaseRecordStatus.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASECURSOROPTION_HXX_
#include <smart/com/sun/star/data/DatabaseCursorOption.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASECURSORSUPPLIER_HXX_
#include <smart/com/sun/star/data/XDatabaseCursorSupplier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XPREPAREDDATABASESTATEMENT_HXX_
#include <smart/com/sun/star/data/XPreparedDatabaseStatement.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASESTATEMENT_HXX_
#include <smart/com/sun/star/data/XDatabaseStatement.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASEUPDATECURSOR_HXX_
#include <smart/com/sun/star/data/XDatabaseUpdateCursor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASECURSOR_HXX_
#include <smart/com/sun/star/data/XDatabaseCursor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASEBOOKMARKCURSOR_HXX_
#include <smart/com/sun/star/data/XDatabaseBookmarkCursor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASEDIRECTCURSOR_HXX_
#include <smart/com/sun/star/data/XDatabaseDirectCursor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASECURSORTYPE_HXX_
#include <smart/com/sun/star/data/DatabaseCursorType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASERECORDMODE_HXX_
#include <smart/com/sun/star/data/DatabaseRecordMode.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XGRID_HXX_
#include <smart/com/sun/star/form/XGrid.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XGRIDCOLUMNFACTORY_HXX_
#include <smart/com/sun/star/form/XGridColumnFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XGRIDPEER_HXX_
#include <smart/com/sun/star/form/XGridPeer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XGRIDFIELDDATASUPPLIER_HXX_
#include <smart/com/sun/star/form/XGridFieldDataSupplier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XCONTROLLER_HXX_
#include <smart/com/sun/star/frame/XController.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFRAMEACTIONLISTENER_HXX_
#include <smart/com/sun/star/frame/XFrameActionListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XCOMPONENTLOADER_HXX_
#include <smart/com/sun/star/frame/XComponentLoader.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFRAME_HXX_
#include <smart/com/sun/star/frame/XFrame.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_FRAMEACTIONEVENT_HXX_
#include <smart/com/sun/star/frame/FrameActionEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_FRAMEACTION_HXX_
#include <smart/com/sun/star/frame/FrameAction.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFRAMELOADER_HXX_
#include <smart/com/sun/star/frame/XFrameLoader.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XLOADEVENTLISTENER_HXX_
#include <smart/com/sun/star/frame/XLoadEventListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFILTERDETECT_HXX_
#include <smart/com/sun/star/frame/XFilterDetect.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XSERVICENAME_HXX_
#include <smart/com/sun/star/lang/XServiceName.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XSERVICEINFO_HXX_
#include <smart/com/sun/star/lang/XServiceInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HXX_
#include <smart/com/sun/star/lang/XMultiServiceFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XSINGLESERVICEFACTORY_HXX_
#include <smart/com/sun/star/lang/XSingleServiceFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYVALUES_HXX_
#include <smart/com/sun/star/beans/PropertyValues.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYSET_HXX_
#include <smart/com/sun/star/beans/XPropertySet.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYVALUE_HXX_
#include <smart/com/sun/star/beans/PropertyValue.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYSTATE_HXX_
#include <smart/com/sun/star/beans/PropertyState.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYSETINFO_HXX_
#include <smart/com/sun/star/beans/XPropertySetInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XMULTIPROPERTYSET_HXX_
#include <smart/com/sun/star/beans/XMultiPropertySet.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XFASTPROPERTYSET_HXX_
#include <smart/com/sun/star/beans/XFastPropertySet.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XVETOABLECHANGELISTENER_HXX_
#include <smart/com/sun/star/beans/XVetoableChangeListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYSTATE_HXX_
#include <smart/com/sun/star/beans/XPropertyState.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYSTATECHANGELISTENER_HXX_
#include <smart/com/sun/star/beans/XPropertyStateChangeListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYATTRIBUTE_HXX_
#include <smart/com/sun/star/beans/PropertyAttribute.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTIESCHANGELISTENER_HXX_
#include <smart/com/sun/star/beans/XPropertiesChangeListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYCHANGELISTENER_HXX_
#include <smart/com/sun/star/beans/XPropertyChangeListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYACCESS_HXX_
#include <smart/com/sun/star/beans/XPropertyAccess.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYCONTAINER_HXX_
#include <smart/com/sun/star/beans/XPropertyContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYSTATECHANGEEVENT_HXX_
#include <smart/com/sun/star/beans/PropertyStateChangeEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYCHANGEEVENT_HXX_
#include <smart/com/sun/star/beans/PropertyChangeEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XCONTAINER_HXX_
#include <smart/com/sun/star/container/XContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XINDEXCONTAINER_HXX_
#include <smart/com/sun/star/container/XIndexContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XNAMEREPLACE_HXX_
#include <smart/com/sun/star/container/XNameReplace.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XCONTAINERLISTENER_HXX_
#include <smart/com/sun/star/container/XContainerListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XSET_HXX_
#include <smart/com/sun/star/container/XSet.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_CONTAINEREVENT_HXX_
#include <smart/com/sun/star/container/ContainerEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XINDEXREPLACE_HXX_
#include <smart/com/sun/star/container/XIndexReplace.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XNAMECONTAINER_HXX_
#include <smart/com/sun/star/container/XNameContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_MERGECONFLICTEXCEPTION_HXX_
#include <smart/com/sun/star/registry/MergeConflictException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_XSIMPLEREGISTRY_HXX_
#include <smart/com/sun/star/registry/XSimpleRegistry.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_INVALIDVALUEEXCEPTION_HXX_
#include <smart/com/sun/star/registry/InvalidValueException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_REGISTRYKEYTYPE_HXX_
#include <smart/com/sun/star/registry/RegistryKeyType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_XREGISTRYKEY_HXX_
#include <smart/com/sun/star/registry/XRegistryKey.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_REGISTRYVALUETYPE_HXX_
#include <smart/com/sun/star/registry/RegistryValueType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_INVALIDREGISTRYEXCEPTION_HXX_
#include <smart/com/sun/star/registry/InvalidRegistryException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LOADER_XIMPLEMENTATIONLOADER_HXX_
#include <smart/com/sun/star/loader/XImplementationLoader.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LOADER_CANNOTACTIVATEFACTORYEXCEPTION_HXX_
#include <smart/com/sun/star/loader/CannotActivateFactoryException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_POSSIZE_HXX_
#include <smart/com/sun/star/awt/PosSize.hxx>
#endif

#include <svtools/iniprop.hxx>
#include <svtools/iniman.hxx>

#ifndef _SV_LSTBOX_HXX //autogen wg. ListBox
#include <vcl/lstbox.hxx>
#endif

#ifndef _SV_EDIT_HXX //autogen wg. Edit
#include <vcl/edit.hxx>
#endif

#ifndef _TOOLS_DEBUG_HXX //autogen wg. DBG_ASSERT
#include <tools/debug.hxx>
#endif

#include "adrbeam.hxx"
#include "toolbar.hrc"
#include "adrresid.hxx"

#ifdef _USE_NAMESPACE
using namespace usr;
using namespace vos;
#endif

#define PROPERTY_FRAME						1
#define ID_TOOLBAR							1
#define ID_GRIDWIN							2
#define ID_ALPHAWIN							3

UString gGridModelCommand( L".uno:Adr/newGridModel");

SMART_UNO_IMPLEMENTATION( AdrGridwin, UsrObject );

AdrGridwin::AdrGridwin(Window* pParent, WinBits nStyle):
	DockingWindow(pParent,nStyle|WB_CLIPCHILDREN)
{
	aCtrContainer = CreateControlContainer(this);
}


void AdrGridwin::Resize()
{
	if(xGridWinRef.is())
	{
		Size aSize = GetOutputSizePixel();
		xGridWinRef->setPosSize(0, 0, aSize.Width(),aSize.Height(), PosSize_SIZE);
	}
}
void AdrGridwin::createGridWin(const XControlModelRef& xGModel)
{
	xGridModel=xGModel;

	if( aCtrContainer.is())
	{
		XMultiServiceFactoryRef xMgr( NAMESPACE_USR( getProcessServiceManager )() );
		
		if ( xGridModel.is() && xMgr.is())
		{
			XPropertySetRef xPropSet( xGridModel, USR_QUERY );

			if ( xPropSet.is() && xGridModel.is() )
			{
				UsrAny aAny = xPropSet->getPropertyValue( L"DefaultControl" );
				UString aControlName = aAny.getString();

				xControl=XControlRef(xMgr->createInstance( aControlName ), USR_QUERY );
				if ( xControl.is() )
				{
					xControl->setModel( xGridModel);
				}
			}
			
			if ( xControl.is() )
			{
				// Peer als Child zu dem FrameWindow
				aCtrContainer->addControl(L"Bla", xControl);
				xGridWinRef=XWindowRef(xControl, USR_QUERY );
				xGridWinRef->setVisible( TRUE );
				xControl->setDesignMode(FALSE);
				Size aSize = GetOutputSizePixel();
				xGridWinRef->setPosSize(0, 0, aSize.Width(),aSize.Height(), PosSize_POSSIZE);
			}
		}
	}
}

void AdrGridwin::disposeGridWin()
{
	if ( xControl.is() )
	{
		aCtrContainer->removeControl(xControl);
		xControl->dispose();
	}
}

void AdrGridwin::changeGridModel(const XControlModelRef& xGModel)
{
	xGridModel=xGModel;

	if ( xControl.is() )
	{
		xControl->setModel( xGridModel);
	}
}


BOOL AdrGridwin::queryInterface( UsrUik aUIK, XInterfaceRef& rOut )
{
	if ( aUIK == XStatusListener::getSmartUik() )
	{
		rOut = (XStatusListener*)this;
		return TRUE;
	}
	else
	{
		return UsrObject::queryInterface( aUIK, rOut );
	}
}

void AdrGridwin::statusChanged(const FeatureStateEvent& rEvt)THROWS( (UsrSystemException) )
{
	if(rEvt.FeatureURL.Complete == gGridModelCommand)
	{
		if(IsEnabled() != rEvt.IsEnabled) Enable(rEvt.IsEnabled);
	
		UsrAny aModel=rEvt.State;
		if(aModel.getReflection()==XControlModel_getReflection())
		{
			XControlModelRef xGModel=*(XControlModelRef*) aModel.get();
			changeGridModel(xGModel);
		}	
	}
};




AdrBeamer::AdrBeamer(Window* pParent,AdrDataManagerHdl pDM, WinBits nStyle):
	SplitWindow(pParent,nStyle|WB_NOSPLITDRAW),
	ppDatMan(pDM),
	pToolBar (NULL),
	pGridWin (NULL),
	pAlphaWin(NULL)
{
	createToolBar(); 
	createGridWin(); 
	createAlphaWin();
}

AdrBeamer::~AdrBeamer()
{
	if ( xToolBarRef.is() ) xToolBarRef->dispose();
	if ( xGridRef.is() ) xGridRef->dispose();
	if ( xAlphaRef.is() ) xAlphaRef->dispose();


	if(pToolBar) delete pToolBar;
	
	if(pGridWin)
	{	
		pGridWin->disposeGridWin();
		delete pGridWin;
	}

	if(pAlphaWin) delete pAlphaWin;
}

void AdrBeamer::createToolBar()
{
	pToolBar= new AdrToolBar(this);
	Size aSize=pToolBar->GetSizePixel();
	InsertItem(ID_TOOLBAR, pToolBar, aSize.Height(), 0, 0, SWIB_FIXED );
	if(xController.is()) pToolBar->SetXController(xController);
}
void AdrBeamer::createGridWin()
{
	if(ppDatMan!=NULL && *ppDatMan!=NULL )
	{
		pGridWin= new AdrGridwin(this,0);

		InsertItem(ID_GRIDWIN, pGridWin, 40, 1, 0, SWIB_RELATIVESIZE );

		
		pGridWin->createGridWin((*ppDatMan)->createGridModel());
	}
}

void AdrBeamer::createAlphaWin()
{
}

void AdrBeamer::SetXController(const XControllerRef& xCtr)
{
	xController=xCtr;

	if(xController.is())
	{
		XDispatchRef xDisp(xController,USR_QUERY);
		XMultiServiceFactoryRef xMgr( NAMESPACE_USR( getProcessServiceManager )() );
		XURLTransformerRef xTrans ( xMgr->createInstance( L"com.sun.star.util.URLTransformer" ), USR_QUERY );
		if( xTrans.is() && xDisp.is())
		{
			URL aURL;
			aURL.Complete =gGridModelCommand;	
			
			xTrans->parseStrict( aURL );
			xDisp->addStatusListener(XStatusListenerRef(pGridWin),aURL);
		}
	}
	
	if(pToolBar) pToolBar->SetXController(xController);

}


