/*************************************************************************
 *
 *  $RCSfile: adrload.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:01:49 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include <vos/mutex.hxx>
#include <tools/urlobj.hxx>
#include <usr/weak.hxx>
#include <usr/reflserv.hxx>
#include <usr/factoryhlp.hxx>
#include <usr\services.hxx>
#include <usr/smart2uno.hxx>
#include <toolkit/unoiface.hxx>
#ifndef _SMART_COM_SUN_STAR_FRAME_XCONTROLLER_HXX_
#include <smart/com/sun/star/frame/XController.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFRAMEACTIONLISTENER_HXX_
#include <smart/com/sun/star/frame/XFrameActionListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XCOMPONENTLOADER_HXX_
#include <smart/com/sun/star/frame/XComponentLoader.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFRAME_HXX_
#include <smart/com/sun/star/frame/XFrame.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_FRAMEACTIONEVENT_HXX_
#include <smart/com/sun/star/frame/FrameActionEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_FRAMEACTION_HXX_
#include <smart/com/sun/star/frame/FrameAction.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFRAMELOADER_HXX_
#include <smart/com/sun/star/frame/XFrameLoader.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XLOADEVENTLISTENER_HXX_
#include <smart/com/sun/star/frame/XLoadEventListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFILTERDETECT_HXX_
#include <smart/com/sun/star/frame/XFilterDetect.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XSERVICENAME_HXX_
#include <smart/com/sun/star/lang/XServiceName.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XSERVICEINFO_HXX_
#include <smart/com/sun/star/lang/XServiceInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HXX_
#include <smart/com/sun/star/lang/XMultiServiceFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XSINGLESERVICEFACTORY_HXX_
#include <smart/com/sun/star/lang/XSingleServiceFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYVALUES_HXX_
#include <smart/com/sun/star/beans/PropertyValues.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYSET_HXX_
#include <smart/com/sun/star/beans/XPropertySet.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYVALUE_HXX_
#include <smart/com/sun/star/beans/PropertyValue.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYSTATE_HXX_
#include <smart/com/sun/star/beans/PropertyState.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYSETINFO_HXX_
#include <smart/com/sun/star/beans/XPropertySetInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XMULTIPROPERTYSET_HXX_
#include <smart/com/sun/star/beans/XMultiPropertySet.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XFASTPROPERTYSET_HXX_
#include <smart/com/sun/star/beans/XFastPropertySet.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XVETOABLECHANGELISTENER_HXX_
#include <smart/com/sun/star/beans/XVetoableChangeListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYSTATE_HXX_
#include <smart/com/sun/star/beans/XPropertyState.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYSTATECHANGELISTENER_HXX_
#include <smart/com/sun/star/beans/XPropertyStateChangeListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYATTRIBUTE_HXX_
#include <smart/com/sun/star/beans/PropertyAttribute.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTIESCHANGELISTENER_HXX_
#include <smart/com/sun/star/beans/XPropertiesChangeListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYCHANGELISTENER_HXX_
#include <smart/com/sun/star/beans/XPropertyChangeListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYACCESS_HXX_
#include <smart/com/sun/star/beans/XPropertyAccess.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYCONTAINER_HXX_
#include <smart/com/sun/star/beans/XPropertyContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYSTATECHANGEEVENT_HXX_
#include <smart/com/sun/star/beans/PropertyStateChangeEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYCHANGEEVENT_HXX_
#include <smart/com/sun/star/beans/PropertyChangeEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XCONTAINER_HXX_
#include <smart/com/sun/star/container/XContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XINDEXCONTAINER_HXX_
#include <smart/com/sun/star/container/XIndexContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XNAMEREPLACE_HXX_
#include <smart/com/sun/star/container/XNameReplace.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XCONTAINERLISTENER_HXX_
#include <smart/com/sun/star/container/XContainerListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XSET_HXX_
#include <smart/com/sun/star/container/XSet.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_CONTAINEREVENT_HXX_
#include <smart/com/sun/star/container/ContainerEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XINDEXREPLACE_HXX_
#include <smart/com/sun/star/container/XIndexReplace.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XNAMECONTAINER_HXX_
#include <smart/com/sun/star/container/XNameContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_MERGECONFLICTEXCEPTION_HXX_
#include <smart/com/sun/star/registry/MergeConflictException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_XSIMPLEREGISTRY_HXX_
#include <smart/com/sun/star/registry/XSimpleRegistry.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_INVALIDVALUEEXCEPTION_HXX_
#include <smart/com/sun/star/registry/InvalidValueException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_REGISTRYKEYTYPE_HXX_
#include <smart/com/sun/star/registry/RegistryKeyType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_XREGISTRYKEY_HXX_
#include <smart/com/sun/star/registry/XRegistryKey.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_REGISTRYVALUETYPE_HXX_
#include <smart/com/sun/star/registry/RegistryValueType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_INVALIDREGISTRYEXCEPTION_HXX_
#include <smart/com/sun/star/registry/InvalidRegistryException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LOADER_XIMPLEMENTATIONLOADER_HXX_
#include <smart/com/sun/star/loader/XImplementationLoader.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LOADER_CANNOTACTIVATEFACTORYEXCEPTION_HXX_
#include <smart/com/sun/star/loader/CannotActivateFactoryException.hxx>
#endif
#include <vcl/window.hxx>
#include <vcl/edit.hxx>
#include <vcl/svapp.hxx>

#ifndef _FSYS_HXX //autogen wg. DirEntry
#include <tools/fsys.hxx>
#endif

#ifndef _SV_GROUP_HXX //autogen wg. GroupBox
#include <vcl/group.hxx>
#endif

#include <svtools/iniprop.hxx>
#include <svtools/iniman.hxx>
#include <svtools/svmedit.hxx>

#include "adr.hrc"
#include "adrcont.hxx"
#include "adrbeam.hxx"
#include "adrmod.hxx"
#include "adrview.hxx"
#include "framectr.hxx"
#include "datman.hxx"

#ifdef _USE_NAMESPACE
using namespace usr;
using namespace vos;
#endif

#define PROPERTY_FRAME						1

class AddressBookLoader : public XFrameLoader, public XServiceInfo, public OWeakObject
{
private:

	String 					GetTopURL();

	void					loadBeamer(const XFrameRef& aFrame, const UString& aURL,
								const Sequence< PropertyValue >& aArgs,
								const XLoadEventListenerRef& aListener);
	
	void					loadView(const XFrameRef& aFrame, const UString& aURL,
								const Sequence< PropertyValue >& aArgs,
								const XLoadEventListenerRef& aListener);

public:
							AddressBookLoader();
							~AddressBookLoader();
	// XInterface
	virtual void			acquire()
							{ OWeakObject::acquire(); }
	virtual void			release()
							{ OWeakObject::release(); }
	virtual void *			getImplementation(Reflection *p)
							{ return OWeakObject::getImplementation(p); }

	virtual BOOL 			queryInterface( UsrUik aUIK, XInterfaceRef& );

	// XIdlClassProvider
	Sequence< XIdlClassRef > getIdlClasses(void);

	// XServiceInfo
	UString 				getImplementationName() THROWS( () );
    BOOL 					supportsService(const UString& ServiceName) THROWS( () );
    Sequence< UString > 	getSupportedServiceNames(void) THROWS( () );
	static UString 			getImplementationName_Static() THROWS( () )
							{
								//!
								return L"com.sun.star.address.AddressBookLoader";
								//!
							}

	
	static XIdlClassRef		getStaticIdlClass();
    static Sequence<UString>	getSupportedServiceNames_Static(void) THROWS( () );

	friend	XInterfaceRef 	AddressBookLoader_CreateInstance( const XMultiServiceFactoryRef& rSMgr ) THROWS((Exception));

	// XLoader
	virtual void 			load(const XFrameRef& aFrame, const UString& aURL,
								const Sequence< PropertyValue >& aArgs,
								const XLoadEventListenerRef& aListener);
    virtual void 			cancel(void);
};

extern "C" XFrameLoader* __LOADONCALLAPI CreateLoader( const String& rProt )
{
	return new AddressBookLoader;
}


AddressBookLoader::AddressBookLoader()
{
}

AddressBookLoader::~AddressBookLoader()
{
}

BOOL AddressBookLoader::queryInterface( UsrUik aUIK, XInterfaceRef& xRet )
{
	if( aUIK == XFrameLoader::getSmartUik() )
		xRet = (XFrameLoader*) this;
	else if( aUIK == XServiceInfo::getSmartUik() )
		xRet = (XServiceInfo*) this;
	else
		return OWeakObject::queryInterface( aUIK, xRet );
	return xRet.is();
}

XInterfaceRef AddressBookLoader_CreateInstance( const XMultiServiceFactoryRef & rSMgr ) THROWS((Exception))
{
	return *(new AddressBookLoader);
}

XIdlClassRef AddressBookLoader::getStaticIdlClass()
{
	// Global Method, must be guarded (multithreading)
	OGuard aGuard( OMutex::getGlobalMutex() );
	{
		// use the standard class implementation of the usr library
		static XIdlClassRef xClass =
		createStandardClass(
			getImplementationName_Static(),
			OWeakObject::getStaticIdlClass(),
			2 /*Anzahl Interfaces*/,
			XFrameLoader_getReflection(),
			XServiceInfo_getReflection() );

		return xClass;
	}
}

// XIdlClassProvider
Sequence< XIdlClassRef > AddressBookLoader::getIdlClasses()
{
	XIdlClassRef x = getStaticIdlClass();
	return Sequence< XIdlClassRef >( &x, 1 );
}

// XServiceInfo
UString AddressBookLoader::getImplementationName() THROWS( () )
{
	return getImplementationName_Static();
}

// XServiceInfo
BOOL AddressBookLoader::supportsService(const UString& ServiceName) THROWS( () )
{
	Sequence< UString > aSNL = getSupportedServiceNames();
	const UString * pArray = aSNL.getConstArray();
	for( INT32 i = 0; i < aSNL.getLen(); i++ )
		if( pArray[i] == ServiceName )
			return TRUE;
	return FALSE;
}

// XServiceInfo
Sequence< UString > AddressBookLoader::getSupportedServiceNames(void) THROWS( () )
{
	return getSupportedServiceNames_Static();
}

// ORegistryServiceManager_Static
Sequence< UString > AddressBookLoader::getSupportedServiceNames_Static(void) THROWS( () )
{
	Sequence< UString > aSNS( 2 );
	aSNS.getArray()[0] = L"com.sun.star.frame.FrameLoader";
	//!
	aSNS.getArray()[1] = L"com.sun.star.address.AddressBookLoader";
	//!
	return aSNS;
}

extern "C" {

BOOL EXTERN_SERVICE_CALLTYPE exService_writeRegEntry( const UNO_INTERFACE(XRegistryKey)* xUnoKey)
{
	XRegistryKeyRef xKey;
	uno2smart(xKey, *xUnoKey);

	// Eigentliche Implementierung und ihre Services registrieren
	UString aImpl = L"/" + AddressBookLoader::getImplementationName_Static();
	XRegistryKeyRef xNewKey = xKey->createKey( aImpl + L"/UNO/SERVICES" );
	Sequence <UString> aSequ = AddressBookLoader::getSupportedServiceNames_Static();
	const UString * pArray = aSequ.getConstArray();
	for( INT32 i = 0; i < aSequ.getLen(); i++ )
		xNewKey->createKey( pArray[i] );

	// Einen FrameLoader "uber URL-Pattern registrieren
	xNewKey = xKey->createKey( aImpl + L"/UNO/Loader" );
	XRegistryKeyRef xLoaderKey = xKey->createKey( aImpl + L"/Loader" );
	xNewKey = xLoaderKey->createKey( L"Pattern" );
	//!
	xNewKey->setAsciiValue( L".component:AddressBook/*" );  /**/
	//!

	// optional:
	xNewKey = xLoaderKey->createKey( L"Extension" );
	//!
	xNewKey->setAsciiValue( L"BLABLA" );
	//!

	return True;
}

UNO_INTERFACE(XInterface) EXTERN_SERVICE_CALLTYPE exService_getFactory
(
	const sal_Unicode* implementationName,
	const UNO_INTERFACE(XMultiServiceFactory)* xUnoFact,
	const UNO_INTERFACE(XRegistryKey)*
)
{
	UNO_INTERFACE(XInterface) xUnoRet = {0, 0};

	XInterfaceRef 			xRet;
	XMultiServiceFactoryRef xSMgr;
	UString					aImplementationName(implementationName);

	uno2smart(xSMgr, *xUnoFact);

	if ( UString(implementationName) == AddressBookLoader::getImplementationName_Static() )
	{
		xRet = createSingleFactory( xSMgr, implementationName,
										AddressBookLoader_CreateInstance,
										AddressBookLoader::getSupportedServiceNames_Static() );
	}

	if (xRet.is())
		smart2uno(xRet, xUnoRet);
	return xUnoRet;
}

}

String AddressBookLoader::GetTopURL()
{
	String aString;
	SfxAppIniManagerProperty aProp;
	GetpApp()->Property( aProp );
	if( !aProp.GetIniManager() ) return aString;
	
	String aAddressBook = 
		aProp.GetIniManager()->Get( SFX_KEY_ADDRESSBOOK );
	INetURLObject aObj;
	aObj.SetSmartProtocol( INET_PROT_FILE );
	aObj.SetURL( aAddressBook.GetToken( 0, ';' ), FALSE );
	
	String aMark( "db:Table;" );
	aMark += aAddressBook.GetToken( 1, ';' );
	aObj.SetMark( aMark );
	
	
	return aObj.GetMainURL();
}

// -----------------------------------------------------------------------
void AddressBookLoader::cancel(void)
{
	//!
	//!
}
BOOL bDemoFlag=FALSE;
// -----------------------------------------------------------------------
void AddressBookLoader::load(const XFrameRef& rFrame, const UString& rURL,
		const Sequence< PropertyValue >& rArgs,
		const XLoadEventListenerRef& rListener)
{
	//!

	HdlAdrModul	pAdrMod=OpenAdrModul();

	String aURLStr( OUStringToString( rURL, CHARSET_SYSTEM ) );
	String aPartName = aURLStr.GetToken( 1, '/' );
	
	if(aPartName=="View")
	{
		bDemoFlag=FALSE;
		loadView(rFrame,rURL,rArgs,rListener);

	}
	else if(aPartName=="View1")
	{
		bDemoFlag=TRUE;
		loadView(rFrame,rURL,rArgs,rListener);
	}
	else if(aPartName=="Beamer")
	{
		loadBeamer(rFrame,rURL,rArgs,rListener);
	}
}

// -----------------------------------------------------------------------
void AddressBookLoader::loadView(const XFrameRef& rFrame, const UString& rURL,
		const Sequence< PropertyValue >& rArgs,
		const XLoadEventListenerRef& rListener)
{
	//!

	HdlAdrModul	pAdrMod=OpenAdrModul();

	AdrDataManager* pDatMan=(*pAdrMod)->createDataManager();

	UString aAdrUrl=StringToOUString( (*pAdrMod)->GetOldAddressBookURL(), CHARSET_SYSTEM);

	XDatabaseFormRef xForm=pDatMan->createDatabaseForm(aAdrUrl);

	if(xForm.is())
	{
		AdrFrameController* pController = new AdrFrameController(pDatMan);
		AdrDataManagerHdl ppDatMan = pController->GetDataManager();

		XWindowRef aWindow = rFrame->getContainerWindow();

		VCLXWindow* pComp = (VCLXWindow*) aWindow->getImplementation( VCLXWindow_getReflection() );
		Window* pParent = pComp->GetWindow();

		AdrBookContainer *pMyWindow = new AdrBookContainer( pParent, ppDatMan );

		SvSectionControl* pGroupControl=new AdrView(pMyWindow,ppDatMan ,WB_SECTION_STYLE);
		
		AdrBeamer* pBeamer=new AdrBeamer( pMyWindow,ppDatMan );
		if(bDemoFlag)
			pMyWindow->createTopFrame(pBeamer);
		else
			pMyWindow->createTopFrame(L"staroffice.component:AddressBook/Beamer");
		
		pMyWindow->createBottomFrame(pGroupControl);

		XWindowRef xWin ( pMyWindow->GetComponentInterface(), USR_QUERY );

		pController->InitController(xWin);

		XControllerRef xCtrRef(pController);

		xCtrRef->attachFrame(rFrame);
		rFrame->setComponent( xWin, xCtrRef);
		pBeamer->SetXController(xCtrRef);
		//!

		if ( rListener.is() )
			rListener->loadFinished( this );

		long nBeamerSize = pDatMan->getBeamerSize();

		pDatMan->loadDatabase();

		ResMgr* pResMgr = GetAdrModul()->GetResMgr();
		DirEntry aEntry( pResMgr->GetFileName() );
		String aResFile = ".component:";
		( aResFile += aEntry.GetName() ) += '/';
		String aMenuRes = aResFile;
		aMenuRes+=RID_MAIN_MENU;

		URL aURL;
		aURL.Complete = StringToOUString( aMenuRes, CHARSET_SYSTEM);
		
		XMultiServiceFactoryRef xMgr( NAMESPACE_USR( getProcessServiceManager )() );
		XURLTransformerRef xTrans ( xMgr->createInstance( L"com.sun.star.util.URLTransformer" ), USR_QUERY );
		if( xTrans.is() )
		{
			// Datei laden
			xTrans->parseStrict( aURL );

			XDispatchProviderRef xProv( rFrame, USR_QUERY );
			if ( xProv.is() )
			{
				XDispatchRef aDisp = xProv->queryDispatch( aURL,  L"_tool:_menubar", 0 );
				if ( aDisp.Is() )
					aDisp->dispatch( aURL, Sequence<PropertyValue>() );
			}
		}

	}
	else
	{
		if ( rListener.is() )
			rListener->loadCancelled( this );
	}
	if(Application::IsWait())
		Application::LeaveWait();
}

// -----------------------------------------------------------------------
void AddressBookLoader::loadBeamer(const XFrameRef& rFrame, const UString& rURL,
		const Sequence< PropertyValue >& rArgs,
		const XLoadEventListenerRef& rListener)
{
	//!

	HdlAdrModul	pAdrMod=OpenAdrModul();
	
	AdrDataManagerPtr pDatMan=(*pAdrMod)->createDataManager();
	
	UString aAdrUrl=StringToOUString( (*pAdrMod)->GetOldAddressBookURL(), CHARSET_SYSTEM);
	XDatabaseFormRef xForm=pDatMan->createDatabaseForm(aAdrUrl);

	if(xForm.is())
	{
		AdrFrameController* pController = new AdrFrameController(pDatMan);
		AdrDataManagerHdl ppDatMan = pController->GetDataManager();

		XWindowRef aWindow = rFrame->getContainerWindow();

		rFrame->setName( L"_beamer" );
		
		VCLXWindow* pComp = (VCLXWindow*) aWindow->getImplementation( VCLXWindow_getReflection() );
		Window* pParent = pComp->GetWindow();

		AdrBeamer *pMyWindow = new AdrBeamer( pParent,ppDatMan );

		XWindowRef xWin ( pMyWindow->GetComponentInterface(), USR_QUERY );

		pController->InitController(xWin);

		XControllerRef xCtrRef(pController);

		xCtrRef->attachFrame(rFrame);
		rFrame->setComponent( xWin, xCtrRef);

		if ( rListener.is() )
			rListener->loadFinished( this );

	}
	else
	{
		if ( rListener.is() )
			rListener->loadCancelled( this );
	}
	if(Application::IsWait())
		Application::LeaveWait();
}



