/*************************************************************************
 *
 *  $RCSfile: frameset.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:02:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <string.h>

#ifndef _LIST_HXX
#include <tools/list.hxx>
#endif
#ifndef _DEBUG_HXX
#include <tools/debug.hxx>
#endif

#ifndef _SV_EVENT_HXX
#include <vcl/event.hxx>
#endif
#ifndef _SV_WALL_HXX
#include <vcl/wall.hxx>
#endif
#ifndef _SV_BITMAP_HXX
#include <vcl/bitmap.hxx>
#endif
#ifndef _SV_DECOVIEW_HXX
#include <vcl/decoview.hxx>
#endif
#ifndef _SV_SYMBOL_HXX
#include <vcl/symbol.hxx>
#endif
#ifndef _SV_IMAGE_HXX
#include <vcl/image.hxx>
#endif
#ifndef _SV_HELP_HXX
#include <vcl/help.hxx>
#endif

#ifndef _SV_LSTBOX_HXX
#include <vcl/lstbox.hxx>
#endif

#include "frameset.hxx"

#pragma hdrstop

#define DEFAULT_LINE_ID		0x0100
#define DEFAULT_WIN_ID		0x0001

long nGLineHeight = 0;

// =======================================================================

// Achtung: Darf keine Objekte enthalten, da mit memmove/memcpy gearbeitet wird
struct ImplSplitItem
{
	long				mnSize;
	long				mnPixSize;
	long				mnLeft;
	long				mnTop;
	long				mnWidth;
	long				mnHeight;
	long				mnSplitPos;
	long				mnSplitSize;
	long				mnOldSplitPos;
	long				mnOldSplitSize;
	long				mnOldWidth;
	long				mnOldHeight;
	long				mnOrgHeight;
	long				mnOrgWidth;
	long				mnOrgXPos;
	long				mnOrgYPos;
	ImplSplitSet*		mpSet;
	Window*				mpWindow;
	Window* 			mpOrgParent;
	USHORT				mnId;
	AdrFrameSetItemBits mnBits;
	BOOL				mbFixed;
	BOOL				mbSubSize;
};

struct ImplSplitSet
{
	ImplSplitItem*		mpItems;
	Wallpaper*			mpWallpaper;
	Bitmap* 			mpBitmap;
	long				mnLastSize;
	long				mnSplitSize;
	USHORT				mnItems;
	USHORT				mnId;
	BOOL				mbCalcPix;
};

#define SPLITWIN_SPLITSIZE				6
#define SPLITWIN_SPLITSIZEEX			6
#define SPLITWIN_SPLITSIZEAUTOHIDE		40
#define SPLITWIN_SPLITSIZEFADE			40

#define SPLIT_HORZ				((USHORT)0x0001)
#define SPLIT_VERT				((USHORT)0x0002)
#define SPLIT_WINDOW			((USHORT)0x0004)
#define SPLIT_NOSPLIT			((USHORT)0x8000)

// -----------------------------------------------------------------------

DECLARE_LIST( ImplSplitList, AdrFrameSet* );

// =======================================================================

ImplSplitSet* AdrFrameSet::ImplFindSet( ImplSplitSet* pSet, USHORT nId ) const
{
	if ( pSet->mnId == nId )
		return pSet;

	USHORT			i;
	USHORT			nItems = pSet->mnItems;
	ImplSplitItem*	pItems = pSet->mpItems;

	for ( i = 0; i < nItems; i++ )
	{
		if ( pItems[i].mnId == nId )
			return pItems[i].mpSet;
	}

	for ( i = 0; i < nItems; i++ )
	{
		if ( pItems[i].mpSet )
		{
			ImplSplitSet* pFindSet = ImplFindSet( pItems[i].mpSet, nId );
			if ( pFindSet )
				return pFindSet;
		}
	}

	return NULL;
}

// -----------------------------------------------------------------------

ImplSplitSet* AdrFrameSet::ImplFindItem( ImplSplitSet* pSet, USHORT nId, USHORT& rPos ) const
{
	USHORT			i;
	USHORT			nItems = pSet->mnItems;
	ImplSplitItem*	pItems = pSet->mpItems;

	for ( i = 0; i < nItems; i++ )
	{
		if ( pItems[i].mnId == nId )
		{
			rPos = i;
			return pSet;
		}
	}

	for ( i = 0; i < nItems; i++ )
	{
		if ( pItems[i].mpSet )
		{
			ImplSplitSet* pFindSet = ImplFindItem( pItems[i].mpSet, nId, rPos );
			if ( pFindSet )
				return pFindSet;
		}
	}

	return NULL;
}

// -----------------------------------------------------------------------

USHORT AdrFrameSet::ImplFindItem( ImplSplitSet* pSet, Window* pWindow ) const
{
	USHORT			i;
	USHORT			nItems = pSet->mnItems;
	ImplSplitItem*	pItems = pSet->mpItems;

	for ( i = 0; i < nItems; i++ )
	{
		if ( pItems[i].mpWindow == pWindow )
			return pItems[i].mnId;
		else
		{
			if ( pItems[i].mpSet )
			{
				USHORT nId = ImplFindItem( pItems[i].mpSet, pWindow );
				if ( nId )
					return nId;
			}
		}
	}

	return 0;
}

// -----------------------------------------------------------------------

USHORT AdrFrameSet::ImplFindItem( ImplSplitSet* pSet, const Point& rPos,
							BOOL bRows, BOOL bDown ) const
{
	USHORT			i;
	USHORT			nItems = pSet->mnItems;
	ImplSplitItem*	pItems = pSet->mpItems;

	for ( i = 0; i < nItems; i++ )
	{
		if ( pItems[i].mnWidth && pItems[i].mnHeight )
		{
			// Wegen ICC auftrennen
			Point		aPoint( pItems[i].mnLeft, pItems[i].mnTop );
			Size		aSize( pItems[i].mnWidth, pItems[i].mnHeight );
			Rectangle	aRect( aPoint, aSize );
			if ( bRows )
			{
				if ( bDown )
					aRect.Bottom() += pSet->mnSplitSize;
				else
					aRect.Top() -= pSet->mnSplitSize;
			}
			else
			{
				if ( bDown )
					aRect.Right() += pSet->mnSplitSize;
				else
					aRect.Left() -= pSet->mnSplitSize;
			}

			if ( aRect.IsInside( rPos ) )
			{
				if ( pItems[i].mpSet && pItems[i].mpSet->mpItems )
				{
					return ImplFindItem( pItems[i].mpSet, rPos,
										((pItems[i].mnBits & AFSIB_COLSET) == 0) );
				}
				else
					return pItems[i].mnId;
			}
		}
	}

	return 0;
}

// -----------------------------------------------------------------------

void AdrFrameSet::ImplDeleteSet( ImplSplitSet* pSet )
{
	USHORT			i;
	USHORT			nItems = pSet->mnItems;
	ImplSplitItem*	pItems = pSet->mpItems;

	for ( i = 0; i < nItems; i++ )
	{
		if ( pItems[i].mpSet )
			ImplDeleteSet( pItems[i].mpSet );
	}

	if ( pSet->mpWallpaper )
		delete pSet->mpWallpaper;

	if ( pSet->mpBitmap )
		delete pSet->mpBitmap;

	delete pItems;
	delete pSet;
}

// -----------------------------------------------------------------------

void AdrFrameSet::ImplSetSplitSize( ImplSplitSet* pSet, long nNewSize )
{
	pSet->mnSplitSize = nNewSize;
	for ( USHORT i = 0; i < pSet->mnItems; i++ )
	{
		if ( pSet->mpItems[i].mpSet )
			ImplSetSplitSize( pSet->mpItems[i].mpSet, nNewSize );
	}
}

// -----------------------------------------------------------------------

void AdrFrameSet::ImplCalcSet( ImplSplitSet* pSet,ImplSplitSet* pOldSet,
							 long nSetLeft, long nSetTop,
							 long nSetWidth, long nSetHeight,
							 BOOL bRows, BOOL bDown)
{
	if ( !pSet->mpItems )
		return;

	USHORT				i;
	USHORT				j;
	USHORT				nMins;
	USHORT				nCalcItems;
	USHORT				nItems = pSet->mnItems;
	USHORT				nVisItems;
	USHORT				nAbsItems;
	long				nCalcSize;
	long				nSizeDelta;
	long				nCurSize;
	long				nSizeWinSize;
	long				nNewSizeWinSize;
	long				nTemp;
	long				nTempErr;
	long				nErrorSum;
	long				nCurSizeDelta;
	long				nPos;
	long				nMaxPos;
	long*				pSize;
	ImplSplitItem*		pItems = pSet->mpItems;
	BOOL				bEmpty;

	// Anzahl sichtbarer Items ermitteln
	nVisItems = 0;
	for ( i = 0; i < nItems; i++ )
	{
		if ( !(pItems[i].mnBits & AFSIB_INVISIBLE) )
			nVisItems++;
	}

	// Groessen berechnen
	if ( bRows )
		nCalcSize = nSetHeight;
	else
		nCalcSize = nSetWidth;
	nCalcSize -= (nVisItems-1)*pSet->mnSplitSize;
	nCurSize   = 0;
	if ( pSet->mbCalcPix || (pSet->mnLastSize != nCalcSize) )
	{
		long nPercentFactor = 10;
		long nRelCount		= 0;
		long nPercent		= 0;
		long nRelPercent	= 0;
		long nAbsSize		= 0;
		for ( i = 0; i < nItems; i++ )
		{
			if ( !(pItems[i].mnBits & AFSIB_INVISIBLE) )
			{
				if ( pItems[i].mnBits & AFSIB_RELATIVESIZE )
					nRelCount += pItems[i].mnSize;
				else if ( pItems[i].mnBits & AFSIB_PERCENTSIZE )
					nPercent += pItems[i].mnSize;
				else
					nAbsSize += pItems[i].mnSize;
			}
		}
		// Relative-Werte auf prozentual mappen (Percent bei uns 10tel Prozent)
		nPercent *= nPercentFactor;
		if ( nRelCount )
		{
			long nRelPercentBase = 1000;
			while ( (nRelCount > nRelPercentBase) && (nPercentFactor < 100000) )
			{
				nRelPercentBase *= 10;
				nPercentFactor *= 10;
			}
			if ( nPercent < nRelPercentBase )
			{
				nRelPercent = (nRelPercentBase-nPercent)/nRelCount;
				nPercent += nRelPercent*nRelCount;
			}
			else
				nRelPercent = 0;
		}
		if ( !nPercent )
			nPercent = 1;
		nSizeDelta = nCalcSize-nAbsSize;
		double nFactor = 10. * ((double)nSizeDelta / (double)nPercent);
		for ( i = 0; i < nItems; i++ )
		{
			if ( pItems[i].mnBits & AFSIB_INVISIBLE )
				pItems[i].mnPixSize = 0;
			else if ( pItems[i].mnBits & AFSIB_RELATIVESIZE )
			{
				if ( nSizeDelta <= 0 )
					pItems[i].mnPixSize = 0;
				else
				{
					long nValue = (long)(pItems[i].mnSize*nRelPercent *nFactor);
					long nValue2 = nValue / 10;
					if(nValue-(nValue2*10) > 5)
						nValue2++;
					
					pItems[i].mnPixSize = nValue2;
				}
			}
			else if ( pItems[i].mnBits & AFSIB_PERCENTSIZE )
			{
				if ( nSizeDelta <= 0 )
					pItems[i].mnPixSize = 0;
				else
				{
					long nValue = (long)(pItems[i].mnSize*nPercentFactor*nFactor);
					long nValue2 = nValue / 10;
					if(nValue-(nValue2*10) > 5)
						nValue2++;
					pItems[i].mnPixSize = nValue2;
				}
			}
			else
				pItems[i].mnPixSize = pItems[i].mnSize;
			nCurSize += pItems[i].mnPixSize;
		}

		pSet->mbCalcPix  = FALSE;
		pSet->mnLastSize = nCalcSize;

		// Fenster einpassen
		nSizeDelta	= nCalcSize-nCurSize;
		if ( nSizeDelta )
		{
			nAbsItems		= 0;
			nSizeWinSize	= 0;
			nNewSizeWinSize = 0;

			// Zuerst die absoluten Items relativ resizen
			for ( i = 0; i < nItems; i++ )
			{
				if ( !(pItems[i].mnBits & AFSIB_INVISIBLE) )
				{
					if ( !(pItems[i].mnBits & (AFSIB_RELATIVESIZE | AFSIB_PERCENTSIZE)) )
					{
						nAbsItems++;
						nSizeWinSize += pItems[i].mnPixSize;
					}
				}
			}
			// Rundungsfehler werden hier nicht ausgelichen
			if ( (nAbsItems < (USHORT)(Abs( nSizeDelta ))) && nSizeWinSize )
			{
				for ( i = 0; i < nItems; i++ )
				{
					if ( !(pItems[i].mnBits & AFSIB_INVISIBLE) )
					{
						if ( !(pItems[i].mnBits & (AFSIB_RELATIVESIZE | AFSIB_PERCENTSIZE)) )
						{
							pItems[i].mnPixSize += (nSizeDelta*pItems[i].mnPixSize)/nSizeWinSize;
							nNewSizeWinSize += pItems[i].mnPixSize;
						}
					}
				}
				nSizeDelta -= nNewSizeWinSize-nSizeWinSize;
			}
			// Jetzt die Rundungsfehler ausgleichen
			j			= 0;
			nMins		= 0;
			while ( nSizeDelta !=0 && (nItems != nMins) )
			{
				// Feststellen, welche Items berechnet werden duerfen
				nCalcItems = 0;
				while ( !nCalcItems )
				{
					for (short i = nItems-1; i >=0 ; i-- )
					{
						pItems[i].mbSubSize = FALSE;

						if ( j >= 2 )
							pItems[i].mbSubSize = TRUE;
						else
						{
							if ( !(pItems[i].mnBits & AFSIB_INVISIBLE) )
							{
								if ( (nSizeDelta != 0) || pItems[i].mnPixSize )
								{
									if ( j >= 1 )
										pItems[i].mbSubSize = TRUE;
									else
									{
										if ( (j == 0) && (pItems[i].mnBits & (AFSIB_RELATIVESIZE | AFSIB_PERCENTSIZE)) )
											pItems[i].mbSubSize = TRUE;
									}
								}
							}
						}

						if ( pItems[i].mbSubSize )
							nCalcItems++;
					}

					j++;
				}

				// Groessen von den einzelnen Items abziehen
				nErrorSum		= nSizeDelta % nCalcItems;
				nCurSizeDelta	= nSizeDelta / nCalcItems;
				nMins			= 0;
				for ( short i = nItems-1; i >=0 ; i-- )
				{
					if ( pItems[i].mnBits & AFSIB_INVISIBLE )
						nMins++;
					else if ( pItems[i].mbSubSize )
					{
						pSize = &(pItems[i].mnPixSize);

						if ( nErrorSum )
						{
							if ( nErrorSum < 0 )
								nTempErr = -1;
							else
								nTempErr = 1;
						}
						else
							nTempErr = 0;

						if ( (*pSize+nCurSizeDelta+nTempErr) <= 0 )
						{
							nTemp = *pSize;
							if ( nTemp )
							{
								*pSize -= nTemp;
								nSizeDelta += nTemp;
							}
							nMins++;
						}
						else
						{
							*pSize += nCurSizeDelta;
							nSizeDelta -= nCurSizeDelta;
							if ( nTempErr && (*pSize || (nTempErr > 0)) )
							{
								*pSize += nTempErr;
								nSizeDelta -= nTempErr;
								nErrorSum -= nTempErr;
							}
						}
					}
				}
			}
		}
	}
	else
	{
		for ( i = 0; i < nItems; i++ )
		{
			if ( !(pItems[i].mnBits & AFSIB_INVISIBLE) )
				nCurSize += pItems[i].mnPixSize;
		}
	}

	// Maximale Groesse berechnen
	if ( bRows )
	{
		nPos = nSetTop;
		if ( !bDown )
			nMaxPos = nSetTop-nSetHeight;
		else
			nMaxPos = nSetTop+nSetHeight;
	}
	else
	{
		nPos = nSetLeft;
		if ( !bDown )
			nMaxPos = nSetLeft-nSetWidth;
		else
			nMaxPos = nSetLeft+nSetWidth;
	}

	// Fenster anordnen und Werte anpassen
	for ( i = 0; i < nItems; i++ )
	{
		pItems[i].mnOldSplitPos    = pItems[i].mnSplitPos;
		pItems[i].mnOldSplitSize   = pItems[i].mnSplitSize;
		pItems[i].mnOldWidth	   = pItems[i].mnWidth;
		pItems[i].mnOldHeight	   = pItems[i].mnHeight;

		if ( pItems[i].mnBits & AFSIB_INVISIBLE )
			bEmpty = TRUE;
		else
		{
			bEmpty = FALSE;
			if ( bDown )
			{
				if ( nPos+pItems[i].mnPixSize > nMaxPos )
					bEmpty = TRUE;
			}
			else
			{
				nPos -= pItems[i].mnPixSize;
				if ( nPos < nMaxPos )
					bEmpty = TRUE;
			}
		}

		if ( bEmpty )
		{
			pItems[i].mnWidth	  = 0;
			pItems[i].mnHeight	  = 0;
			pItems[i].mnSplitSize = 0;
		}
		else
		{
			if ( bRows )
			{
				pItems[i].mnLeft   = nSetLeft;
				pItems[i].mnTop    = nPos;
				pItems[i].mnWidth  = nSetWidth;
				pItems[i].mnHeight = pItems[i].mnPixSize;
			}
			else
			{
				pItems[i].mnLeft   = nPos;
				pItems[i].mnTop    = nSetTop;
				pItems[i].mnWidth  = pItems[i].mnPixSize;
				pItems[i].mnHeight = nSetHeight;
			}

			if ( i > nItems-1 )
				pItems[i].mnSplitSize = 0;
			else
			{
				pItems[i].mnSplitSize = pSet->mnSplitSize;
				if ( bDown )
				{
					pItems[i].mnSplitPos  = nPos+pItems[i].mnPixSize;
					if ( pItems[i].mnSplitPos+pItems[i].mnSplitSize > nMaxPos )
						pItems[i].mnSplitSize = nMaxPos-pItems[i].mnSplitPos;
				}
				else
				{
					pItems[i].mnSplitPos = nPos-pSet->mnSplitSize;
					if ( pItems[i].mnSplitPos < nMaxPos )
						pItems[i].mnSplitSize = pItems[i].mnSplitPos+pSet->mnSplitSize-nMaxPos;
				}
			}
		}

		if ( !(pItems[i].mnBits & AFSIB_INVISIBLE) )
		{
			if ( !bDown )
				nPos -= pSet->mnSplitSize;
			else
			{
				nPos += pItems[i].mnPixSize+pSet->mnSplitSize;

				if(pOldSet != NULL)
				{
					USHORT			nOldItems = pOldSet->mnItems;
					ImplSplitItem*	pOldItems = pOldSet->mpItems;

					long nOrgRightPos = pItems[i].mnOrgXPos + pItems[i].mnOrgWidth;

					for(USHORT k=0; k < nOldItems; k++)
					{
						long nOldLeft  = pOldItems[k].mnLeft;
						long nOldRight = pOldItems[k].mnLeft + pOldItems[k].mnWidth;
						long nTmpOrgRightPos = pOldItems[k].mnOrgXPos + pOldItems[k].mnOrgWidth;

						if(	pOldItems[k].mpWindow != NULL )
						{
							if(	nOldLeft - 5 <	nPos &&
								nOldLeft + 5 >	nPos &&
								nOldLeft	!=	nPos )
							{
								long nDiff = nPos - nOldLeft;
								pItems[i].mnPixSize -= nDiff;
								pItems[i].mnWidth = pItems[i].mnPixSize;
								nPos= nOldLeft;
							}
						}							
						if(	pItems[i].mpWindow != NULL )
						{	
							if(	nOrgRightPos == nTmpOrgRightPos)
							{
								long nDiff = nPos - nOldRight;
								pItems[i].mnPixSize -= nDiff;
								pItems[i].mnWidth = pItems[i].mnPixSize;
								nPos= nOldRight;
							}
							else if(nOldRight	 != nPos &&
									nOldRight - 5 <	nPos &&	
									nOldRight + 5 >	nPos )
							{
								long nDiff = nPos - nOldRight;
								pItems[i].mnPixSize -= nDiff;
								pItems[i].mnWidth = pItems[i].mnPixSize;
								nPos= nOldRight;
							}
						}
					}
				}
			}
		}
	}

	// Sub-Set's berechnen
	ImplSplitSet* pTmpSet=NULL;
	for ( i = 0; i < nItems; i++ )
	{
		if ( pItems[i].mpSet && pItems[i].mnWidth && pItems[i].mnHeight )
		{
			ImplCalcSet( pItems[i].mpSet,pTmpSet,
						 pItems[i].mnLeft, pItems[i].mnTop,
						 pItems[i].mnWidth, pItems[i].mnHeight,
						 ((pItems[i].mnBits & AFSIB_COLSET) == 0) );
			pTmpSet = pItems[i].mpSet;
		}
	}

	// Fixed setzen
	for ( i = 0; i < nItems; i++ )
	{
		pItems[i].mbFixed = FALSE;
		if ( pItems[i].mnBits & AFSIB_FIXED )
			pItems[i].mbFixed = TRUE;
		else
		{
			// Wenn Child-Set vorhanden, ist dieses Item auch Fixed, wenn
			// ein Child fixed ist
			if ( pItems[i].mpSet )
			{
				for ( j = 0; j < pItems[i].mpSet->mnItems; j++ )
				{
					if ( pItems[i].mpSet->mpItems[j].mbFixed )
					{
						pItems[i].mbFixed = TRUE;
						break;
					}
				}
			}
		}
	}
}

// -----------------------------------------------------------------------

void AdrFrameSet::ImplCalcSet2( ImplSplitSet* pSet, BOOL bHide,
						  BOOL bRows, BOOL bDown)
{
	USHORT			i;
	USHORT			nItems = pSet->mnItems;
	ImplSplitItem*	pItems = pSet->mpItems;

	for ( i = 0; i < nItems; i++ )
	{
		if ( pItems[i].mnSplitSize )
		{
			// Evt. alles invalidieren oder nur einen kleinen Teil
			if ( (pItems[i].mnOldSplitPos  != pItems[i].mnSplitPos)  ||
				 (pItems[i].mnOldSplitSize != pItems[i].mnSplitSize) ||
				 (pItems[i].mnOldWidth	   != pItems[i].mnWidth)	 ||
				 (pItems[i].mnOldHeight    != pItems[i].mnHeight) )
			{
				Rectangle aRect;

				if ( bRows )
				{
					aRect.Left()	= pItems[i].mnLeft;
					aRect.Right()	= pItems[i].mnLeft+pItems[i].mnWidth-1;
					aRect.Top() 	= pItems[i].mnSplitPos;
					aRect.Bottom()	= aRect.Top() + pItems[i].mnSplitSize;
				}
				else
				{
					aRect.Top() 	= pItems[i].mnTop;
					aRect.Bottom()	= pItems[i].mnTop+pItems[i].mnHeight-1;
					aRect.Left()	= pItems[i].mnSplitPos;
					aRect.Right()	= aRect.Left() + pItems[i].mnSplitSize;
				}
				//mpParent->Invalidate( aRect );

				// Leere Sets komplett invalidieren, da diese Flaechen
				// nicht von Fenstern ueberladen werden
				if ( pItems[i].mpSet && !pItems[i].mpSet->mpItems )
				{
					aRect.Left()	= pItems[i].mnLeft;
					aRect.Top() 	= pItems[i].mnTop;
					aRect.Right()	= pItems[i].mnLeft+pItems[i].mnWidth-1;
					aRect.Bottom()	= pItems[i].mnTop+pItems[i].mnHeight-1;
					//mpParent->Invalidate( aRect );
				}
			}
		}
	}

	// Fenster positionieren
	for ( i = 0; i < nItems; i++ )
	{
		if ( pItems[i].mpSet )
		{
			BOOL bTempHide = bHide;
			if ( !pItems[i].mnWidth || !pItems[i].mnHeight )
				bTempHide = TRUE;
			ImplCalcSet2( pItems[i].mpSet, bTempHide,
						  ((pItems[i].mnBits & AFSIB_COLSET) == 0) );
		}
		else
		{
			if ( pItems[i].mnWidth && !bHide )
			{
				Point aPos( pItems[i].mnLeft, pItems[i].mnOrgYPos );
				Size  aSize( pItems[i].mnWidth, pItems[i].mnOrgHeight );
				pItems[i].mpWindow->SetPosSizePixel( aPos, aSize );
			}
			else
				pItems[i].mpWindow->Hide();

			/* //@
			if ( pItems[i].mnWidth && pItems[i].mnHeight && !bHide )
			{
				Point aPos( pItems[i].mnLeft, pItems[i].mnTop );
				Size  aSize( pItems[i].mnWidth, pItems[i].mnHeight );
				pItems[i].mpWindow->SetPosSizePixel( aPos, aSize );
			}
			else
				pItems[i].mpWindow->Hide();
			*/
		}
	}

	// Fenster anzeigen und Flag zuruecksetzen
	for ( i = 0; i < nItems; i++ )
	{
		if ( pItems[i].mpWindow && pItems[i].mnWidth && pItems[i].mnHeight && !bHide )
			pItems[i].mpWindow->Show();
	}
}

// -----------------------------------------------------------------------

void AdrFrameSet::ImplCalcLogSize( ImplSplitItem* pItems, USHORT nItems )
{
	// Original-Groessen updaten
	USHORT	i;
	long	nRelSize = 0;
	long	nPerSize = 0;
	for ( i = 0; i < nItems; i++ )
	{
		if ( pItems[i].mnBits & AFSIB_RELATIVESIZE )
			nRelSize += pItems[i].mnPixSize;
		else if ( pItems[i].mnBits & AFSIB_PERCENTSIZE )
			nPerSize += pItems[i].mnPixSize;
	}
	nPerSize += nRelSize;
	for ( i = 0; i < nItems; i++ )
	{
		if ( pItems[i].mnBits & AFSIB_RELATIVESIZE )
		{
			if ( nRelSize )
				pItems[i].mnSize = (pItems[i].mnPixSize+(nRelSize/2))/nRelSize;
			else
				pItems[i].mnSize = 1;
		}
		else if ( pItems[i].mnBits & AFSIB_PERCENTSIZE )
		{
			if ( nPerSize )
				pItems[i].mnSize = (pItems[i].mnPixSize*100)/nPerSize;
			else
				pItems[i].mnSize = 1;
		}
		else
			pItems[i].mnSize = pItems[i].mnPixSize;
	}
}

// -----------------------------------------------------------------------

void AdrFrameSet::ImplInit()
{
	ImplSplitSet* pNewSet	= new ImplSplitSet;
	pNewSet->mpItems		= NULL;
	pNewSet->mpWallpaper	= NULL;
	pNewSet->mpBitmap		= NULL;
	pNewSet->mnLastSize 	= 0;
	pNewSet->mnItems		= 0;
	pNewSet->mnId			= 0;
	pNewSet->mnSplitSize	= SPLITWIN_SPLITSIZE;
	pNewSet->mbCalcPix		= TRUE;

	mpParent				= NULL;
	mpMainSet				= pNewSet;
	mpBaseSet				= pNewSet;
	mpSplitSet				= NULL;
	mpLastSizes 			= NULL;
	mnDX					= 0;
	mnDY					= 0;
	mnLeftBorder			= 0;
	mnTopBorder 			= 0;
	mnRightBorder			= 0;
	mnBottomBorder			= 0;
	mnMaxSize				= 0;
	mnMouseOff				= 0;
	meAlign 				= WINDOWALIGN_TOP;
	mnSplitTest 			= 0;
	mnSplitPos				= 0;
	mnMouseModifier 		= 0;
	mnMStartPos 			= 0;
	mnMSplitPos 			= 0;
	mbDragFull				= FALSE;
	mbHorz					= TRUE;
	mbBottomRight			= FALSE;
	mbCalc					= FALSE;
	mbRecalc				= TRUE;
	mbInvalidate			= TRUE;
	mbAutoHide				= FALSE;
	mbFadeIn				= FALSE;
	mbFadeOut				= FALSE;
	mbAutoHideIn			= FALSE;
	mbAutoHideDown			= FALSE;
	mbFadeInDown			= FALSE;
	mbFadeOutDown			= FALSE;
	mbAutoHidePressed		= FALSE;
	mbFadeInPressed 		= FALSE;
	mbFadeOutPressed		= FALSE;
	mbFadeNoButtonMode		= FALSE;
	mbNoAlign				= FALSE;

	mnLeftBorder   = 0;
	mnTopBorder    = 0;
	mnRightBorder  = 0;
	mnBottomBorder = 0;

}

// =======================================================================

AdrFrameSet::AdrFrameSet()
{
	ImplInit();
}

// -----------------------------------------------------------------------

AdrFrameSet::~AdrFrameSet()
{
	// Sets loeschen
	ImplDeleteSet( mpMainSet );
}

// -----------------------------------------------------------------------

void AdrFrameSet::ImplCalcLayout()
{
	if ( !mbCalc || !mbRecalc || !mpMainSet->mpItems )
		return;

	long nSplitSize = mpMainSet->mnSplitSize-2;
	if ( mbAutoHide || mbFadeOut )
		nSplitSize += SPLITWIN_SPLITSIZEEX;


	if ( (mnDX <= 0) || (mnDY <= 0) )
		return;

	// Groessen/Position vorberechnen
	long	nL;
	long	nT;
	long	nW;
	long	nH;

	if ( mbHorz )
	{
		if ( mbBottomRight )
			nT = mnDY-mnBottomBorder;
		else
			nT = mnTopBorder;
		nL = mnLeftBorder;
	}
	else
	{
		if ( mbBottomRight )
			nL = mnDX-mnRightBorder;
		else
			nL = mnLeftBorder;
		nT = mnTopBorder;
	}
	nW = mnDX-mnLeftBorder-mnRightBorder;
	nH = mnDY-mnTopBorder-mnBottomBorder;

	// Sets rekursiv berechnen
	ImplCalcSet( mpMainSet, NULL, nL, nT, nW, nH, mbHorz, !mbBottomRight );
	ImplCalcSet2( mpMainSet, FALSE, mbHorz, !mbBottomRight );
	mbCalc = FALSE;
}

// -----------------------------------------------------------------------

void AdrFrameSet::ImplUpdate()
{
	mbCalc = TRUE;

	if ( mpMainSet->mpItems )
		ImplCalcLayout();
}

// -----------------------------------------------------------------------

void AdrFrameSet::ImplUpdateSet( ImplSplitSet* pSet )
{
	if ( mbRecalc )
	{
		// Wenn wir noch berechnen muessen, dann alles invalidieren.
		if ( mbCalc )
		{
			// Wenn nicht NOSPLITDRAW gesetzt ist, koennen wir uns das
			// invalidieren sparen, da bei ImplCalcSet2() die freien flaechen
			// sowieso invalidiert werden
			if ( !mpMainSet->mpItems )
				pSet = mpMainSet;
			else
				return;
		}

		Rectangle aRect;
		if ( pSet == mpMainSet )
		{
			aRect.Left()	= mnLeftBorder;
			aRect.Top() 	= mnTopBorder;
			aRect.Right()	= mnDX-mnRightBorder-1;
			aRect.Bottom()	= mnDY-mnBottomBorder-1;
		}
		else
		{
			ImplSplitItem*	pItem;
			USHORT			nPos;

			pSet = ImplFindItem( mpMainSet, pSet->mnId, nPos );
			pItem = &(pSet->mpItems[nPos]);
			aRect.Left()	= pItem->mnLeft;
			aRect.Top() 	= pItem->mnTop;
			aRect.Right()	= aRect.Left()+pItem->mnWidth;
			aRect.Bottom()	= aRect.Top()+pItem->mnHeight;
		}
	}
}

// -----------------------------------------------------------------------
Size AdrFrameSet::GetSizePixel()
{
	return Size(mnDX,mnDY);
}

void AdrFrameSet::SetSizePixel(const Size &aSize)
{
	if(mpParent != NULL)
	{
		mnDX = aSize.Width();
		mnDY = aSize.Height();

		ImplUpdate();
	}
}

// -----------------------------------------------------------------------

// -----------------------------------------------------------------------

void AdrFrameSet::InsertItem( USHORT nId, Window* pWindow, long nSize,
							  USHORT nPos, USHORT nSetId, AdrFrameSetItemBits nBits )
{
#ifdef DBG_UTIL
	USHORT nDbgDummy;
	DBG_ASSERT( ImplFindSet( mpMainSet, nSetId ), "AdrFrameSet::InsertItem() - Set not exists" );
	DBG_ASSERT( !ImplFindItem( mpMainSet, nId, nDbgDummy ), "AdrFrameSet::InsertItem() - Id already exists" );
#endif

	// Size muss min. 1 sein
	if ( nSize < 1 )
		nSize = 1;

	ImplSplitSet* pSet		 = ImplFindSet( mpMainSet, nSetId );
	ImplSplitSet* pNewSet;
	ImplSplitItem* pItem;

	// Platz fuer neues Item schaffen
	if ( nPos > pSet->mnItems )
		nPos = pSet->mnItems;
	ImplSplitItem* pNewItems = new ImplSplitItem[pSet->mnItems+1];
	if ( nPos )
		memcpy( pNewItems, pSet->mpItems, sizeof( ImplSplitItem )*nPos );
	if ( nPos < pSet->mnItems )
		memcpy( pNewItems+nPos+1, pSet->mpItems+nPos, sizeof( ImplSplitItem )*(pSet->mnItems-nPos) );
	delete pSet->mpItems;
	pSet->mpItems = pNewItems;
	pSet->mnItems++;
	pSet->mbCalcPix = TRUE;

	// Item anlegen und erweitern
	pItem			= &(pSet->mpItems[nPos]);
	memset( pItem, 0, sizeof( ImplSplitItem ) );
	pItem->mnSize	= nSize;
	pItem->mnId 	= nId;
	pItem->mnBits	= nBits;

	if ( pWindow )
	{
		pItem->mpWindow 		= pWindow;
		pItem->mpOrgParent		= pWindow->GetParent();

		Size aWinSize = pWindow->GetSizePixel();
		pItem->mnOrgHeight	= aWinSize.Height();
		pItem->mnOrgWidth	= aWinSize.Width();
		
		Point aPos = pWindow->GetPosPixel();
		pItem->mnOrgXPos	= aPos.X();
		pItem->mnOrgYPos	= aPos.Y();

		// Window mit AdrFrameSet verbinden
		pWindow->Hide();
		//pWindow->SetParent( this );
	}
	else
	{
		pNewSet 				= new ImplSplitSet;
		pNewSet->mpItems		= NULL;
		pNewSet->mpWallpaper	= NULL;
		pNewSet->mpBitmap		= NULL;
		pNewSet->mnLastSize 	= 0;
		pNewSet->mnItems		= 0;
		pNewSet->mnId			= nId;
		pNewSet->mnSplitSize	= pSet->mnSplitSize;
		pNewSet->mbCalcPix		= TRUE;

		pItem->mpSet			= pNewSet;
	}

	ImplUpdate();
}

// -----------------------------------------------------------------------

void AdrFrameSet::InsertItem( USHORT nId, long nSize,
							  USHORT nPos, USHORT nSetId,
							  AdrFrameSetItemBits nBits )
{
	InsertItem( nId, NULL, nSize, nPos, nSetId, nBits );
}

// -----------------------------------------------------------------------

void AdrFrameSet::MoveItem( USHORT nId, USHORT nNewPos, USHORT nNewSetId )
{
#ifdef DBG_UTIL
	USHORT nDbgDummy;
	DBG_ASSERT( ImplFindItem( mpMainSet, nId, nDbgDummy ), "AdrFrameSet::MoveItem() - Id not found" );
	DBG_ASSERT( ImplFindSet( mpMainSet, nNewSetId ), "AdrFrameSet::MoveItem() - Set not exists" );
#endif

	USHORT			nPos;
	ImplSplitSet*	 pNewSet = ImplFindSet( mpMainSet, nNewSetId );
	ImplSplitSet*	 pSet	 = ImplFindItem( mpMainSet, nId, nPos );
	ImplSplitItem	 aTempItem;

	if ( pNewSet == pSet )
	{
		if ( nNewPos >= pNewSet->mnItems )
			nNewPos = pNewSet->mnItems-1;
		if ( nPos != nNewPos )
		{
			memcpy( &aTempItem, &(pSet->mpItems[nPos]), sizeof( aTempItem ) );
			if ( nPos < nNewPos )
			{
				memmove( pSet->mpItems+nPos, pSet->mpItems+nPos+1,
						 (nNewPos-nPos)*sizeof( ImplSplitItem ) );
			}
			else
			{
				memmove( pSet->mpItems+nNewPos+1, pSet->mpItems+nNewPos,
						 (nPos-nNewPos)*sizeof( ImplSplitItem ) );
			}
			memcpy( &(pSet->mpItems[nNewPos]), &aTempItem, sizeof( aTempItem ) );

			ImplUpdate();
		}
	}
	else
	{
		if ( nNewPos >= pNewSet->mnItems )
			nNewPos = pNewSet->mnItems;
		memcpy( &aTempItem, &(pSet->mpItems[nPos]), sizeof( aTempItem ) );
		pSet->mnItems--;
		pSet->mbCalcPix = TRUE;
		if ( pSet->mnItems )
		{
			memmove( pSet->mpItems+nPos, pSet->mpItems+nPos+1,
					 (pSet->mnItems-nPos)*sizeof( ImplSplitItem ) );
		}
		else
		{
			delete pSet->mpItems;
			pSet->mpItems = NULL;
		}
		ImplSplitItem* pNewItems = new ImplSplitItem[pNewSet->mnItems+1];
		if ( nNewPos )
			memcpy( pNewItems, pNewSet->mpItems, sizeof( ImplSplitItem )*nNewPos );
		if ( nNewPos < pNewSet->mnItems )
		{
			memcpy( pNewItems+nNewPos+1, pNewSet->mpItems+nNewPos,
					sizeof( ImplSplitItem )*(pNewSet->mnItems-nNewPos) );
		}
		delete pNewSet->mpItems;
		pNewSet->mpItems = pNewItems;
		pNewSet->mnItems++;
		pNewSet->mbCalcPix = TRUE;
		memcpy( &(pNewSet->mpItems[nNewPos]), &aTempItem, sizeof( aTempItem ) );
		ImplUpdate();
	}
}

// -----------------------------------------------------------------------

void AdrFrameSet::RemoveItem( USHORT nId, BOOL bHide )
{
#ifdef DBG_UTIL
	USHORT nDbgDummy;
	DBG_ASSERT( ImplFindItem( mpMainSet, nId, nDbgDummy ), "AdrFrameSet::RemoveItem() - Id not found" );
#endif

	// Set suchen
	USHORT			nPos;
	ImplSplitSet*	 pSet	 = ImplFindItem( mpMainSet, nId, nPos );
	ImplSplitItem*	 pItem	 = &(pSet->mpItems[nPos]);
	Window* 		pWindow = pItem->mpWindow;
	Window* 		pOrgParent = pItem->mpOrgParent;

	// Evt. Set loeschen
	if ( !pWindow )
		ImplDeleteSet( pItem->mpSet );

	// Item entfernen
	pSet->mnItems--;
	pSet->mbCalcPix = TRUE;
	if ( pSet->mnItems )
	{
		memmove( pSet->mpItems+nPos, pSet->mpItems+nPos+1,
				 (pSet->mnItems-nPos)*sizeof( ImplSplitItem ) );
	}
	else
	{
		delete pSet->mpItems;
		pSet->mpItems = NULL;
	}

	ImplUpdate();

	if ( pWindow && bHide)
	{
		pWindow->Hide();
	}
}

// -----------------------------------------------------------------------

void AdrFrameSet::Clear()
{
	// Alle Sets loeschen
	ImplDeleteSet( mpMainSet );

	// Main-Set wieder anlegen
	mpMainSet					= new ImplSplitSet;
	mpMainSet->mpItems			= NULL;
	mpMainSet->mpWallpaper		= NULL;
	mpMainSet->mpBitmap 		= NULL;
	mpMainSet->mnLastSize		= 0;
	mpMainSet->mnItems			= 0;
	mpMainSet->mnId 			= 0;
	mpMainSet->mnSplitSize		= SPLITWIN_SPLITSIZE;
	mpMainSet->mbCalcPix		= TRUE;
	mpBaseSet					= mpMainSet;

	// Und neu invalidieren
	ImplUpdate();
}

// -----------------------------------------------------------------------

void AdrFrameSet::SetBaseSet( USHORT nSetId )
{
	mpBaseSet = ImplFindSet( mpMainSet, nSetId );
}

// -----------------------------------------------------------------------

USHORT AdrFrameSet::GetBaseSet() const
{
	return mpBaseSet->mnId;
}

// -----------------------------------------------------------------------

void AdrFrameSet::SetSplitSize( USHORT nSetId, long nSplitSize,
								BOOL bWithChilds )
{
	ImplSplitSet* pSet = ImplFindSet( mpMainSet, nSetId );
	if ( pSet )
	{
		if ( bWithChilds )
			ImplSetSplitSize( pSet, nSplitSize );
		else
			pSet->mnSplitSize = nSplitSize;
	}
	ImplUpdate();
}

// -----------------------------------------------------------------------

long AdrFrameSet::GetSplitSize( USHORT nSetId ) const
{
	ImplSplitSet* pSet = ImplFindSet( mpMainSet, nSetId );
	if ( pSet )
		return pSet->mnSplitSize;
	else
		return 0;
}

// -----------------------------------------------------------------------

void AdrFrameSet::SplitItem( USHORT nId, long nNewSize,
							 BOOL bPropSmall, BOOL bPropGreat )
{
	USHORT			nItems;
	USHORT			nPos;
	USHORT			nMin;
	USHORT			nMax;
	USHORT			i;
	USHORT			n;
	long			nDelta;
	long			nTempDelta;
	ImplSplitSet*	pSet = ImplFindItem( mpBaseSet, nId, nPos );
	ImplSplitItem*	pItems;

	if ( !pSet )
		return;

	nItems = pSet->mnItems;
	pItems = pSet->mpItems;

	if ( mbCalc )
	{
		pItems[nPos].mnSize = nNewSize;
		return;
	}

	nDelta = nNewSize-pItems[nPos].mnPixSize;
	if ( !nDelta )
		return;

	// Bereich berechnen, der beim Splitten betroffen sein kann
	nMin = 0;
	nMax = nItems;
	for ( i = 0; i < nItems; i++ )
	{
		if ( pItems[i].mbFixed )
		{
			if ( i < nPos )
				nMin = i+1;
			else
				nMax = i;
		}
	}

	// Wenn das Fenster sizeable ist, wird das TopSet anders behandelt
	BOOL bSmall  = TRUE;
	BOOL bGreat  = TRUE;
	if ( pSet == mpMainSet)
	{
		if ( nPos < pSet->mnItems-1 )
		{
			if ( !((bPropSmall && bPropGreat) ||
				   ((nDelta > 0) && bPropSmall) ||
				   ((nDelta < 0) && bPropGreat)) )
			{
				if ( nDelta < 0 )
					bGreat = FALSE;
				else
					bSmall = FALSE;
			}
		}
		else
		{
			if ( nDelta < 0 )
				bGreat = FALSE;
			else
				bSmall = FALSE;
		}
	}
	else if ( nPos >= nMax )
	{
		bSmall = FALSE;
		bGreat = FALSE;
	}
	else if ( nPos && (nPos >= pSet->mnItems-1) )
	{
		nPos--;
		nDelta *= -1;
		BOOL bTemp = bPropSmall;
		bPropSmall = bPropGreat;
		bPropGreat = bTemp;
	}

	// Jetzt die Fenster splitten
	if ( nDelta < 0 )
	{
		if ( bGreat )
		{
			if ( bPropGreat )
			{
				nTempDelta = nDelta;
				do
				{
					n = nPos+1;
					do
					{
						if ( nTempDelta )
						{
							pItems[n].mnPixSize++;
							nTempDelta++;
						}
						n++;
					}
					while ( n < nMax );
				}
				while ( nTempDelta );
			}
			else
				pItems[nPos+1].mnPixSize -= nDelta;
		}

		if ( bSmall )
		{
			if ( bPropSmall )
			{
				do
				{
					n = nPos+1;
					do
					{
						if ( nDelta && pItems[n-1].mnPixSize )
						{
							pItems[n-1].mnPixSize--;
							nDelta++;
						}

						n--;
					}
					while ( n > nMin );
				}
				while ( nDelta );
			}
			else
			{
				n = nPos+1;
				do
				{
					if ( pItems[n-1].mnPixSize+nDelta < 0 )
					{
						nDelta += pItems[n-1].mnPixSize;
						pItems[n-1].mnPixSize = 0;
					}
					else
					{
						pItems[n-1].mnPixSize += nDelta;
						break;
					}
					n--;
				}
				while ( n > nMin );
			}
		}
	}
	else
	{
		if ( bGreat )
		{
			if ( bPropGreat )
			{
				nTempDelta = nDelta;
				do
				{
					n = nPos+1;
					do
					{
						if ( nTempDelta )
						{
							pItems[n-1].mnPixSize++;
							nTempDelta--;
						}
						n--;
					}
					while ( n > nMin );
				}
				while ( nTempDelta );
			}
			else
				pItems[nPos].mnPixSize += nDelta;
		}

		if ( bSmall )
		{
			if ( bPropSmall )
			{
				do
				{
					n = nPos+1;
					do
					{
						if ( nDelta && pItems[n].mnPixSize )
						{
							pItems[n].mnPixSize--;
							nDelta--;
						}

						n++;
					}
					while ( n < nMax );
				}
				while ( nDelta );
			}
			else
			{
				n = nPos+1;
				do
				{
					if ( pItems[n].mnPixSize-nDelta < 0 )
					{
						nDelta -= pItems[n].mnPixSize;
						pItems[n].mnPixSize = 0;
					}
					else
					{
						pItems[n].mnPixSize -= nDelta;
						break;
					}
					n++;
				}
				while ( n < nMax );
			}
		}
	}

	// Original-Groessen updaten
	ImplCalcLogSize( pItems, nItems );

	ImplUpdate();
}

// -----------------------------------------------------------------------

void AdrFrameSet::SetItemSize( USHORT nId, long nNewSize )
{
	USHORT			nPos;
	ImplSplitSet*	pSet = ImplFindItem( mpBaseSet, nId, nPos );
	ImplSplitItem*	pItem;

	if ( !pSet )
		return;

	// Testen, ob sich Groesse aendert
	pItem = &(pSet->mpItems[nPos]);
	if ( pItem->mnSize != nNewSize )
	{
		// Neue Groesse setzen und neu durchrechnen
		pItem->mnSize = nNewSize;
		pSet->mbCalcPix = TRUE;
		ImplUpdate();
	}
}

// -----------------------------------------------------------------------

long AdrFrameSet::GetItemSize( USHORT nId ) const
{
	USHORT			nPos;
	ImplSplitSet*	pSet = ImplFindItem( mpBaseSet, nId, nPos );

	if ( pSet )
		return pSet->mpItems[nPos].mnSize;
	else
		return 0;
}

// -----------------------------------------------------------------------

long AdrFrameSet::GetItemSize( USHORT nId, AdrFrameSetItemBits nBits ) const
{
	USHORT			nPos;
	ImplSplitSet*	pSet = ImplFindItem( mpBaseSet, nId, nPos );

	if ( pSet )
	{
		if ( nBits == pSet->mpItems[nPos].mnBits )
			return pSet->mpItems[nPos].mnSize;
		else
		{
			((AdrFrameSet*)this)->ImplCalcLayout();

			long				nRelSize = 0;
			long				nPerSize = 0;
			ImplSplitItem*		pItems;
			USHORT				nItems;
			AdrFrameSetItemBits nTempBits;
			USHORT				i;
			nItems = pSet->mnItems;
			pItems = pSet->mpItems;
			for ( i = 0; i < nItems; i++ )
			{
				if ( i == nPos )
					nTempBits = nBits;
				else
					nTempBits = pItems[i].mnBits;
				if ( nTempBits & AFSIB_RELATIVESIZE )
					nRelSize += pItems[i].mnPixSize;
				else if ( nTempBits & AFSIB_PERCENTSIZE )
					nPerSize += pItems[i].mnPixSize;
			}
			nPerSize += nRelSize;
			if ( nBits & AFSIB_RELATIVESIZE )
			{
				if ( nRelSize )
					return (pItems[nPos].mnPixSize+(nRelSize/2))/nRelSize;
				else
					return 1;
			}
			else if ( nBits & AFSIB_PERCENTSIZE )
			{
				if ( nPerSize )
					return (pItems[nPos].mnPixSize*100)/nPerSize;
				else
					return 1;
			}
			else
				return pItems[nPos].mnPixSize;
		}
	}
	else
		return 0;
}

// -----------------------------------------------------------------------

void AdrFrameSet::SetItemBits( USHORT nId, AdrFrameSetItemBits nNewBits )
{
	USHORT			nPos;
	ImplSplitSet*	pSet = ImplFindItem( mpBaseSet, nId, nPos );
	ImplSplitItem*	pItem;

	if ( !pSet )
		return;

	pItem = &(pSet->mpItems[nPos]);
	if ( pItem->mpWindow )
		nNewBits &= ~AFSIB_COLSET;

	if ( pItem->mnBits != nNewBits )
	{
		// Neue Bits setzen und neu durchrechnen
		pItem->mnBits = nNewBits;
		pSet->mbCalcPix = TRUE;
		ImplUpdate();
	}
}

// -----------------------------------------------------------------------

AdrFrameSetItemBits AdrFrameSet::GetItemBits( USHORT nId ) const
{
	USHORT			nPos;
	ImplSplitSet*	pSet = ImplFindItem( mpBaseSet, nId, nPos );

	if ( pSet )
		return pSet->mpItems[nPos].mnBits;
	else
		return 0;
}

// -----------------------------------------------------------------------

Window* AdrFrameSet::GetItemWindow( USHORT nId ) const
{
	USHORT			nPos;
	ImplSplitSet*	pSet = ImplFindItem( mpBaseSet, nId, nPos );

	if ( pSet )
		return pSet->mpItems[nPos].mpWindow;
	else
		return NULL;
}

// -----------------------------------------------------------------------

USHORT AdrFrameSet::GetSet( USHORT nId ) const
{
	USHORT			nPos;
	ImplSplitSet*	pSet = ImplFindItem( mpBaseSet, nId, nPos );

	if ( pSet )
		return pSet->mnId;
	else
		return 0;
}

// -----------------------------------------------------------------------

BOOL AdrFrameSet::GetSet( USHORT nId, USHORT& rSetId, USHORT& rPos ) const
{
	ImplSplitSet* pSet = ImplFindItem( mpBaseSet, nId, rPos );
	if ( pSet )
	{
		rSetId = pSet->mnId;
		return TRUE;
	}
	else
		return FALSE;
}

// -----------------------------------------------------------------------

BOOL AdrFrameSet::IsItemValid( USHORT nId ) const
{
	USHORT			nPos;
	ImplSplitSet*	pSet = ImplFindItem( mpBaseSet, nId, nPos );

	if ( pSet )
		return TRUE;
	else
		return FALSE;
}

// -----------------------------------------------------------------------

USHORT AdrFrameSet::GetItemId( Window* pWindow ) const
{
	return ImplFindItem( mpBaseSet, pWindow );
}

// -----------------------------------------------------------------------

USHORT AdrFrameSet::GetItemId( const Point& rPos ) const
{
	return ImplFindItem( mpBaseSet, rPos, mbHorz, !mbBottomRight );
}

// -----------------------------------------------------------------------

USHORT AdrFrameSet::GetItemPos( USHORT nId, USHORT nSetId ) const
{
	ImplSplitSet*	pSet = ImplFindSet( mpBaseSet, nSetId );
	USHORT			nPos = ADR_FRAMESET_ITEM_NOTFOUND;

	if ( pSet )
	{
		for ( USHORT i = 0; i < pSet->mnItems; i++ )
		{
			if ( pSet->mpItems[i].mnId == nId )
			{
				nPos = i;
				break;
			}
		}
	}

	return nPos;
}
Point AdrFrameSet::GetOriginalItemPos( USHORT nPos, USHORT nSetId ) const
{
	Point aResPos;
	Size aResSize;
	GetOriginalItemPosSize(aResPos, aResSize, nPos, nSetId);
	
	return aResPos;
}
Size AdrFrameSet::GetOriginalItemSize( USHORT nPos, USHORT nSetId) const
{
	Point aResPos;
	Size aResSize;
	GetOriginalItemPosSize(aResPos, aResSize, nPos, nSetId);

	return aResSize;
}

void AdrFrameSet::SetOriginalItemPos(const Point& aPos, USHORT nPos, USHORT nSetId)
{
	Point aResPos;
	ImplSplitSet*	pSet = ImplFindSet( mpBaseSet, nSetId );

	if ( pSet && (nPos < pSet->mnItems) )
	{
		pSet->mpItems[nPos].mnOrgXPos = aPos.X();
		pSet->mpItems[nPos].mnOrgYPos = aPos.Y();
	}
}

void AdrFrameSet::SetOriginalItemSize(const Size& aSize, USHORT nPos, USHORT nSetId)
{
	ImplSplitSet*	pSet = ImplFindSet( mpBaseSet, nSetId );

	if ( pSet && (nPos < pSet->mnItems) )
	{
		pSet->mpItems[nPos].mnOrgHeight = aSize.Height();
		pSet->mpItems[nPos].mnOrgWidth  = aSize.Width() ;
	}
}

BOOL AdrFrameSet::SetOriginalItemPosSize(const Point& aPos, const Size& aSize, USHORT nPos, USHORT nSetId)
{
	BOOL bFlag = FALSE;
	ImplSplitSet*	pSet = ImplFindSet( mpBaseSet, nSetId );

	if ( pSet && (nPos < pSet->mnItems) )
	{
		pSet->mpItems[nPos].mnOrgXPos = aPos.X();
		pSet->mpItems[nPos].mnOrgYPos = aPos.Y();
		pSet->mpItems[nPos].mnOrgHeight = aSize.Height();
		pSet->mpItems[nPos].mnOrgWidth  = aSize.Width() ;
		bFlag = TRUE;
	}
	return bFlag;
}

BOOL AdrFrameSet::GetOriginalItemPosSize(Point& rResPos, Size& rResSize,  USHORT nPos, USHORT nSetId) const
{
	BOOL bFlag = FALSE;
	ImplSplitSet*	pSet = ImplFindSet( mpBaseSet, nSetId );

	if ( pSet && (nPos < pSet->mnItems) )
	{
		rResPos.X() = pSet->mpItems[nPos].mnOrgXPos;
		rResPos.Y() = pSet->mpItems[nPos].mnOrgYPos;
		rResSize.Height() = pSet->mpItems[nPos].mnOrgHeight;
		rResSize.Width()  = pSet->mpItems[nPos].mnOrgWidth;
		bFlag = TRUE;
	}
	return bFlag;
}


// -----------------------------------------------------------------------

USHORT AdrFrameSet::GetItemId( USHORT nPos, USHORT nSetId ) const
{
	ImplSplitSet* pSet = ImplFindSet( mpBaseSet, nSetId );
	if ( pSet && (nPos < pSet->mnItems) )
		return pSet->mpItems[nPos].mnId;
	else
		return 0;
}

// -----------------------------------------------------------------------

USHORT AdrFrameSet::GetItemCount( USHORT nSetId ) const
{
	ImplSplitSet* pSet = ImplFindSet( mpBaseSet, nSetId );
	if ( pSet )
		return pSet->mnItems;
	else
		return 0;
}

// -----------------------------------------------------------------------

void AdrFrameSet::ImplNewAlign()
{
	if ( mbNoAlign )
	{
		mbHorz		  = FALSE;
		mbBottomRight = FALSE;
	}
	else if ( meAlign == WINDOWALIGN_TOP )
	{
		mbHorz		  = TRUE;
		mbBottomRight = FALSE;
	}
	else if ( meAlign == WINDOWALIGN_BOTTOM )
	{
		mbHorz		  = TRUE;
		mbBottomRight = TRUE;
	}
	else if ( meAlign == WINDOWALIGN_LEFT )
	{
		mbHorz		  = FALSE;
		mbBottomRight = FALSE;
	}
	else if ( meAlign == WINDOWALIGN_RIGHT )
	{
		mbHorz		  = FALSE;
		mbBottomRight = TRUE;
	}

	ImplUpdate();
}

// -----------------------------------------------------------------------

void AdrFrameSet::SetNoAlign( BOOL bNoAlign )
{
	bNoAlign = bNoAlign != 0;
	if ( mbNoAlign != bNoAlign )
	{
		mbNoAlign = bNoAlign;
		ImplNewAlign();
	}
}

// -----------------------------------------------------------------------

void AdrFrameSet::SetAlign( WindowAlign eNewAlign )
{
	if ( meAlign != eNewAlign )
	{
		meAlign = eNewAlign;
		ImplNewAlign();
	}
}

BOOL AdrFrameSet::IsFieldResizable(Window* pField)
{
	return !(pField->GetType() == WINDOW_FIXEDTEXT ||
			pField->GetType() == WINDOW_BUTTON	||
			pField->GetType() == WINDOW_PUSHBUTTON);
}

void AdrFrameSet::SetFieldBackground(Window* pField)
{
	if(pField->GetType() == WINDOW_FIXEDTEXT)
	{
		pField->SetBackground(mpParent->GetBackground());
		pField->SetPaintTransparent(FALSE);
	}
}

void AdrFrameSet::InitPage(Window *pParent, Size *pSize)
{
	mpParent = pParent;

	if(mpParent != NULL)
	{
		if(!nGLineHeight)
		{
			ListBox aListBox(mpParent, WB_DROPDOWN);

			aListBox.SetPosSizePixel(Point(0,0),Size(100,100));
			nGLineHeight=aListBox.GetSizePixel().Height();
			nGLineHeight+=2;
		}

		if(pSize!=NULL)
		   maOriginalSize =*pSize;

		if(maOriginalSize.Width() == 0)
			maOriginalSize=mpParent->GetOutputSizePixel();

		SetSizePixel(maOriginalSize);
		MakeLayout();
	}
	else 
		Clear();
}

void AdrFrameSet::MakeLayout()
{
	USHORT	nChilds = mpParent->GetChildCount();

	for(USHORT i=0; i< nChilds; i++)
	{
		Window* pChild = mpParent->GetChild(i);

		if(pChild!=NULL)
			InsertWindow(FindPos(pChild), pChild);
	}

	InitLayout();
}

void AdrFrameSet::InitLayout()
{
	Size aOutputSize(maOriginalSize);
	USHORT nCount= GetItemCount();

	short i;
	for(i=0; i< nCount;i++)
	{
		USHORT nID=GetItemId(i);
		Window* pWindow=GetItemWindow(nID);
		if(pWindow==NULL)
		{
			Point aOldPos;
			Size aOldSize;
			USHORT nSetCount= GetItemCount(nID);
			long nDiff = 0;
			short j;
			for( j=0; j< nSetCount; j++)
			{
				Point aPos;
				Size  aSize;
				
				GetOriginalItemPosSize(aPos, aSize,j,nID);
				
				USHORT nChildID=GetItemId(j,nID);
				Window* pWin = GetItemWindow(nChildID);
				if(pWin!=NULL)
				{
					if(!IsFieldResizable(pWin))
					{
						SetItemBits(nChildID,AFSIB_FIXED);
					}
					SetItemSize(nChildID,aSize.Width());
				}

				nDiff = aPos.X() -(aOldPos.X() + aOldSize.Width());

				if( nDiff > 0)
				{
					USHORT nFieldID = GetNextFieldID(nID);
					InsertItem( nFieldID, NULL,nDiff, j,
											nID, AFSIB_RELATIVESIZE);
					
					SetSplitSize(nFieldID, 0);
					
					Size a2Size(nDiff,aSize.Height());
					Point a2Pos(aOldPos.X() + aOldSize.Width(), aPos.Y());
					SetOriginalItemPosSize(a2Pos,a2Size, j,nID);
					j++;
					nSetCount++;
				}
				
				aOldPos	 = aPos;
				aOldSize = aSize;				
			}

			nDiff = aOutputSize.Width()-(aOldPos.X() + aOldSize.Width());
			if( nDiff > 0)
			{
				USHORT nFieldID = GetNextFieldID(nID);
				InsertItem( nFieldID, NULL,nDiff, ADR_FRAMESET_APPEND,
										nID,AFSIB_RELATIVESIZE);
				
				SetSplitSize(nFieldID, 0);
				Size a2Size(nDiff,aOldSize.Height());
				Point a2Pos(aOldPos.X() + aOldSize.Width(), aOldPos.Y());
				SetOriginalItemPosSize(a2Pos,a2Size, j,nID);
			}
		}
	}
	
	long nFixPart = GetMaxFixPart();
}

long AdrFrameSet::GetMaxFixPart()
{
	USHORT nCount= GetItemCount();

	long nMaxFix = 0;
	
	for(short i=0; i< nCount;i++)
	{
		USHORT nID=GetItemId(i);
		long nFixLinePart = GetFixLinePart(nID);
		
		if(nFixLinePart > nMaxFix)
			nMaxFix = nFixLinePart;
	}
	return nMaxFix;
}

long AdrFrameSet::GetFixLinePart(USHORT nID)
{
	long nFixLinePart = 0;
	Window* pWindow=GetItemWindow(nID);
	if(pWindow==NULL)
	{
		Point aOldPos;
		Size aOldSize;
		USHORT nSetCount= GetItemCount(nID);
		long nDiff = 0;
		short j;
		for( j=0; j< nSetCount; j++)
		{
			USHORT nChildID=GetItemId(j,nID);
			if(GetItemBits(nChildID) == AFSIB_FIXED)
			{
				nFixLinePart += GetItemSize(nChildID);
			}
		}
	}

	return nFixLinePart;
}

USHORT AdrFrameSet::GetLinePos(Window *pField)
{
	Point aPos=pField->GetPosPixel();

	float nfLine = (float)aPos.Y() / (float)nGLineHeight;
	
	return (USHORT) nfLine;

}

USHORT AdrFrameSet::GetColPos(Window *pField, USHORT nLine)
{
	USHORT nRes= ADR_FRAMESET_APPEND;
	USHORT nLineID=GetLineID(nLine);
	if(nLineID != ADR_FRAMESET_APPEND)
	{
		Window* pWindow=GetItemWindow(nLineID);
		if(pWindow==NULL)
		{
			Point aPos=pField->GetPosPixel();
			USHORT nSetCount= GetItemCount(nLineID);
			for(short j=0 ; j < nSetCount; j++)
			{
				Point aOrgPos = GetOriginalItemPos(j,nLineID);

				if(aOrgPos.X() > aPos.X())
				{
					nRes = j;
					break;
				}
			}
		}		
	}

	return nRes;
}
Point AdrFrameSet::FindPos(Window *pField)
{
	Point aResPos;

	USHORT nPos = GetLinePos(pField);
	aResPos.Y() = nPos;
	
	aResPos.X() = GetColPos(pField, nPos);
	return aResPos;
}

USHORT AdrFrameSet::InsertLine(USHORT nPos,USHORT nCount)
{
	USHORT nItemCount = GetItemCount();

	if(nPos >= nItemCount)
	{
		short nDiff= nPos - nItemCount;
		nPos = nItemCount;
		nCount += nDiff;
	}

	USHORT nNewLineID = DEFAULT_LINE_ID;
	
	for(short j=0; j< nItemCount;j++)
	{
		USHORT nLineID=GetItemId(j);
		if(nLineID >= nNewLineID)
			nNewLineID = nLineID + DEFAULT_LINE_ID;
	}
	
	USHORT nResLineId = nNewLineID;
	
	for(short i=0; i<nCount;i++)
	{
		InsertItem( nNewLineID,NULL,nGLineHeight,nPos+i, 0, AFSIB_FIXED | AFSIB_COLSET);
		SetSplitSize(nNewLineID, 0);
		nNewLineID = nNewLineID + DEFAULT_LINE_ID;
	}

	return nResLineId;
}

USHORT AdrFrameSet::GetLineID(USHORT nPos)
{
	USHORT nID = ADR_FRAMESET_APPEND;
	USHORT nCount= GetItemCount();

	if(nPos < nCount)
	{
		nID=GetItemId(nPos);
		if(nID != ADR_FRAMESET_APPEND)
		{
			Window* pWindow=GetItemWindow(nID);
			if(pWindow!=NULL)
				nID = ADR_FRAMESET_APPEND;
		}
	}
	return nID;
}

void AdrFrameSet::InsertWindow(Point aPos, Window *pField)
{
	if(pField!=NULL)
	{
		SetFieldBackground(pField);
		USHORT nSetId=GetLineID((USHORT)aPos.Y());

		if(nSetId == ADR_FRAMESET_APPEND)
		{
			nSetId=InsertLine((USHORT)aPos.Y());
		}

		USHORT nFieldID = GetNextFieldID(nSetId);

		InsertItem( nFieldID,pField,
			pField->GetSizePixel().Width(),(USHORT)aPos.X(), nSetId,AFSIB_RELATIVESIZE);
		SetSplitSize(nFieldID, 0);
	}
}

USHORT AdrFrameSet::GetNextFieldID(USHORT nSetId)
{
	USHORT nSetCount= GetItemCount(nSetId);
	USHORT nFieldID = DEFAULT_WIN_ID + nSetId;
	
	for(short j=0; j< nSetCount;j++)
	{
		USHORT nChildID=GetItemId(j,nSetId);
		if(nChildID >= nFieldID)
			nFieldID = nChildID+1;
	}
	return nFieldID;
}

long AdrFrameSet::GetMaxFixTextWidth()
{
	long	nWidth = 0;
	
	if(mpParent!=NULL)
	{
		USHORT	nChilds = mpParent->GetChildCount();
		USHORT i = 0;
		Size aSize;

		for(i=1; i< nChilds; i++)
		{
			Window* pChild = mpParent->GetChild(i);

			if(pChild!=NULL && pChild->GetType() == WINDOW_FIXEDTEXT)
			{
				aSize = pChild->GetTextSize(pChild->GetText());

				if(nWidth < aSize.Width())
					nWidth = aSize.Width();
			}				
		}

		nWidth+=5;
	}

	return nWidth;
}
	
void AdrFrameSet::SetFixTextWidth(long nWidth)
{
	if(mpParent!=NULL)
	{
		USHORT	i = 0;
		USHORT	nChilds = mpParent->GetChildCount();

		for(i=0; i< nChilds; i++)
		{
			Window* pChild = mpParent->GetChild(i);

			if(pChild!=NULL && pChild->GetType() == WINDOW_FIXEDTEXT)
			{
				USHORT nFieldID	= GetItemId(pChild);
				long nDiff = GetItemSize(nFieldID);
				SetItemSize( nFieldID, nWidth);
				nDiff -= nWidth;
				USHORT nSetId = 0;
				USHORT nPos	= 0;

				if(GetSet(nFieldID,nSetId,nPos))
				{
					USHORT	nCount =GetItemCount(nSetId);

					for(;nPos < nCount;nPos++)
					{
						USHORT nChildID=GetItemId(nPos,nSetId);
					
						Window* pWin = GetItemWindow(nChildID);

						if(pWin == NULL && GetItemBits(nChildID) == AFSIB_FIXED)
						{
							long nItemWidth = GetItemSize( nChildID);
							nItemWidth  -= nDiff;
							SetItemSize( nChildID, nItemWidth);
							break;
						}
					}
				}
			}				
		}
	}
}



