
package org.netbeans.modules.openoffice;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

import java.util.HashMap;

import org.openide.compiler.Compiler;
import org.openide.compiler.ExternalCompilerGroup;
import org.openide.execution.NbProcessDescriptor;
import org.openide.util.MapFormat;

/**
 *
 * @author  Michael Bohn, Bertram Nolte
 *
 */


public class OOURDCompilerGroup extends ExternalCompilerGroup {
    
    /** Add the (one) compiler to the group.
     * @param c must be a make compiler
     * @throws IllegalArgumentException if not
     */
    public void add(Compiler c) throws IllegalArgumentException {
        if (! (c instanceof OOURDCompiler))
            throw new IllegalArgumentException();
        super.add(c);
        OOURDCompiler mc = (OOURDCompiler) c;
    }
    
    /** Create the process to run make.
     * @param desc the command template
     * @param files must be one filename
     * @throws IOException if not, or any other problem
     * @return the process
     */
    protected Process createProcess(NbProcessDescriptor desc, String[] files)
    throws IOException {
        // Declare a string array for the environment variables.
        String[] stringEnvironmentVariables = null;
        
        if ( System.getProperty( "os.name" ).indexOf( "Windows" ) != -1 ) {
            // Create environment variables for windows in a string array.
            stringEnvironmentVariables = new String[] { "LIB="
            + OOIDLGlobalSettings.getDefault().getOfficeDirectory()
            + System.getProperty( "file.separator" ) + "program;"
            + OOIDLGlobalSettings.getDefault().getSDKDirectory()
            + System.getProperty( "file.separator" ) + "windows"
            + System.getProperty( "file.separator" ) + "lib",
            "PATH="
            + OOIDLGlobalSettings.getDefault().getOfficeDirectory()
            + System.getProperty( "file.separator" ) + "program;"
            + OOIDLGlobalSettings.getDefault().getSDKDirectory()
            + System.getProperty( "file.separator" ) + "windows"
            + System.getProperty( "file.separator" ) + "bin"
            };
        }
        else if ( ( System.getProperty( "os.name" ).indexOf( "Linux" ) != -1 )
        || ( System.getProperty( "os.name" ).indexOf( "SunOS" ) != -1 ) ) {
            // Create environment variables for Linux or Solaris in a string
            // array.
            stringEnvironmentVariables = new String []{ "LD_LIBRARY_PATH="
            + OOIDLGlobalSettings.getDefault().getOfficeDirectory()
            + System.getProperty( "file.separator" ) + "program" };
        }
        
        return desc.exec( new Format( files[ 0 ] ),
        stringEnvironmentVariables );
    }
    
    
    /** Formats files and directory tags.
     */
    public static class Format extends MapFormat {
        
        /** Tag for the URD fiel basename.
         */
        
        public static final String TAG_RDB_FILE = "RDBfile";
        /** Tag for the URD files containing directory.
         */
        public static final String TAG_OUTPUT_DIRECTORY = "outputdirectory";
        
        public static final String TAG_NEEDED_LIBS = "neededlibs";
        
        public static final String  TAG_TARGET_ELEMENT = "targetElement";
        
        public static final String TAG_UDKINSTALL_DIRECTORY = 
        "udk_install_directory";
        
        /** generated
         */
        
        
        /** Creates the format.
         * @param file the makefile
         * @param target the make target
         */
        public Format( String file ) {
            super ( new HashMap( 4 ) );
            OOIDLGlobalSettings oGlobalSettings =
            OOIDLGlobalSettings.getDefault();
            
            File f = new File( file );
            
            getMap().put( TAG_UDKINSTALL_DIRECTORY,
            oGlobalSettings.getSDKDirectory()
            + System.getProperty( "file.separator" )
            + OOTools.getODKSystemDirectory() );
            
            getMap().put(TAG_RDB_FILE, OOTools.getFilesystemName( f )
            + System.getProperty( "file.separator" ) + "types.rdb" );
            
            getMap().put( TAG_TARGET_ELEMENT,
            OOTools.getTargetElementName( f ) );
            
            getMap().put( TAG_NEEDED_LIBS,
            oGlobalSettings.getOfficeDirectory()
            + System.getProperty( "file.separator" )
            + "program"
            + System.getProperty( "file.separator" )
            + "applicat.rdb" );
            //            getMap().put( TAG_NEEDED_LIBS,
            //            oGlobalSettings.getSDKDirectory()
            //            + System.getProperty( "file.separator" )
            //            + OOTools.getODKSystemDirectory()
            //            + System.getProperty( "file.separator" )
            //            + "bin" + System.getProperty( "file.separator" ) + "applicat.rdb" );
            
            getMap().put( TAG_OUTPUT_DIRECTORY,
            OOTools.getFilesystemName( f ) );
        }
    }
    
    public static void writeDBG(String zeile) {
        try {
//            PrintStream prS = new PrintStream(new FileOutputStream(
//            "c:\\log.txt",true));
//            prS.println(zeile);
//            prS.close();
        }catch (Exception e){}
    }
}
