/*************************************************************************
 *
 *  $RCSfile: dbtabobj.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:32:47 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SBA_DBTABOBJ_HXX
#define _SBA_DBTABOBJ_HXX

#ifndef _SBA_DBDATDEF_HXX
#include "dbdatdef.hxx"
#endif

#ifndef _SBA_DBEXCH_HXX
#include "dbexch.hxx"
#endif

#ifndef _SDB_SDBTAB_HXX //autogen
#include <sdb/sdbtab.hxx>
#endif

#ifndef _SDB_SDBIDX_HXX
#include <sdb/sdbidx.hxx>
#endif

//==================================================================
// SbaIndexDef
//==================================================================
class SbaIndexDef : public SvRefBase		// Entspricht einer Spalte im Index
{
	friend class SbaTableDef;
	friend class SbaTableIndexCtrl;

protected:
	String			aName, aQualifierName;
	SdbColumnsRef	aColumns;

	BOOL			bUnique			: 1,
					bCase			: 1,
					bSystemReadOnly : 1;

	SbaIndexDef(const SbaTableDef& _rTable);
	SbaIndexDef(const SbaTableDef& _rTable, const SbaIndexDef& _rIndex);
	SbaIndexDef(const SbaTableDef& _rTable, const SdbIndex& _rIndex);
	SbaIndexDef(const SbaTableDef& _rTable, const String& rQualifier, const String& rName, BOOL bUniq,BOOL bReadOnly=FALSE);
	~SbaIndexDef();

public:
	SdbColumnsRef GetColumns() const {return aColumns;}

	// Der Name des Index etc.
	const String& GetName() const {return aName;}
	const String& GetQualifier() const {return aQualifierName;}
	inline String GetFullName() const;
	BOOL IsUnique() const {return bUnique;}
	BOOL IsSystemReadOnly() const { return bSystemReadOnly;}

	virtual SbaIndexDef* Clone(const SbaTableDef& _rTable) const;
	virtual BOOL operator== (const SbaIndexDef& _rDef) const;
	BOOL operator !=(const SbaIndexDef& _rDef) const
		{return !operator ==(_rDef);}
};

SV_DECL_IMPL_REF(SbaIndexDef);

DECL_SDBKEYREFCONT_VIRT(SbaIndexMap,SbaIndexDef*);

//==================================================================
// SbaIndexList
//==================================================================
class SbaIndexList : public SbaIndexMap
{
public:
	SbaIndexList(BOOL _bCaseSensitive = FALSE,
				  USHORT _nInitSize = 16,
				  USHORT _nReSize = 16 )
				 :SbaIndexMap(_bCaseSensitive, _nInitSize, _nReSize ){}

	SbaIndexList( USHORT _nBlockSize, USHORT _nInitSize,
				   USHORT _nReSize, BOOL _bCaseSensitive = FALSE)
				  :SbaIndexMap(_nBlockSize,_nInitSize,_nReSize,_bCaseSensitive){}

	virtual SbaIndexDef* Lookup(const String& _rIndexName, const String& _rQualifierName = String()) const;
	virtual SbaIndexList& Copy(const SbaTableDef& _rTable, const SbaIndexList&);
	virtual SbaIndexList& Append(const SbaTableDef& _rTable, const SbaIndexList&);
	virtual BOOL operator ==(const SbaIndexList &) const;
	BOOL operator !=(const SbaIndexList & _rList) const
		{return !operator ==(_rList);}
};

//==================================================================
// SbaTableDef
//==================================================================
class SbaTableDef : public SbaDBDataDef
{
	friend class SbaQueryDef;
	friend class SbaDatabase;

protected:
	SdbTable*	 pTable;				// aktuelle Tabellendefinition
	SbaIndexList aOriginalIndexDefs,
				 aIndexDefs;
	BOOL		 bNotNullAllowed;		// kann die Datenbank NOT NULL Felder

public:
	TYPEINFO();

	// Zugriff auf SdbTable
	SdbTable* GetTable() const {return pTable;}
	UINT16 GetTablePrivileges() const
		{return pTable ? pTable->GetTablePrivileges() : SDB_PR_NONE;}

	// speichern der Tabellendefinition
	virtual BOOL Update();

	// Anlegen einer Tabellensicht
	virtual BOOL Update(const String& rSQL,BOOL bNative);

	// speichern der IndexDefinitionen
	BOOL IsIndexModified() const {return aIndexDefs != aOriginalIndexDefs;}
	virtual BOOL UpdateIndex();
	BOOL UpdateIndex(BOOL bIgnorError);
	void RestoreIndex();

	SbaIndexList&			GetIndexDefs() {return aIndexDefs;}
	const SbaIndexList&		GetOriginalIndexDefs() const {return aOriginalIndexDefs;}
	virtual SbaIndexDef*	CreateIndexDef() const;
	virtual SbaIndexDef*	CreateIndexDef(const SbaIndexDef&) const;
	SbaIndexDef*			CreateIndexDef(const String& rName,const String& rQualifier,BOOL bUnique) const;

	// default Werte fuer Langen und Required
	UINT32 GetDefaultLength(SbaFieldType eFieldType) const;
	BOOL   GetDefaultNull(SbaFieldType eFieldType, SbaNumericSize eSizeType) const;

	BOOL CopyStructure( SbaTableDef* pSourceTableDef );
	BOOL CopyStructure( const SbaColumnList& rSourceList,const SbaDatabase* pSourceDatabase,void* _pColumnsPos=NULL);
	BOOL CopyIndexes(SbaTableDef* pSourceTableDef );

	BOOL ConvertTypeTo( SbaFieldType eType, SbaColumn* pDestColumn);
	BOOL ConvertNumericTypeTo( SbaNumericSize eSize, SbaColumn* pDestColumn);
	BOOL AdjustType( SbaColumn* pSourceColumn, SbaColumn* pDestColumn);

protected:
	SbaTableDef(SbaDatabase* pDB,
				const String& rName,
				BOOL bView,				// flag um eine View anzulegen
				BOOL bNew,
				BOOL bShow);

	virtual	~SbaTableDef();
	virtual BOOL Open();
	virtual BOOL DropImpl();
	virtual BOOL RenameImpl(const String& rNewName);
	virtual BOOL DoRefresh();
	virtual BOOL IsDataUpdateAllowed() const;
	virtual SbaDataObj* CreateDataObjImpl();

private:
	void FillIndexes();
};

SV_DECL_IMPL_REF(SbaTableDef);

//------------------------------------------------------------------
inline String SbaIndexDef::GetFullName() const
{
	String sReturn(aQualifierName);
	if (sReturn.Len() != 0)
		sReturn += '.';
	sReturn += aName;
	return sReturn;
}


#endif


