/*************************************************************************
 *
 *  $RCSfile: dbbrwcbx.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:32:59 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SVX_DBBRWCBX_HXX
#define _SVX_DBBRWCBX_HXX

#ifndef _SVX_DBBROWSE_HXX
#include "dbbrowse.hxx"
#endif

#ifndef _FLOATWIN_HXX //autogen
#include <vcl/floatwin.hxx>
#endif

//==================================================================
class ListBoxCtrl : public ListBox
{
	Link			aClosedHdl;
	BOOL			bClosing,
					bCancel,
					bKeepFocus;		// Combobox behaelt Focus
public:
	ListBoxCtrl(Window* pParent, WinBits nWinStyle = 0):ListBox(pParent,nWinStyle)
															,bCancel(FALSE)
															,bClosing(FALSE)
															,bKeepFocus(FALSE){}

	void Init(){bClosing=FALSE; bCancel=FALSE; bKeepFocus = FALSE;}
	void Close(BOOL bCancel = FALSE, BOOL bKeep = FALSE);
	BOOL IsCanceled() const {return bCancel;}
	BOOL IsClosing() const {return bClosing;}
	BOOL KeepFocus() const {return bKeepFocus;}
	void KeepFocus(BOOL bKeep) {bKeepFocus = bKeep;}

	virtual void KeyInput(const KeyEvent&);
	virtual void LoseFocus();

	void SetCloseHdl( const Link& rLink) {aClosedHdl = rLink;}
	Link GetCloseHdl() const {return aClosedHdl;}
};

//==================================================================
class ListBoxFrame : public FloatingWindow
{
	ListBoxCtrl	aListBox;

public:
	ListBoxFrame(Window* pParent, WinBits nWinStyle = WB_STDFLOATWIN | WB_BORDER)
				:FloatingWindow(pParent,nWinStyle)
				,aListBox(this)
	{aListBox.Show();}

	virtual void Resize();
	virtual long ParentNotify(NotifyEvent& rEvt);

	ListBoxCtrl& GetListBox() const {return ((ListBoxFrame*) this)->aListBox;}
};

//==================================================================
class ButtonCtrl : public ImageButton
{
	Link			aDropDownHdl;

public:
	ButtonCtrl(Window* pParent, WinBits nWinStyle = 0):ImageButton(pParent,nWinStyle){}


	void SetDropDownHdl( const Link& rLink) {aDropDownHdl = rLink;}
	Link GetDropDownHdl() const {return aDropDownHdl;}

protected:
	virtual void MouseButtonDown( const MouseEvent& rMEvt );
};


#endif _SVX_DBBRWCBX_HXX
