/*************************************************************************
 *
 *  $RCSfile: tempfile.c,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: tra $ $Date: 2002/11/14 08:36:49 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
 
#include "system.h"
#include <malloc.h>

#define WIN32_LEAN_AND_MEAN
#include <windows.h>

#ifndef _OSL_FILE_H_
#include <osl/file.h>
#endif

#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif

#ifndef _PATH_HELPER_H_
#include "path_helper.h"
#endif

#include <systools/win32/uwinapi.h>

/* =============================== */
/* Macros and forward declarations */
/* =============================== */

#define ELEMENTS_OF_ARRAY(arr) (sizeof(arr)/sizeof(arr[0]))

oslFileError MapWindowsErrorToOSLError( DWORD dwError );

/* Allocate n number of t's on the stack 
   return a pointer to it in p */
   
#define STACK_ALLOC(p, t, n) __try {(p) = _alloca((n)*sizeof(t));} \
                             __except(EXCEPTION_EXECUTE_HANDLER) {(p) = NULL;}
                             
/* =============================== */
/* osl_gettempDirURL               */
/* =============================== */

/**	Retrieves the file URL of the system's temporary directory path

	@param pustrTempDirURL[out] On success receives the URL of system's
		temporary directory path

	@return osl_File_E_None on success otherwise one of the following errorcodes:<p> 
	osl_File_E_NOENT		No such file or directory not found<br>
*/

oslFileError SAL_CALL osl_getTempDirURL( rtl_uString** pustrTempDir )
{
	WCHAR	szBuffer[MAX_PATH];
	LPWSTR	lpBuffer = szBuffer;
	DWORD	nBufferLength = ELEMENTS_OF_ARRAY(szBuffer) - 1;

	DWORD			nLength;
	oslFileError	error;

	do
	{
		nLength = GetTempPathW( ELEMENTS_OF_ARRAY(szBuffer), lpBuffer );
		if ( nLength > nBufferLength )
		{
			nLength++;
			lpBuffer = alloca( sizeof(WCHAR) * nLength );
			nBufferLength = nLength - 1;
		}
	} while ( nLength > nBufferLength );

	if ( nLength )
	{
		rtl_uString	*ustrTempPath = NULL;

		if ( '\\' == lpBuffer[nLength-1] )
			lpBuffer[nLength-1] = 0;

		rtl_uString_newFromStr( &ustrTempPath, lpBuffer );

		error = osl_getFileURLFromSystemPath( ustrTempPath, pustrTempDir );

		rtl_uString_release( ustrTempPath );
	}
	else
		error = MapWindowsErrorToOSLError( GetLastError() );

	return error;
}

/**************************************
 * osl_setup_temp_directory_impl_
 *************************************/

static oslFileError osl_setup_base_directory_impl_(
    rtl_uString*  pustrDirectoryURL,
    rtl_uString** ppustr_base_dir)
{    
    rtl_uString* dir_url = 0;
    rtl_uString* dir     = 0;        
    oslFileError error   = osl_File_E_None;
    
    if (pustrDirectoryURL)
        rtl_uString_assign(&dir_url, pustrDirectoryURL);         
    else 
	    error = osl_getTempDirURL(&dir_url);                     	    	           				

    if (osl_File_E_None == error)        
    {
       error = _osl_getSystemPathFromFileURL(dir_url, &dir, sal_False);                           
       rtl_uString_release(dir_url);
    }
          
    if (osl_File_E_None == error )
    {
        rtl_uString_assign(ppustr_base_dir, dir);        
        rtl_uString_release(dir);
    }
    
    return error;	
}

/**************************************
 * osl_setup_createTempFile_impl_
 *************************************/
 
static oslFileError osl_setup_createTempFile_impl_(
    rtl_uString*   pustrDirectoryURL,
    oslFileHandle* pHandle,
    rtl_uString**  ppustrTempFileURL,
    rtl_uString**  ppustr_base_dir,
    sal_Bool*      b_delete_on_close)
{
    oslFileError osl_error;
    
    OSL_PRECOND(((0 != pHandle) || (0 != ppustrTempFileURL)), "Invalid parameter!");
        
    if ((0 == pHandle) && (0 == ppustrTempFileURL))    
    {
        osl_error = osl_File_E_INVAL;
    }
    else
    {        
        osl_error = osl_setup_base_directory_impl_(
            pustrDirectoryURL, ppustr_base_dir);
            
        *b_delete_on_close = (0 == ppustrTempFileURL);
    }
       
    return osl_error;
}

/**************************************
 * osl_win32_GetTempFileName_impl_
 *************************************/

static oslFileError osl_win32_GetTempFileName_impl_(
    rtl_uString* base_directory, LPWSTR temp_file_name)
{
    oslFileError osl_error = osl_File_E_None;
       
    if (0 == GetTempFileNameW(
            rtl_uString_getStr(base_directory),
            L"",
            0,
            temp_file_name))
    {    
        osl_error = MapWindowsErrorToOSLError(GetLastError());
    }
       
    return osl_error;
}

/**************************************
 * osl_win32_CreateFile_impl_
 * open the temporary file 
 *************************************/

static sal_Bool osl_win32_CreateFile_impl_(
    LPCWSTR file_name, sal_Bool b_delete_on_close, oslFileHandle* p_handle)
{
    DWORD  flags = FILE_ATTRIBUTE_NORMAL;
    HANDLE hFile;
    
    OSL_ASSERT(p_handle);
    
    if (b_delete_on_close)
        flags |= FILE_FLAG_DELETE_ON_CLOSE;
        
    hFile = CreateFileW(
        file_name,
        GENERIC_READ | GENERIC_WRITE,
        0,  
        NULL, 
        TRUNCATE_EXISTING, 
        flags,
        NULL);
            
    if (IsValidHandle(hFile))        
        *p_handle = (oslFileHandle)hFile;
    
    return IsValidHandle(hFile);
}

/**************************************
 * osl_createTempFile
 *************************************/
 
static oslFileError osl_createTempFile_impl_(
    rtl_uString*   base_directory, 
    LPWSTR         tmp_name,
    sal_Bool       b_delete_on_close,
    oslFileHandle* pHandle,
    rtl_uString**  ppustrTempFileURL)
{
    oslFileError osl_error;
    
    do
    {       
        osl_error = osl_win32_GetTempFileName_impl_(base_directory, tmp_name);
        
        /*  if file could not be opened try again */                                                     
            
        if ((osl_File_E_None != osl_error) || (0 == pHandle) || 
            osl_win32_CreateFile_impl_(tmp_name, b_delete_on_close, pHandle)) 
            break;
                                                                    
    } while(1); // try until success
        
    if ((osl_File_E_None == osl_error) && !b_delete_on_close)        
    {
        rtl_uString* pustr = 0;                
        rtl_uString_newFromStr(&pustr, tmp_name);        
        osl_getFileURLFromSystemPath(pustr, ppustrTempFileURL);
        rtl_uString_release(pustr);
    }
    
    return osl_error;
}

/**************************************
 * osl_createTempFile
 *************************************/

oslFileError SAL_CALL osl_createTempFile(    
    rtl_uString*   pustrDirectoryURL,
    oslFileHandle* pHandle, 
    rtl_uString**  ppustrTempFileURL)
{
    rtl_uString*    base_directory = 0;            
    LPWSTR          tmp_name;        
    sal_Bool        b_delete_on_close;
    oslFileError    osl_error;        
    
    osl_error = osl_setup_createTempFile_impl_(
        pustrDirectoryURL,
        pHandle,
        ppustrTempFileURL,
        &base_directory,
        &b_delete_on_close);
        
    if (osl_File_E_None != osl_error)
        return osl_error;
   
    /* allocate enough space on the stack */
    STACK_ALLOC(tmp_name, WCHAR, (rtl_uString_getLength(base_directory) + MAX_PATH));
    
    if (tmp_name)
    {
        osl_createTempFile_impl_(
            base_directory, 
            tmp_name,
            b_delete_on_close,
            pHandle,
            ppustrTempFileURL);
    }
    else // stack alloc failed
    {
        osl_error = osl_File_E_NOMEM;
    }
            
    if (base_directory)
        rtl_uString_release(base_directory);
                
    return osl_error;
}

