/*************************************************************************
 *
 *  $RCSfile: registry.c,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: hro $ $Date: 2001/12/19 14:30:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <windows.h>
#include <malloc.h>

#define DLL_EXPORT extern

DLL_EXPORT LONG WINAPI RegOpenKeyExW_9x (
  HKEY hKey,         // handle to open key
  LPCWSTR lpSubKey,  // subkey name
  DWORD ulOptions,   // reserved
  REGSAM samDesired, // security access mask
  PHKEY phkResult    // handle to open key 
)
{
	CHAR *pSubKey = NULL;
	LONG ret;

	if (lpSubKey)
	{
		int needed  = WideCharToMultiByte(CP_ACP,0, lpSubKey, -1, NULL, 0, NULL, NULL);
		pSubKey = HeapAlloc(GetProcessHeap(), 0, needed);
		WideCharToMultiByte(CP_ACP,0, lpSubKey, -1, pSubKey, needed, NULL, NULL);
	}

	ret = RegOpenKeyExA (hKey, pSubKey, ulOptions, samDesired, phkResult);

	if (pSubKey)
		HeapFree(GetProcessHeap(), 0, pSubKey);
	return ret;
}

/* ========================================================================= */

DLL_EXPORT LONG WINAPI RegEnumKeyExW_9x (
  HKEY hKey,                  // handle to key to enumerate
  DWORD dwIndex,              // subkey index
  LPWSTR lpName,              // subkey name
  LPDWORD lpcName,            // size of subkey buffer
  LPDWORD lpReserved,         // reserved
  LPWSTR lpClass,             // class string buffer
  LPDWORD lpcClass,           // size of class string buffer
  PFILETIME lpftLastWriteTime // last write time
)
{
	CHAR *pClass = NULL;
	CHAR *pName  = NULL;
	DWORD cClass = 256;
	DWORD cName  = 256;
	LONG  ret;

	if (lpClass)
	{
		pClass = HeapAlloc(GetProcessHeap(), 0, cClass);
		WideCharToMultiByte(CP_ACP,0, lpClass, -1, pClass, cClass, NULL, NULL);
	}

	if (lpName)
		pName = HeapAlloc(GetProcessHeap(), 0, cName * sizeof(WCHAR));

	ret = RegEnumKeyExA(hKey, dwIndex, pName, &cName, lpReserved, pClass, &cClass, lpftLastWriteTime);

	if (ret == ERROR_SUCCESS)
	{
		SetLastError(ret);

		if (cName && (cName = MultiByteToWideChar(CP_ACP, 0, pName, -1, lpName, *lpcName)))
			cName--;
		if (cClass && (cClass = MultiByteToWideChar(CP_ACP, 0, pName, -1, lpName, *lpcClass)))
			cClass--;

		*lpcName  = cName;
		*lpcClass = cClass;

		ret = GetLastError();
	}

	if (pName) 
		HeapFree(GetProcessHeap(), 0, pName);
	if (pClass)	
		HeapFree(GetProcessHeap(), 0, pClass);
	return ret;
}

/* ========================================================================= */

DLL_EXPORT LONG WINAPI RegCreateKeyExW_9x(
  HKEY hKey,                                  // handle to open key
  LPCWSTR lpSubKey,                           // subkey name
  DWORD Reserved,                             // reserved
  LPWSTR lpClass,                             // class string
  DWORD dwOptions,                            // special options
  REGSAM samDesired,                          // desired security access
  LPSECURITY_ATTRIBUTES lpSecurityAttributes, // inheritance
  PHKEY phkResult,                            // key handle 
  LPDWORD lpdwDisposition                     // disposition value buffer
)
{
	CHAR *pSubKey = NULL;
	CHAR *pClass = NULL;
	LONG ret;

	if (lpSubKey)
	{
		int needed  = WideCharToMultiByte(CP_ACP,0, lpSubKey, -1, NULL, 0, NULL, NULL);
		pSubKey = HeapAlloc(GetProcessHeap(), 0, needed);
		WideCharToMultiByte(CP_ACP,0, lpSubKey, -1, pSubKey, needed, NULL, NULL);
	}

	if (lpClass)
	{
		int needed  = WideCharToMultiByte(CP_ACP,0, lpClass, -1, NULL, 0, NULL, NULL);
		pClass = HeapAlloc(GetProcessHeap(), 0, needed);
		WideCharToMultiByte(CP_ACP,0, lpClass, -1, pClass, needed, NULL, NULL);
	}

	ret = RegCreateKeyExA (hKey, pSubKey, Reserved, pClass, dwOptions, samDesired, lpSecurityAttributes, phkResult, lpdwDisposition);

	if (pSubKey)
		HeapFree(GetProcessHeap(), 0, pSubKey);
	if (pClass)
		HeapFree(GetProcessHeap(), 0, pClass);
	return ret;
}

/* ========================================================================= */

DLL_EXPORT LONG WINAPI RegDeleteKeyW_9x(
  HKEY hKey,         // handle to open key
  LPCWSTR lpSubKey   // subkey name
)
{
	CHAR *pSubKey = NULL;
	LONG ret;

	if (lpSubKey)
	{
		int needed  = WideCharToMultiByte(CP_ACP,0, lpSubKey, -1, NULL, 0, NULL, NULL);
		pSubKey = HeapAlloc(GetProcessHeap(), 0, needed);
		WideCharToMultiByte(CP_ACP,0, lpSubKey, -1, pSubKey, needed, NULL, NULL);
	}

	ret = RegDeleteKeyA (hKey, pSubKey);

	if (pSubKey)
		HeapFree(GetProcessHeap(), 0, pSubKey);
	return ret;
}

/* ========================================================================= */

DLL_EXPORT LONG WINAPI RegEnumValueW_9x (
  HKEY hKey,             // handle to key to query
  DWORD dwIndex,         // index of value to query
  LPWSTR lpValueName,    // value buffer
  LPDWORD lpcValueName,  // size of value buffer
  LPDWORD lpReserved,    // reserved
  LPDWORD lpType,        // type buffer
  LPBYTE lpData,         // data buffer
  LPDWORD lpcbData       // size of data buffer
)
{
	CHAR *pValueName = NULL;
	DWORD cValueName = 256;
	LONG ret;

	if (lpValueName)
		pValueName = HeapAlloc(GetProcessHeap(), 0, cValueName);

	ret = RegEnumValueA(hKey, dwIndex, pValueName, &cValueName, lpReserved, lpType, NULL, NULL);

	if (ret == ERROR_SUCCESS)
	{
		if (lpData)
		{
			DWORD *pcbData = lpcbData;
			BYTE  *pData  = NULL;
			DWORD cbData;

			if ((*lpType == REG_SZ) || (*lpType == REG_MULTI_SZ) || (*lpType == REG_EXPAND_SZ ))
			{
				ret = RegQueryValueExA(hKey, pValueName, lpReserved, lpType, NULL, &cbData);

				if (ret != ERROR_SUCCESS)
					goto error;
	
				pData = HeapAlloc(GetProcessHeap(), 0, cbData);
				pcbData = &cbData;
			}
			else
				pData = lpData;

			ret = RegQueryValueExA(hKey, pValueName, lpReserved, lpType, pData, pcbData);

			if (pData != lpData)
			{
				if (ret == ERROR_SUCCESS)
				{
					SetLastError(ret);
					MultiByteToWideChar(CP_ACP, 0, pData, -1, (WCHAR *) lpData, *lpcbData);
					ret = GetLastError();
				}

				HeapFree(GetProcessHeap(), 0, pData);
			}

			if (ret != ERROR_SUCCESS)
				goto error;
		}

		SetLastError(ret);
		if (cValueName && (*lpcValueName = MultiByteToWideChar(CP_ACP, 0, pValueName, -1, lpValueName, *lpcValueName)))
			*lpcValueName += 1;
		ret = GetLastError();
	}

error:
	if (pValueName)
		HeapFree(GetProcessHeap(), 0, pValueName);

	return ret;
}

/* ========================================================================= */

DLL_EXPORT LONG WINAPI RegQueryValueExW_9x (
  HKEY hKey,            // handle to key
  LPCWSTR lpValueName,  // value name
  LPDWORD lpReserved,   // reserved
  LPDWORD lpType,       // type buffer
  LPBYTE lpData,        // data buffer
  LPDWORD lpcbData      // size of data buffer
)
{
	DWORD *pcbData = lpcbData;
	CHAR *pValueName = NULL;
	BYTE *pData  = NULL;
	DWORD cbData;
	LONG  ret;

	if (lpValueName)
	{
		int	needed = WideCharToMultiByte(CP_ACP,0, lpValueName, -1, NULL, 0, NULL, NULL);
		pValueName = HeapAlloc(GetProcessHeap(), 0, needed);
		WideCharToMultiByte(CP_ACP,0, lpValueName, -1, pValueName, needed, NULL, NULL);
	}

	if (lpData)
	{
		ret = RegQueryValueExA(hKey, pValueName, lpReserved, lpType, NULL, &cbData);

		if (ret != ERROR_SUCCESS)
			goto error;

		if ((*lpType == REG_SZ) || (*lpType == REG_MULTI_SZ) || (*lpType == REG_EXPAND_SZ ))
		{
			pData = HeapAlloc(GetProcessHeap(), 0, cbData);
			pcbData = &cbData;
		}
		else
			pData = lpData;
	}

	ret = RegQueryValueExA(hKey, pValueName, lpReserved, lpType, pData, pcbData);

	if (pData != lpData)
	{
		if (ret == ERROR_SUCCESS)
		{
			SetLastError(ret);
			*lpcbData = MultiByteToWideChar(CP_ACP, 0, pData, -1, (WCHAR *) lpData, *lpcbData) * sizeof(WCHAR);
			ret = GetLastError();
		}

		HeapFree(GetProcessHeap(), 0, pData);
	}

error:
	if (pValueName)
		HeapFree(GetProcessHeap(), 0, pValueName);

	return ret;
}

/* ========================================================================= */

DLL_EXPORT LONG WINAPI RegSetValueExW_9x (
  HKEY hKey,           // handle to key
  LPCWSTR lpValueName, // value name
  DWORD Reserved,      // reserved
  DWORD dwType,        // value type
  CONST BYTE *lpData,  // value data
  DWORD cbData         // size of value data
)
{
	CHAR *pValueName = NULL;
	BYTE *pData  = NULL;
	LONG  ret;

	if (lpValueName)
	{
		int	needed = WideCharToMultiByte(CP_ACP,0, lpValueName, -1, NULL, 0, NULL, NULL);
		pValueName = HeapAlloc(GetProcessHeap(), 0, needed);
		WideCharToMultiByte(CP_ACP,0, lpValueName, -1, pValueName, needed, NULL, NULL);
	}

	if ((dwType == REG_SZ) || (dwType == REG_MULTI_SZ) || (dwType == REG_EXPAND_SZ ))
	{
		int	needed = WideCharToMultiByte(CP_ACP,0, (WCHAR *) lpData, -1, NULL, 0, NULL, NULL);
		pData = HeapAlloc(GetProcessHeap(), 0, needed);
		WideCharToMultiByte(CP_ACP,0, (WCHAR *) lpData, -1, pData, needed, NULL, NULL);

		lpData = pData;
		cbData = needed;
	}

	ret = RegSetValueExA(hKey, pValueName, Reserved, dwType, lpData, cbData);

	if (pData)
		HeapFree(GetProcessHeap(), 0, pData);
	if (pValueName)
		HeapFree(GetProcessHeap(), 0, pValueName);

	return ret;
}

/* ========================================================================= */

DLL_EXPORT LONG WINAPI RegDeleteValueW_9x (
  HKEY hKey,            // handle to key
  LPCWSTR lpValueName   // value name
)
{
	CHAR *pValueName = NULL;
	LONG  ret;

	if (lpValueName)
	{
		int	needed = WideCharToMultiByte(CP_ACP,0, lpValueName, -1, NULL, 0, NULL, NULL);
		pValueName = HeapAlloc(GetProcessHeap(), 0, needed);
		WideCharToMultiByte(CP_ACP,0, lpValueName, -1, pValueName, needed, NULL, NULL);
	}

	ret = RegDeleteValueA(hKey, pValueName);

	if (pValueName)
		HeapFree(GetProcessHeap(), 0, pValueName);

	return ret;
}

/* ========================================================================= */

DLL_EXPORT LONG WINAPI RegQueryInfoKeyW_9x (
	HKEY hKey,						// handle to key to query
	LPWSTR lpClassW,				// address of buffer for class string
	LPDWORD lpcbClass,				// address of size of class string buffer
	LPDWORD lpReserved,				// reserved
	LPDWORD lpcSubKeys,				// address of buffer for number of 
									// subkeys
	LPDWORD lpcbMaxSubKeyLen,		// address of buffer for longest subkey 
									// name length
	LPDWORD lpcbMaxClassLen,		// address of buffer for longest class 
									// string length
	LPDWORD lpcValues,				// address of buffer for number of value 
									// entries
	LPDWORD lpcbMaxValueNameLen,	// address of buffer for longest 
									// value name length
	LPDWORD lpcbMaxValueLen,		// address of buffer for longest value 
									// data length
	LPDWORD lpcbSecurityDescriptor,	// address of buffer for security 
									// descriptor length
	PFILETIME lpftLastWriteTime		// address of buffer for last write time
)
{
	LPSTR	lpClassA = NULL;
	LONG	lResult;
	DWORD	cbClass = lpcbClass ? *lpcbClass : 0;

	if ( lpClassW && cbClass )
	{
		lpClassA = (LPSTR)alloca( cbClass * sizeof(CHAR) );
		if ( lpClassA )
			WideCharToMultiByte( CP_ACP, 0, lpClassW, -1, lpClassA, cbClass, NULL, NULL );
	}

	lResult = RegQueryInfoKeyA( 
		hKey, 
		lpClassA, 
		lpcbClass, 
		lpReserved, 
		lpcSubKeys, 
		lpcbMaxSubKeyLen, 
		lpcbMaxClassLen, 
		lpcValues, 
		lpcbMaxValueNameLen, 
		lpcbMaxValueLen, 
		lpcbSecurityDescriptor, 
		lpftLastWriteTime 
		);

	if ( ERROR_SUCCESS == lResult && lpClassA )
		MultiByteToWideChar( CP_ACP, 0, lpClassA, -1, lpClassW, cbClass );

	return lResult;
}
