/*************************************************************************
 *
 *  $RCSfile: AccDataSeries.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: bm $ $Date: 2002/12/05 15:50:27 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _ACCDATASERIES_HXX_
#define _ACCDATASERIES_HXX_

#ifndef _SCH_ACCESSIBLECHARTELEMENT_HXX_
#include "AccessibleChartElement.hxx"
#endif
#ifndef _DEFINES_HXX
#include "defines.hxx"
#endif
// for Rectangle
#ifndef _SV_GEN_HXX
#include <vcl/gen.hxx>
#endif

namespace accessibility
{

class DataSeries : public AccessibleChartElement
{
public:
    DataSeries( AccessibleBase * pParent, sal_uInt16 nIndex );
	virtual ~DataSeries();

    // ________ XAccessibleContext ________
    virtual ::rtl::OUString SAL_CALL getAccessibleName() throw (::com::sun::star::uno::RuntimeException);
    /** does not create the children, just returns the number (for performance
        reasons).  Thus a tool could avoid actually getting too many children by
        first checking this value.
     */
    virtual sal_Int32 SAL_CALL getAccessibleChildCount() throw (::com::sun::star::uno::RuntimeException);

    // ________ XAccessibleComponent ________
    virtual ::com::sun::star::awt::Rectangle SAL_CALL getBounds() throw (::com::sun::star::uno::RuntimeException);

	// ________ XAccessibleExtendedComponent ________
    virtual ::rtl::OUString SAL_CALL getToolTipText() throw (::com::sun::star::uno::RuntimeException);

    // ________ XServiceInfo ________
    virtual ::rtl::OUString SAL_CALL getImplementationName() throw (::com::sun::star::uno::RuntimeException);

protected:
    // AccessibleBase
    virtual bool UpdateChildren();

    // AccessibleChartElement
    virtual SdrObject * GetDrawObject() const;

private:
    const sal_uInt16   m_nIndex;
    sal_uInt16         m_nEntries;

    bool               m_bHasMeanValueLine;
    bool               m_bHasErrorBars;
    bool               m_bHasRegressionCurve;

    /** @return the bounding box of all statistics objects taken together.
     */
    Rectangle GetStatisticsBounds() const;

    /** @param nObjId returns the object corresponding to the object id.  If you
            use CHOBJID_DIAGRAM_ROWGROUP as id, you will get the diagram object
            for pie and ring charts.
     */
    SdrObject * ImplGetDrawObject( UINT16 nObjId ) const;

    /** @descr If there are statistics objects in a chart, the accessible data
            series needs to grow, because usually the statistics objects extend
            beyond the borders of the series object, and in the core those are
            no children of the series.

        @param rOutHasErrorBars is set to true, if the chart contains error bars
            for the corresponding data series (false, otherwise.)

        @param rOutHasMeanValueLine is set to true, if the chart contains mean
            value lines for the corresponding data series (false, otherwise.)

        @param rOutHasRegressionCurve is set to true, if the chart contains a
            regression curve for the corresponding data series (false,
            otherwise.)  For all charttypes except scatter charts, this value is
            false.

        @return true, if one of the parameters has been set to true (false
            otherwise.)
     */
    bool HasStatistics( bool & rOutHasErrorBars,
                        bool & rOutHasMeanValueLine,
                        bool & rOutHasRegressionCurve ) const;
};

}  // namespace accessibility

// _ACCDATASERIES_HXX_
#endif
