/*************************************************************************
 *
 *  $RCSfile: uninsaxi.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:46:30 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SCH_UNINSAXI_HXX
#define _SCH_UNINSAXI_HXX

#include "schundo.hxx"

/*************************************************************************
|*
|* Undo fuer Achsen & Gitter einfuegen
|*
\************************************************************************/

class SchUndoInsertAxis : public SchUndoAction
{
private:
	BOOL bOldShowXAxis;
	BOOL bOldShowXDescr;
	BOOL bOldShowYAxis;
	BOOL bOldShowYDescr;
	BOOL bOldShowZAxis;
	BOOL bOldShowZDescr;
	BOOL bOldShow2YAxis;
	BOOL bOldShow2YDescr;
	BOOL bOldShow2XAxis;
	BOOL bOldShow2XDescr;

	BOOL bNewShowXAxis;
	BOOL bNewShowXDescr;
	BOOL bNewShowYAxis;
	BOOL bNewShowYDescr;
	BOOL bNewShowZAxis;
	BOOL bNewShowZDescr;
	BOOL bNewShow2YAxis;
	BOOL bNewShow2YDescr;
	BOOL bNewShow2XAxis;
	BOOL bNewShow2XDescr;

public:
	TYPEINFO();

	SchUndoInsertAxis( ChartModel& rChDoc,
					   BOOL bOldXAxis, BOOL bOldXDescr,
					   BOOL bOldYAxis, BOOL bOldYDescr,
					   BOOL bOldZAxis, BOOL bOldZDescr,
					   BOOL bOld2YAxis,BOOL bOld2YDescr,
					   BOOL bOld2XAxis,BOOL bOld2XDescr,

					   BOOL bNewXAxis, BOOL bNewXDescr,
					   BOOL bNewYAxis, BOOL bNewYDescr,
					   BOOL bNewZAxis, BOOL bNewZDescr,
					   BOOL bNew2YAxis,BOOL bNew2YDescr,
					   BOOL bNew2XAxis,BOOL bNew2XDescr ) :
			SchUndoAction( rChDoc ),
			bOldShowXAxis(bOldXAxis),
			bOldShowXDescr(bOldXDescr),
			bOldShowYAxis(bOldYAxis),
			bOldShowYDescr(bOldYDescr),
			bOldShowZAxis(bOldZAxis),
			bOldShowZDescr(bOldZDescr),
			bOldShow2YAxis(bOld2YAxis),
			bOldShow2YDescr(bOld2YDescr),
			bOldShow2XAxis(bOld2XAxis),
			bOldShow2XDescr(bOld2XDescr),

			bNewShowXAxis(bNewXAxis),
			bNewShowXDescr(bNewXDescr),
			bNewShowYAxis(bNewYAxis),
			bNewShowYDescr(bNewYDescr),
			bNewShowZAxis(bNewZAxis),
			bNewShowZDescr(bNewZDescr),
			bNewShow2YAxis(bNew2YAxis),
			bNewShow2YDescr(bNew2YDescr),
			bNewShow2XAxis(bNew2XAxis),
			bNewShow2XDescr(bNew2XDescr)
		{}

	virtual void Undo();
	virtual void Redo();

	virtual BOOL CanRepeat( SfxRepeatTarget& rView ) const;
};


// ************************************************************

class SchUndoInsertGrid : public SchUndoAction
{
private:
	BOOL bOldShowXGridMain;
	BOOL bOldShowXGridHelp;
	BOOL bOldShowYGridMain;
	BOOL bOldShowYGridHelp;
	BOOL bOldShowZGridMain;
	BOOL bOldShowZGridHelp;

	BOOL bNewShowXGridMain;
	BOOL bNewShowXGridHelp;
	BOOL bNewShowYGridMain;
	BOOL bNewShowYGridHelp;
	BOOL bNewShowZGridMain;
	BOOL bNewShowZGridHelp;
	
public:
	TYPEINFO();

	SchUndoInsertGrid( ChartModel& rChDoc,
					   BOOL bOldXGridMain, BOOL bOldXGridHelp,
					   BOOL bOldYGridMain, BOOL bOldYGridHelp,
					   BOOL bOldZGridMain, BOOL bOldZGridHelp,

					   BOOL bNewXGridMain, BOOL bNewXGridHelp,
					   BOOL bNewYGridMain, BOOL bNewYGridHelp,
					   BOOL bNewZGridMain, BOOL bNewZGridHelp ) :
			SchUndoAction( rChDoc ),

			bOldShowXGridMain( bOldXGridMain ),
			bOldShowXGridHelp( bOldXGridHelp ),
			bOldShowYGridMain( bOldYGridMain ),
			bOldShowYGridHelp( bOldYGridHelp ),
			bOldShowZGridMain( bOldZGridMain ),
			bOldShowZGridHelp( bOldZGridHelp ),

			bNewShowXGridMain( bNewXGridMain ),
			bNewShowXGridHelp( bNewXGridHelp ),
			bNewShowYGridMain( bNewYGridMain ),
			bNewShowYGridHelp( bNewYGridHelp ),
			bNewShowZGridMain( bNewZGridMain ),
			bNewShowZGridHelp( bNewZGridHelp )
		{}

	virtual void Undo();
	virtual void Redo();

	virtual BOOL CanRepeat( SfxRepeatTarget& rView ) const;
};

#endif	// _SCH_UNINSAXI_HXX

