/*************************************************************************
 *
 *  $RCSfile: sdpptwrp.cxx,v $
 *
 *  $Revision: 1.6.196.1 $
 *
 *  last change: $Author: vg $ $Date: 2004/01/19 16:37:39 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <sfx2/docfile.hxx>
#include <sfx2/docfilt.hxx>
#include <vos/module.hxx>
#include <sfx2/interno.hxx>
#include <svx/msoleexp.hxx>
#include <svx/svxmsbas.hxx>
#include <offmgr/app.hxx>
#include <offmgr/fltrcfg.hxx>

#include "sdpptwrp.hxx"
#include "pptin.hxx"
#include "drawdoc.hxx"

#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#ifndef _MS_FILTERTRACER_HXX
#include <svx/msfiltertracer.hxx>
#endif

// --------------
// - Namespaces -
// --------------

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::task;
using namespace ::com::sun::star::frame;


typedef BOOL ( __LOADONCALLAPI *ExportPPT )( SvStorageRef&,
											 Reference< XModel > &,
											 Reference< XStatusIndicator > &,
											 SvMemoryStream*, sal_uInt32 nCnvrtFlags );

// ---------------
// - SdPPTFilter -
// ---------------

SdPPTFilter::SdPPTFilter( SfxMedium& rMedium, SdDrawDocShell& rDocShell, sal_Bool bShowProgress ) :
	SdFilter( rMedium, rDocShell, bShowProgress ),
	pBas	( NULL )
{
}

// -----------------------------------------------------------------------------

SdPPTFilter::~SdPPTFilter()
{
	delete pBas;	// deleting the compressed basic storage
}

// -----------------------------------------------------------------------------

sal_Bool SdPPTFilter::Import()
{
	sal_Bool	bRet = sal_False;
	SvStorage*	pStorage;

	if( ( pStorage = mrMedium.GetStorage() ) != NULL )
	{
		/* check if there is a dualstorage, then the
		document is propably a PPT95 containing PPT97 */
		SvStorageRef xDualStorage;
		String sDualStorage( RTL_CONSTASCII_USTRINGPARAM( "PP97_DUALSTORAGE" ) );
		if ( pStorage->IsContained( sDualStorage ) )
		{
			xDualStorage = pStorage->OpenStorage( sDualStorage, STREAM_STD_READ );
			pStorage = xDualStorage;
		}
		SvStream* pDocStream = pStorage->OpenStream( String( RTL_CONSTASCII_USTRINGPARAM("PowerPoint Document") ), STREAM_STD_READ );
		if( pDocStream )
		{
			pDocStream->SetVersion( pStorage->GetVersion() );
			pDocStream->SetKey( pStorage->GetKey() );

			String aTraceConfigPath( RTL_CONSTASCII_USTRINGPARAM( "Office.Tracing/Import/PowerPoint" ) );
			Sequence< PropertyValue > aConfigData( 1 );
			PropertyValue aPropValue;
			aPropValue.Value <<= rtl::OUString( mrMedium.GetURLObject().GetMainURL( INetURLObject::NO_DECODE ) );
			aPropValue.Name = rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "DocumentURL" ) );
			aConfigData[ 0 ] = aPropValue;
			MSFilterTracer aTracer( aTraceConfigPath, &aConfigData );
			aTracer.StartTracing();
			SdPPTImport* pImport = new SdPPTImport( &mrDocument, *pDocStream, *pStorage, mrMedium, &aTracer );
			if ( !( bRet = pImport->Import() ) )
				mrMedium.SetError( SVSTREAM_WRONGVERSION );
			if ( aTracer.IsEnabled() )
			{
				sal_Int32 nCount = 0;
				sal_Int32 nStatSlidePages, nStatMasterPages, nStatShapes, nStatTextShapes, nStatCharacters, nStatWordArts,
							nStat3DObjects, nStatObjectEffects, nStatSlideTransitionEffects, nStatOleObjects;

				Any aDefault, aStatValue;
				const ::rtl::OUString sstatistics					( RTL_CONSTASCII_USTRINGPARAM( "statistics" ) );
				const ::rtl::OUString sStatSlidePages				( RTL_CONSTASCII_USTRINGPARAM( "StatSlidePages" ) );
				const ::rtl::OUString sStatMasterPages				( RTL_CONSTASCII_USTRINGPARAM( "StatMasterPages" ) );
				const ::rtl::OUString sStatShapes					( RTL_CONSTASCII_USTRINGPARAM( "StatShapes" ) );
				const ::rtl::OUString sStatTextShapes				( RTL_CONSTASCII_USTRINGPARAM( "StatTextShapes" ) );
				const ::rtl::OUString sStatCharacters				( RTL_CONSTASCII_USTRINGPARAM( "StatCharacters" ) );
				const ::rtl::OUString sStatWordArts					( RTL_CONSTASCII_USTRINGPARAM( "StatWordArts" ) );
				const ::rtl::OUString sStat3DObjects				( RTL_CONSTASCII_USTRINGPARAM( "Stat3DObjects" ) );
				const ::rtl::OUString sStatObjectEffects			( RTL_CONSTASCII_USTRINGPARAM( "StatObjectEffects" ) );
				const ::rtl::OUString sStatSlideTransitionEffects	( RTL_CONSTASCII_USTRINGPARAM( "StatSlideTransitionEffects" ) );
				const ::rtl::OUString sStatOleObjects				( RTL_CONSTASCII_USTRINGPARAM( "StatOleObjects" ) );
				aDefault <<= nCount;
				aStatValue = aTracer.GetProperty( sStatSlidePages, &aDefault );
				aStatValue >>= nStatSlidePages;
				aStatValue = aTracer.GetProperty( sStatMasterPages, &aDefault );
				aStatValue >>= nStatMasterPages;
				aStatValue = aTracer.GetProperty( sStatShapes, &aDefault );
				aStatValue >>= nStatShapes;
				aStatValue = aTracer.GetProperty( sStatTextShapes, &aDefault );
				aStatValue >>= nStatTextShapes;
				aStatValue = aTracer.GetProperty( sStatCharacters, &aDefault );
				aStatValue >>= nStatCharacters;
				aStatValue = aTracer.GetProperty( sStatWordArts, &aDefault );
				aStatValue >>= nStatWordArts;
				aStatValue = aTracer.GetProperty( sStat3DObjects, &aDefault );
				aStatValue >>= nStat3DObjects;
				aStatValue = aTracer.GetProperty( sStatObjectEffects, &aDefault );
				aStatValue >>= nStatObjectEffects;
				aStatValue = aTracer.GetProperty( sStatSlideTransitionEffects, &aDefault );
				aStatValue >>= nStatSlideTransitionEffects;
				aStatValue = aTracer.GetProperty( sStatOleObjects, &aDefault );
				aStatValue >>= nStatOleObjects;

				const ::rtl::OUString sSlidePages				( RTL_CONSTASCII_USTRINGPARAM( "SlidePages" ) );
				const ::rtl::OUString sMasterPages				( RTL_CONSTASCII_USTRINGPARAM( "MasterPages" ) );
				const ::rtl::OUString sShapes					( RTL_CONSTASCII_USTRINGPARAM( "Shapes" ) );
				const ::rtl::OUString sTextShapes				( RTL_CONSTASCII_USTRINGPARAM( "TextShapes" ) );
				const ::rtl::OUString sCharacters				( RTL_CONSTASCII_USTRINGPARAM( "Characters" ) );
				const ::rtl::OUString sWordArts					( RTL_CONSTASCII_USTRINGPARAM( "WordArts" ) );
				const ::rtl::OUString s3DObjects				( RTL_CONSTASCII_USTRINGPARAM( "Objects3D" ) );
				const ::rtl::OUString sObjectEffects			( RTL_CONSTASCII_USTRINGPARAM( "ObjectEffects" ) );
				const ::rtl::OUString sSlideTransitionEffects	( RTL_CONSTASCII_USTRINGPARAM( "SlideTransitionEffects" ) );
				const ::rtl::OUString sOleObjects				( RTL_CONSTASCII_USTRINGPARAM( "OleObjects" ) );
				aTracer.AddAttribute( sSlidePages, rtl::OUString::valueOf( nStatSlidePages ) );
				aTracer.AddAttribute( sMasterPages, rtl::OUString::valueOf( nStatMasterPages ) );
				aTracer.AddAttribute( sShapes, rtl::OUString::valueOf( nStatShapes ) );
				aTracer.AddAttribute( sTextShapes, rtl::OUString::valueOf( nStatTextShapes ) );
				aTracer.AddAttribute( sCharacters, rtl::OUString::valueOf( nStatCharacters ) );
				aTracer.AddAttribute( sWordArts, rtl::OUString::valueOf( nStatWordArts ) );
				aTracer.AddAttribute( s3DObjects, rtl::OUString::valueOf( nStat3DObjects ) );
				aTracer.AddAttribute( sObjectEffects, rtl::OUString::valueOf( nStatObjectEffects ) );
				aTracer.AddAttribute( sSlideTransitionEffects, rtl::OUString::valueOf( nStatSlideTransitionEffects ) );
				aTracer.AddAttribute( sOleObjects, rtl::OUString::valueOf( nStatOleObjects ) );
				aTracer.Trace( sstatistics, rtl::OUString() );
				aTracer.RemoveAttribute( sSlidePages );
				aTracer.RemoveAttribute( sMasterPages );
				aTracer.RemoveAttribute( sShapes );
				aTracer.RemoveAttribute( sTextShapes );
				aTracer.RemoveAttribute( sCharacters );
				aTracer.RemoveAttribute( sWordArts );
				aTracer.RemoveAttribute( s3DObjects );
				aTracer.RemoveAttribute( sObjectEffects );
				aTracer.RemoveAttribute( sSlideTransitionEffects );
				aTracer.RemoveAttribute( sOleObjects );	
			}
			aTracer.EndTracing();
			delete pImport;
			delete pDocStream;
		}
	}

	return bRet;
}

// -----------------------------------------------------------------------------

sal_Bool SdPPTFilter::Export()
{
	::vos::OModule* pLibrary = OpenLibrary( mrMedium.GetFilter()->GetUserData() );
	sal_Bool		bRet = sal_False;

	if( pLibrary )
	{
		if( mxModel.is() )
		{
			SvStorageRef	xStorRef;
			ExportPPT		PPTExport = ( ExportPPT ) pLibrary->getSymbol( ::rtl::OUString::createFromAscii("ExportPPT") );

			/* !!!
			if ( pViewShell && pViewShell->GetView() )
				pViewShell->GetView()->EndTextEdit();
			*/
			if( PPTExport && ( xStorRef = mrMedium.GetOutputStorage() ).Is() )
			{
				sal_uInt32			nCnvrtFlags = 0;
				OfficeApplication*	pApplication = OFF_APP();

				if( pApplication )
				{
					OfaFilterOptions* pFilterOptions = pApplication->GetFilterOptions();
					if ( pFilterOptions )
					{
						if ( pFilterOptions->IsMath2MathType() )
							nCnvrtFlags |= OLE_STARMATH_2_MATHTYPE;
						if ( pFilterOptions->IsWriter2WinWord() )
							nCnvrtFlags |= OLE_STARWRITER_2_WINWORD;
						if ( pFilterOptions->IsCalc2Excel() )
							nCnvrtFlags |= OLE_STARCALC_2_EXCEL;
						if ( pFilterOptions->IsImpress2PowerPoint() )
							nCnvrtFlags |= OLE_STARIMPRESS_2_POWERPOINT;
					}
				}
				mrDocument.SetSwapGraphicsMode( SDR_SWAPGRAPHICSMODE_TEMP );

				if( mbShowProgress )
					CreateStatusIndicator();

				bRet = PPTExport( xStorRef, mxModel, mxStatusIndicator, pBas, nCnvrtFlags );
			}
		}
		delete pLibrary;
	}
	return bRet;
}

void SdPPTFilter::PreSaveBasic()
{
	OfficeApplication*	pApplication = OFF_APP();
	if( pApplication )
	{
		OfaFilterOptions* pFilterOptions = pApplication->GetFilterOptions();
		if( pFilterOptions && pFilterOptions->IsLoadPPointBasicStorage() )
		{	
			SvStorageRef xDest( new SvStorage( new SvMemoryStream(), TRUE ) );
			SvxImportMSVBasic aMSVBas( (SfxObjectShell&) mrDocShell, *xDest, FALSE, FALSE );
			aMSVBas.SaveOrDelMSVBAStorage( TRUE, String( RTL_CONSTASCII_USTRINGPARAM("_MS_VBA_Overhead") ) );

			SvStorageRef xOverhead = xDest->OpenStorage( String( RTL_CONSTASCII_USTRINGPARAM("_MS_VBA_Overhead") ) );
			if ( xOverhead.Is() && ( xOverhead->GetError() == SVSTREAM_OK ) )
			{
				SvStorageRef xOverhead2 = xOverhead->OpenStorage( String( RTL_CONSTASCII_USTRINGPARAM("_MS_VBA_Overhead") ) );
				if ( xOverhead2.Is() && ( xOverhead2->GetError() == SVSTREAM_OK ) )
				{
					SvStorageStreamRef xTemp = xOverhead2->OpenStream( String( RTL_CONSTASCII_USTRINGPARAM("_MS_VBA_Overhead2") ) );
					if ( xTemp.Is() && ( xTemp->GetError() == SVSTREAM_OK ) )
					{
						UINT32 nLen = xTemp->GetSize();
						if ( nLen )
						{
							char* pTemp = new char[ nLen ];
							if ( pTemp )
							{
								xTemp->Seek( STREAM_SEEK_TO_BEGIN );
								xTemp->Read( pTemp, nLen );
								pBas = new SvMemoryStream( pTemp, nLen, STREAM_READ );
								pBas->ObjectOwnsMemory( TRUE );
							}
						}
					}
				}
			}
		}
	}

}
