/*************************************************************************
 *
 *  $RCSfile: fuslshw3.cxx,v $
 *
 *  $Revision: 1.20 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 10:57:52 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#define FUSLIDESHOW_INTERN
#include "fuslshow.hxx"

#include <vos/process.hxx>
#include <tools/urlobj.hxx>
#include <svtools/urihelper.hxx>
#include <unotools/localfilehelper.hxx>
#include <svx/xoutx.hxx>
#include <svx/outliner.hxx>
#include <svx/xfillit.hxx>
#include <svx/xfltrit.hxx>
#include <svx/xlntrit.hxx>
#ifndef _SV_METRIC_HXX //autogen
#include <vcl/metric.hxx>
#endif
#ifndef _SVDITER_HXX //autogen
#include <svx/svditer.hxx>
#endif
#ifndef _SVDOATTR_HXX //autogen
#include <svx/svdoattr.hxx>
#endif
#ifndef _SVDPAGE_HXX //autogen
#include <svx/svdpage.hxx>
#endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _SFXAPP_HXX //autogen
#include <sfx2/app.hxx>
#endif
#ifndef _SFXDOCFILE_HXX //autogen
#include <sfx2/docfile.hxx>
#endif
#ifndef _SB_SBSTAR_HXX //autogen
#include <basic/sbstar.hxx>
#endif
#ifndef _SVDOGRAF_HXX //autogen
#include <svx/svdograf.hxx>
#endif
#ifndef _SV_GRAPH_HXX //autogen
#include <vcl/graph.hxx>
#endif
#ifndef _SVDORECT_HXX //autogen
#include <svx/svdorect.hxx>
#endif
#ifndef _SVDOTEXT_HXX //autogen
#include <svx/svdotext.hxx>
#endif
#ifndef _SVDOATTR_HXX //autogen
#include <svx/svdoattr.hxx>
#endif
#ifndef _SVDPAGE_HXX //autogen
#include <svx/svdpage.hxx>
#endif
#ifndef _E3D_POLYSC3D_HXX //autogen
#include <svx/polysc3d.hxx>
#endif
#ifndef _SVDOGRP_HXX //autogen
#include <svx/svdogrp.hxx>
#endif

#include "sdview.hxx"
#include "drawdoc.hxx"
#include "sdpage.hxx"
#include "app.hrc"
#include "anminfo.hxx"
#include "viewshel.hxx"
#include "docshell.hxx"
#include "cusshow.hxx"

using namespace ::com::sun::star;

/*************************************************************************
|*
|* Hat das Objekt eine Aktion?
|*
\************************************************************************/

BOOL FuSlideShow::HasAction(SdrObject* pObject)
{
	BOOL				bResult = FALSE;
	SdAnimationInfo*	pInfo = pDoc->GetAnimationInfo(pObject);

	if (pInfo)
	{
		if (pInfo->eClickAction == presentation::ClickAction_DOCUMENT)
            bResult = TRUE;
		else if( pInfo->eClickAction == presentation::ClickAction_BOOKMARK )
		{
			bResult = TRUE;

			// keine Spruenge auf 'unerlaubte' Seiten erlauben
			for( USHORT nPage = 0, nPageCount = pDoc->GetPageCount();
				nPage < nPageCount; nPage++ )
			{
				SdPage* pPage = (SdPage*) pDoc->GetPage( nPage );

				if( pPage->GetPageKind() != PK_STANDARD && pPage->GetName() == pInfo->aBookmark )
				{
					bResult = FALSE;
					break;
				}
			}

			if( bResult )
			{
				// Masterpages testen => keine Spruenge erlaubt
				for( USHORT nMasterPage = 0, nMasterPageCount = pDoc->GetMasterPageCount();
					 nMasterPage < nMasterPageCount; nMasterPage++ )
				{
					if( ( (SdPage*) pDoc->GetMasterPage( nMasterPage ) )->GetName() == pInfo->aBookmark )
					{
						bResult = FALSE;
						break;
					}
				}
			}
		}
		else if (pInfo->eClickAction != presentation::ClickAction_NONE)
			bResult = TRUE;
	}

	return bResult;
}

/*************************************************************************
|*
|* Liegt die Position (in Weltkoordinaten) ueber einem Objekt?
|*
\************************************************************************/

SdrObject* FuSlideShow::OverObject(const Point& rPos)
{
	SdrObject* pResult = NULL;

	// Position umrechnen vom ShowWindow auf Seitenkoordinaten
	Point aPosOnPage = rPos - aPageOrigin;
	SdPage* pPage = pDoc->GetSdPage(0, PK_STANDARD);
	aPosOnPage.X() += pPage->GetLftBorder();
	aPosOnPage.Y() += pPage->GetUppBorder();

	SdrPageView* pDummy = NULL;
	pView->PickObj(aPosOnPage, pResult, pDummy, SDRSEARCH_ALSOONMASTER);

	// wenn die DrawingEngine ihr OK gibt, muss noch der Sichtbarkeitsstatus
	// in der Show getestet werden
	if (pResult)
	{
		SdAnimationInfo* pInfo = pDoc->GetAnimationInfo(pResult);

		if (!pInfo && (pResult->ISA(SdrObjGroup) || pResult->ISA(E3dPolyScene)))
		{
			// In die Gruppe hineinschauen
			if ( pView->PickObj(aPosOnPage, pResult, pDummy, SDRSEARCH_ALSOONMASTER | SDRSEARCH_DEEP) )
				pInfo = pDoc->GetAnimationInfo(pResult);
		}

		if (pInfo && !pInfo->bIsShown)
			pResult = NULL;
	}

	return pResult;
}

/*************************************************************************
|*
|* Aktion eines Objekts ausfuehren
|*
\************************************************************************/

BOOL FuSlideShow::PerformAction(SdrObject* pActionObject)
{
	SdAnimationInfo*	pInfo = pDoc->GetAnimationInfo(pActionObject);
	BOOL				bResult = TRUE;

	switch( pInfo->eClickAction )
	{
		case presentation::ClickAction_PREVPAGE:
			JumpToPage( aAnimPageList.CalcNextPageNum( FALSE ) );
		break;

		case presentation::ClickAction_NEXTPAGE:
			JumpToPage( aAnimPageList.CalcNextPageNum( TRUE ) );
		break;

		case presentation::ClickAction_FIRSTPAGE:
			JumpToPage( aAnimPageList.GetFirstPageNum() );
		break;

		case presentation::ClickAction_LASTPAGE:
			JumpToPage( aAnimPageList.GetLastPageNum() );
		break;

		case presentation::ClickAction_SOUND:
			StartSound(pInfo->aBookmark);
		break;

		case presentation::ClickAction_BOOKMARK:
		{
			SfxStringItem aItem( SID_NAVIGATOR_OBJECT, pInfo->aBookmark );

			( pViewShell ? pViewShell->GetViewFrame() : SfxViewFrame::Current() )->GetDispatcher()->
              Execute(SID_NAVIGATOR_OBJECT, SFX_CALLMODE_SLOT | SFX_CALLMODE_RECORD, &aItem, 0L);
		}
		break;

        case presentation::ClickAction_DOCUMENT:
        {
            SfxStringItem   aStrItem( SID_FILE_NAME, pInfo->aBookmark );
            SfxStringItem   aReferer( SID_REFERER, pDocSh->GetMedium()->GetName() );
            SfxBoolItem     aBrowseItem( SID_BROWSE, TRUE );

            ( pViewShell ? pViewShell->GetViewFrame() : SfxViewFrame::Current() )->GetDispatcher()->
              Execute(SID_OPENDOC, SFX_CALLMODE_SLOT | SFX_CALLMODE_RECORD, &aStrItem, &aBrowseItem, &aReferer, 0L );
        }
        break;

		case presentation::ClickAction_INVISIBLE:
		case presentation::ClickAction_VANISH:
			HideOrVanishObject( pActionObject, presentation::ClickAction_INVISIBLE == pInfo->eClickAction );
		break;

		case presentation::ClickAction_VERB:
			DoVerb( pActionObject, pDoc->GetAnimationInfo(pActionObject)->nVerb );
		break;

		case presentation::ClickAction_PROGRAM:
		{
		    INetURLObject aURL( ::URIHelper::SmartRelToAbs( pInfo->aBookmark, FALSE, INetURLObject::WAS_ENCODED, INetURLObject::DECODE_UNAMBIGUOUS ) );

			if( INET_PROT_FILE == aURL.GetProtocol() )
		    {
				::vos::OProcess                 aApp( aURL.GetMainURL( INetURLObject::NO_DECODE ) );
				::vos::OArgumentList	        aParameters;
				::vos::OProcess::TProcessError  eError = aApp.execute( (::vos::OProcess::TProcessOption) ( ::vos::OProcess::TOption_SearchPath |
																										   ::vos::OProcess::TOption_Detached ),
																	   aParameters );
			}
		}
		break;

		case presentation::ClickAction_MACRO:
		{
			// Makro ausfuehren
			String aMacro = pInfo->aBookmark;

			// aMacro liegt in folgender Form vor:
			// "Macroname.Modulname.Libname.Dokumentname" oder
			// "Macroname.Modulname.Libname.Applikationsname"
			String aMacroName = aMacro.GetToken(0, sal_Unicode('.'));
			String aModulName = aMacro.GetToken(1, sal_Unicode('.'));
			String aLibName   = aMacro.GetToken(2, sal_Unicode('.'));
			String aDocName   = aMacro.GetToken(3, sal_Unicode('.'));

			// Z.Z. kann die Call-Methode nur
			// Modulname+Macroname aufloesen
			String aExecMacro(aModulName);
			aExecMacro.Append( sal_Unicode('.') );
			aExecMacro.Append( aMacroName );
			pDocSh->GetBasic()->Call(aExecMacro);
		}
		break;

		case presentation::ClickAction_STOPPRESENTATION:
			JumpToPage( PAGE_NO_END );
		break;
	}

	return bResult;
}

/*************************************************************************
|*
|* Animation eines Objekts ausfuehren
|*
\************************************************************************/

BOOL FuSlideShow::AnimateNamedObject(const String& rObjectName)
{
	SdrObject*	pObject = pDoc->GetObj(rObjectName);
	BOOL		bResult = FALSE;

	if ( pObject )
	{
		SdrPage* pPage = pObject->GetPage();
		if ( pPage->IsMasterPage() &&
			 pObject->GetObjInventor() == SdrInventor &&
			 (pObject->GetObjIdentifier() == OBJ_TITLETEXT ||
			  pObject->GetObjIdentifier() == OBJ_OUTLINETEXT))
			return bResult;

		// ist es ein Animationsobjekt?
		SdAnimationInfo* pInfo = pDoc->GetAnimationInfo( pObject );

		if ( pInfo && ( pInfo->eEffect != presentation::AnimationEffect_NONE ) )
		{
			// anstehende Gliederungsanimationen und Abblendungen werden bei
			// Animation eines Objektes verworfen
			pCurAnmList->Remove( pLayoutText );
			pDimObject = pHideObject = NULL;

			// das Objekt in der Liste nach vorn schieben und Animation starten
			pCurAnmList->Remove( pObject );
			pCurAnmList->Insert( pObject, (ULONG) 0 );
			pInfo->bShow = TRUE;
			bResult = AnimateObject();
			pInfo->bIsShown = TRUE;
		}

		if ( AffectsOwnPage( pObject ) )
			nVisibleAffectingObjects++;
	}
	return bResult;
}

/*************************************************************************
|*
|* Sprung zu einem Bookmark
|*
\************************************************************************/

void FuSlideShow::JumpToBookmark(const String& rBookmark)
{
	// Ist das Bookmark eine Seite?
	BOOL        bIsMasterPage;
    USHORT	    nPgNum = pDoc->GetPageByName( rBookmark, bIsMasterPage );
	SdrObject*  pObj   = NULL;

	if( nPgNum == SDRPAGE_NOTFOUND )
	{
		// Ist das Bookmark ein Objekt?
		pObj = pDoc->GetObj( rBookmark );

		if( pObj )
			nPgNum = pObj->GetPage()->GetPageNum();
	}

	if( nPgNum != SDRPAGE_NOTFOUND )
	{
		nPgNum = ( nPgNum - 1 ) / 2;

//		if( aAnimPageList.IsPageNumIncluded( nPgNum ) )
			JumpToPage( nPgNum );

		// wenn es ein Objekt ist: im Show-Modus ggfs. Objektanimation
		// ausfuehren, im Zeichenmodus das Objekt selektieren, sofern es
		// kein Animationsobjekt (d.h. noch unsichtbar) ist
		if( pObj )
		{
			if( bNativeMode )
				AnimateNamedObject(rBookmark);
			else
			{
				if( pCurAnmList->GetPos(pObj) == LIST_ENTRY_NOTFOUND )
				{
					pView->UnmarkAll();
					pView->MarkObj(pObj, pView->GetPageViewPvNum(0), FALSE);
				}
			}
		}
	}
}

/*************************************************************************
|*
|* alle SlowObjRecords loeschen
|*
\************************************************************************/

void FuSlideShow::ClearSlowObjList()
{
	if ( pSlowObjList )
	{
		for( void* pEntry = pSlowObjList->First(); pEntry; pEntry = pSlowObjList->Next() )
			delete (SdSlowObjRecord*) pEntry;

		pSlowObjList->Clear();
	}
}

/*************************************************************************
|*
|* SlowObjRecord finden, NULL wenn's keinen gibt
|*
\************************************************************************/

SdSlowObjRecord* FuSlideShow::GetSlowObjRecord( SdrAttrObj* pObject )
{
	SdSlowObjRecord* pResult = NULL;

	if ( pSlowObjList )
	{
		for( void* pEntry = pSlowObjList->First(); pEntry; pEntry = pSlowObjList->Next() )
		{
			if ( ( (SdSlowObjRecord*) pEntry )->pObject == pObject )
			{
				pResult = (SdSlowObjRecord*) pEntry;
				break;
			}
		}
	}

	return pResult;
}

/*************************************************************************
|*
|* Ist ein Objekt zu langsam?
|*
\************************************************************************/

BOOL FuSlideShow::IsSlowObj( SdrAttrObj* pObject ) const
{
	BOOL bResult = FALSE;

	if( !IsAlphaObj( pObject ) )
	{
		// Attributierung untersuchen
		const SfxItemSet& rSet = pObject->GetItemSet();
		// Fuellstil untersuchen
		const XFillStyleItem& rFillStyle = (const XFillStyleItem&) rSet.Get( XATTR_FILLSTYLE );

		// Farbverlaufe sind zu langsam
		if( rFillStyle.GetValue() == XFILL_GRADIENT )
			bResult = TRUE;

		// Metafile-Objekte koennen sehr komplexe Grafiken enthalten (sind also
		// potentiell langsam) und kommen ausserdem an der falschen Stelle raus,
		// wenn sie auf einem anderen MapMode-Origin abgespielt werden
		if( !bResult && pObject->ISA( SdrGrafObj) && ( (SdrGrafObj*) pObject )->GetGraphicType() == GRAPHIC_GDIMETAFILE )
			bResult = TRUE;

		// abgeblendete Objekte mit Text sind zu langsam, um waehrend eines
		// Effektes gezeichnet zu werden
		if (!bResult)
		{
			SdAnimationInfo* pInfo = pDoc->GetAnimationInfo(pObject);

			if ( pInfo && pInfo->bDimmed && pObject->GetOutlinerParaObject() )
				bResult = TRUE;
		}
	}

	return bResult;
}

/*************************************************************************
|*
|* Is object a alpha object
|*
\************************************************************************/

BOOL FuSlideShow::IsAlphaObj( SdrAttrObj* pObject ) const
{
	BOOL bRet = FALSE;

	if( pObject->ISA( SdrObjGroup ) )
	{
		SdrObjListIter aIter( *pObject->GetSubList(), IM_DEEPWITHGROUPS );
		
		for( SdrObject*	pO = aIter.Next(); pO && !bRet; pO = aIter.Next() )
		{
			if( !pO->ISA( SdrObjGroup ) )
			{
				const SfxItemSet& rSet = pO->GetItemSet();

				if( ( ( (const XFillTransparenceItem&) rSet.Get( XATTR_FILLTRANSPARENCE ) ).GetValue() ||
					  ( (const XLineTransparenceItem&) rSet.Get( XATTR_LINETRANSPARENCE ) ).GetValue()	) ||
					( ( rSet.GetItemState( XATTR_FILLFLOATTRANSPARENCE ) == SFX_ITEM_SET ) &&
					  ( (const XFillFloatTransparenceItem&) rSet.Get( XATTR_FILLFLOATTRANSPARENCE ) ).IsEnabled() ) )
				{
					bRet = TRUE;
				}
				else if( pO->ISA( SdrGrafObj ) )
				{
					SdrGrafObj* pGrafObj = (SdrGrafObj*) pO;

					if( ( pGrafObj->GetGraphicType() == GRAPHIC_BITMAP && pGrafObj->GetGraphic().GetBitmapEx().IsAlpha() ) ||
						( (const SdrGrafTransparenceItem&) rSet.Get( SDRATTR_GRAFTRANSPARENCE ) ).GetValue() )
					{
						bRet = TRUE;
					}
				}
			}
		}
	}
	else
	{
		const SfxItemSet& rSet = pObject->GetItemSet();

		if( ( ( (const XFillTransparenceItem&) rSet.Get( XATTR_FILLTRANSPARENCE ) ).GetValue() ||
			  ( (const XLineTransparenceItem&) rSet.Get( XATTR_LINETRANSPARENCE ) ).GetValue()	) ||
			( ( rSet.GetItemState( XATTR_FILLFLOATTRANSPARENCE ) == SFX_ITEM_SET ) &&
			  ( (const XFillFloatTransparenceItem&) rSet.Get( XATTR_FILLFLOATTRANSPARENCE ) ).IsEnabled() ) )
		{
			bRet = TRUE;
		}
		else if( pObject->ISA( SdrGrafObj ) )
		{
			SdrGrafObj* pGrafObj = (SdrGrafObj*) pObject;

			if( ( pGrafObj->GetGraphicType() == GRAPHIC_BITMAP && pGrafObj->GetGraphic().GetBitmapEx().IsAlpha() ) ||
				( (const SdrGrafTransparenceItem&) rSet.Get( SDRATTR_GRAFTRANSPARENCE ) ).GetValue() )
			{
				bRet = TRUE;
			}
		}
	}

	return bRet;
}

/*************************************************************************
|*
|* Einen SlowObjRecord fuer ein Zeichenobjekt erstellen und in die Liste
|* stellen.
|*
\************************************************************************/

BOOL FuSlideShow::CreateSlowObjRecord( SdrAttrObj* pObject )
{
	Rectangle	aObjectRect( pShowWindow->PixelToLogic( pShowWindow->LogicToPixel( pObject->GetBoundRect() ) ) );
	Size		aPixelSize( pShowWindow->PixelToLogic( Size( 1, 1 ) ) );

	aObjectRect.Right() += aPixelSize.Width();
	aObjectRect.Bottom() += aPixelSize.Height();

	SdSlowObjRecord*	pRec = new SdSlowObjRecord( pObject, aObjectRect.TopLeft() );
	Point				aNegObjectPos( - pRec->aPos.X(), -pRec->aPos.Y() );
	VirtualDevice*		pDev = new VirtualDevice( *pShowWindow );
	MapMode				aMapMode( pShowWindow->GetMapMode() );
	Color				aBackground( COL_WHITE );
	SdAnimationInfo*	pInfo = pDoc->GetAnimationInfo(pObject);
	
	aMapMode.SetOrigin( aNegObjectPos );
	pDev->SetMapMode(aMapMode);
	pAnmVDev->SetBackground( aBackground );
	BOOL bOk = pDev->SetOutputSize( aObjectRect.GetSize() );

	ExtOutputDevice aOut( pDev );
	SdrPaintInfoRec aPaintInfoRec;
	SetPaintModes( (SdrView*) pView, NULL, &aOut, &aPaintInfoRec );
	pDev->SetDrawMode( pShowWindow->GetDrawMode() );

	if( pInfo && pInfo->bDimmed )
	{
		if( pObject == pLayoutText )
			PaintLayoutClone( pDev );
		else
			PaintDimmedObject( pObject, pDev, pInfo->aDimColor, TRUE );
	}
	else
	{
		// falls es sich um ein animiertes Textobjekt handelt,
		// das nicht animiert dargestellt werden soll, muessen
		// wir ein nicht animiertes Clone-Objekt im Mtf aufzeichnen
		if( !bAnimationAllowed && OBJIS_TEXTANIM( pObject ) )
		{
			// nicht animierten Clone zeichnen
			SfxItemSet	aTempAttr( pDoc->GetPool(), SDRATTR_TEXT_ANIKIND, SDRATTR_TEXT_ANIKIND );
			SdrObject*	pClone = pObject->Clone();

			aTempAttr.Set(pClone->GetItemSet());

			aTempAttr.Put( SdrTextAniKindItem() );

			pClone->SetItemSet(aTempAttr);
			
			pClone->Paint( aOut, aPaintInfoRec );
			delete pClone;
		}
		else
			pObject->Paint( aOut, aPaintInfoRec );
	}

	Bitmap aObjectBitmap( pDev->GetBitmap(pRec->aPos, aObjectRect.GetSize() ) );

	// Maske erzeugen
	PaintDimmedObject( pObject, pDev, Color( COL_BLACK ), TRUE );
	pDev->SetDrawMode( DRAWMODE_DEFAULT );
	Bitmap aMaskBitmap( pDev->GetBitmap( pRec->aPos, aObjectRect.GetSize() ) );

	if( !!aObjectBitmap && !!aMaskBitmap )
	{
		if( !pSlowObjList )
			pSlowObjList = new List;

		if( pSlowObjList->Count() >= 64 )
		{
			aObjectBitmap.ReleaseAccess( aObjectBitmap.AcquireReadAccess() );
			aMaskBitmap.ReleaseAccess( aMaskBitmap.AcquireReadAccess() );
			pRec->pBmpEx = new BitmapEx( aObjectBitmap, aMaskBitmap );
		}
		else
			pRec->pImage = new Image( aObjectBitmap, aMaskBitmap );

		pSlowObjList->Insert( pRec, LIST_APPEND );
	} 
	else
		delete pRec, pRec = NULL;

	delete pDev;

	return( pRec != NULL );
}


/*************************************************************************
|*
|* Ursprung des virtuellen Device nach links oben auf ein Vielfaches
|* der BrushSize (relativ zum Ursprung des ShowWindows) setzen. Dies ist
|* noetig, damit bei Benutzung von transparenten Farben die Farbmaske
|* (relativ zu den logischen Koordinaten) an der gleichen Position beginnt
|* wie im ShowWindow. Der MapMode-Origin des virtuellen Device wird
|* entsprechend angepasst, so dass die rechte untere Ecke des Device auf
|* den gleichen logischen Koordinaten verbleibt.
|*
|* Der Inhalt des virtuellen Device wird geloescht.
|*
\************************************************************************/

BOOL FuSlideShow::AdjustAnmVDev( const Rectangle& rObjRect, const Color& rBackColor )
{
	MapMode		aMap( pShowWindow->GetMapMode() );
	const Point	aTL( pShowWindow->PixelToLogic( pShowWindow->LogicToPixel( rObjRect.TopLeft() ) ) );
	Point		aOrg( pShowWindow->LogicToPixel( aTL ) );
	Size		aSize( pShowWindow->LogicToPixel( rObjRect.GetSize() ) );

	aOrg.X() -= VDEV_TOLERANCE;
	aOrg.Y() -= VDEV_TOLERANCE;
	aOrg = pShowWindow->PixelToLogic( aOrg );
	aMap.SetOrigin( Point( -aOrg.X(), -aOrg.Y() ) );
	aSize.Width() += ( VDEV_TOLERANCE << 1 );
	aSize.Height() += ( VDEV_TOLERANCE << 1 );
	pAnmVDev->SetBackground( rBackColor );
	pAnmVDev->SetMapMode( aMap );

	return pAnmVDev->SetOutputSizePixel( aSize );
}

/*************************************************************************
|*
|* Hat ein Objekt eine ClickAction, die bei ihrer Ausfuehrung in der
|* Praesentation die Seite des Objekts veraendert?
|*
\************************************************************************/

BOOL FuSlideShow::AffectsOwnPage(SdrObject* pObject)
{
	BOOL bResult = FALSE;
	SdAnimationInfo* pInfo = pDoc->GetAnimationInfo(pObject);

	if (pInfo)
	{
		// wenn das Objekt verschwinden kann
		if ( pInfo->eClickAction == presentation::ClickAction_INVISIBLE || pInfo->eClickAction == presentation::ClickAction_VANISH )
			bResult = TRUE;

		// wenn das Objekt zu einem Objekt auf der gleichen Seite fuehrt
		if (pInfo->eClickAction == presentation::ClickAction_BOOKMARK)
		{
			BOOL        bIsMasterPage;
            USHORT      nPgNum = pDoc->GetPageByName( pInfo->aBookmark, bIsMasterPage );
			SdrObject*  pObj   = NULL;
			
            if (nPgNum == SDRPAGE_NOTFOUND)
			{
				// Ist das Bookmark ein Objekt?
				pObj = pDoc->GetObj(pInfo->aBookmark);

				if (pObj)
					nPgNum = pObj->GetPage()->GetPageNum();
			}
			if (nPgNum == pObject->GetPage()->GetPageNum())
				bResult = TRUE;
		}
	}

	return bResult;
}

/*************************************************************************
|* nach dem Editieren des Gliederungstextes den Clone neu erstellen
\************************************************************************/

void FuSlideShow::EndTextEdit(SdrTextObj* pTextObj)
{
	if (pTextObj == pLayoutText)
	{
		CreateLayoutClone();
	}
}

/*************************************************************************
|* den Clone des Gliederungstextes neu erstellen
\************************************************************************/

void FuSlideShow::CreateLayoutClone()
{
	if (pLayoutText)
	{
		delete pLayoutClone;
		pLayoutClone = (SdrRectObj*)pLayoutText->Clone();
		if (nDimPos > 0)
			DimParas(pLayoutClone, 0, nDimPos - 1);
	}
}

/*************************************************************************
|*
|* Resize ( ruft asynchron den Resize-Handler )
|*
\************************************************************************/

BOOL FuSlideShow::Resize( const Size& rNewSize )
{
	aPresSize = rNewSize;

	// evtl. schon vorhandenes Event herausnehmen
	if( nResizeEvt )
		Application::RemoveUserEvent( nResizeEvt );

	// neues Event erzeugen und merken
	nResizeEvt = Application::PostUserEvent( LINK( this, FuSlideShow, ResizeHdl ) );

	return FALSE;
}

/*************************************************************************
|*
|* Resize-Handler
|*
\************************************************************************/

IMPL_LINK( FuSlideShow, ResizeHdl, void*, p )
{
	// Event wird abgearbeitet
	nResizeEvt = 0UL;

	if( nMagic != SLIDESHOW_MAGIC )
		return 0L;

	SdPage* pP = pDoc->GetSdPage( 0, PK_STANDARD );
    Size    aWinSize;
    MapMode aMapMode( MAP_100TH_MM ); 
	
    aPageSize.Width() = pP->GetSize().Width() - pP->GetRgtBorder() - pP->GetLftBorder() - 2;
	aPageSize.Height() = pP->GetSize().Height() - pP->GetUppBorder() - pP->GetLwrBorder() - 2;

    if( ANIMATIONMODE_VIEW != eAnimationMode )
    {
	    const Size aOldSize( pShowWindow->GetSizePixel() );

	    pShowWindow->SetSizePixel( aPresSize );
	    pShowWindow->Show();

        // Call ToTop() to bring the window to top if
        // a) the old size is not degenerate (then the window will be closed
        // soon) and
        // b) the animation mode is not that of a preview (on the one hand
        // this leaves the old behaviour for the slide show mode unmodified
        // and on the other hand does not move the focus from the document
        // to the (preview) window; the ToTop() seems not to be necessary at
        // least for the preview).
        if( !aOldSize.Width() && !aOldSize.Height() )
            if (eAnimationMode != ANIMATIONMODE_PREVIEW)
                pShowWindow->ToTop();           

	    // Zoom-Faktor bestimmen
        pShowWindow->SetMapMode( aMapMode );
	    aWinSize = pShowWindow->PixelToLogic( pShowWindow->GetOutputSizePixel() );
	    Fraction aZoom( Min( aWinSize.Width()  * 1000 / aPageSize.Width(), aWinSize.Height() * 1000 / aPageSize.Height() ), 1000 );

	    // MapMode bestimmen
	    aMapMode = pShowWindow->GetMapMode();
	    aMapMode.SetScaleX( aZoom );
	    aMapMode.SetScaleY( aZoom );
	    pShowWindow->SetMapMode( aMapMode );
    }
    else
	    aMapMode = pShowWindow->GetMapMode();

	// durch Zoomen veraendert
	// durch Zoomen veraendert
    aWinSize = pShowWindow->GetOutputSizePixel();

    if( aWinSize.Width() > 0 && aWinSize.Height() > 0 )
        aWinSize = pShowWindow->PixelToLogic( aWinSize );
    else
    {
        aMapMode = MapMode( MAP_100TH_MM );
        aWinSize.Width() = aWinSize.Height() = 0;
    }

	// Ursprung des sichtbaren Seitenbereichs im Fenster
	aPageOrigin.X() = ( aWinSize.Width() - aPageSize.Width() ) >> 1;
	aPageOrigin.Y() = ( aWinSize.Height() - aPageSize.Height() ) >> 1;

	// MapMode-Origin so berechnen, dass das Seiteninnere richtig liegt,
	// wenn die Seite bei (0,0) dargestellt wird
	Point aMMOrigin( aPageOrigin.X() - pP->GetLftBorder(), aPageOrigin.Y() - pP->GetUppBorder() );
	aMMOrigin = pShowWindow->PixelToLogic( pShowWindow->LogicToPixel( aMMOrigin ) );

	// muss nach MapMode-Verschiebung neu berechnet werden
	aPageOrigin.X() = pP->GetLftBorder();
	aPageOrigin.Y() = pP->GetUppBorder();

	// Groesse des virtuellen Device bestimmen: die Grenzen sollen mit drauf
	Point   aTopLeft( pShowWindow->LogicToPixel( Point( pP->GetLftBorder(), pP->GetUppBorder() ) ) );
	Point   aBotRight( pShowWindow->LogicToPixel( Point( pP->GetLftBorder() + aPageSize.Width() - 2, pP->GetUppBorder() + aPageSize.Height() - 2 ) ) );
	Size    aVDevSizePix( aBotRight.X() - aTopLeft.X() + 1, aBotRight.Y() - aTopLeft.Y() + 1 );

	aMapMode.SetOrigin ( aMMOrigin );

	pVDev->SetMapMode( aMapMode );

    if( ANIMATIONMODE_VIEW != eAnimationMode )
	    pShowWindow->SetMapMode( aMapMode );

	// Origin setzen; vorher auf Pixelkoordinaten runden
	aMMOrigin = Point( -pP->GetLftBorder(), -pP->GetUppBorder() );
	aMMOrigin = pVDev->PixelToLogic( pVDev->LogicToPixel( aMMOrigin ) );
	aMapMode.SetOrigin( aMMOrigin );
	pVDev->SetMapMode( aMapMode ); 

	pVDev->SetBackground( pShowWindow->GetBackground() );
	pVDev->SetFillColor( pShowWindow->GetFillColor() );
	pVDev->SetLineColor( pShowWindow->GetLineColor() );

	BOOL bAbort = !pVDev->SetOutputSizePixel( aVDevSizePix );

	// wenn die aktuelle Seite bereits gesetzt ist - dieser Aufruf also
	// nicht aus StartShow() heraus erfolgt -, muessen virtuelles Device,
	// das Metafile, Caches, Animationslisten usw. neu aufgebaut werden.
	// Im VDev ist jetzt nicht mehr die naechste Seite vorbereitet.
	if( pActualPage )
	{
		PrepareForPage( pActualPage, FALSE );

		if( pCurAnmList->Count() > 0 )
			RepaintVDev( pActualPage, TRUE );

		bVDevEmpty = TRUE;
	}

	return 0L;
}

/*************************************************************************
|*
|* Verteiler fuer Animationen
|*
\************************************************************************/

BOOL FuSlideShow::Animate()
{
	BOOL bResult = TRUE;
	return bResult;
}

/*************************************************************************
|*
|* Preview-Mode setzen
|*
\************************************************************************/

void FuSlideShow::SetAnimationMode(AnimationMode eMode, SdShowWindow* pWindow)
{
	eAnimationMode = eMode;
	bFullScreen = FALSE;
	pShowWindow = pWindow;

	if( eAnimationMode != ANIMATIONMODE_SHOW )
	{
		pShowWindow->Push();
		nPushCount++;
	}
}

/*************************************************************************
|*
|* alle Animationsobjekte der Seite animieren
|*
\************************************************************************/

BOOL FuSlideShow::AnimatePage()
{
	SdPage*		pPage = pDoc->GetSdPage( aAnimPageList.GetCurrentPageNum(), PK_STANDARD );
	ULONG		nObjectCount = pPage->GetObjCount();
	SdrObject*	pObject = NULL;
	BOOL		bAbort = FALSE;

	bVDevEmpty = TRUE;

	// das Fenster schwarz machen, falls man den Effekt sonst nicht sehen koennte
	switch( pPage->GetFadeEffect() )
	{
		case( presentation::FadeEffect_MOVE_FROM_LEFT ):
		case( presentation::FadeEffect_MOVE_FROM_UPPERLEFT ):
		case( presentation::FadeEffect_MOVE_FROM_TOP ):
		case( presentation::FadeEffect_MOVE_FROM_UPPERRIGHT ):
		case( presentation::FadeEffect_MOVE_FROM_RIGHT ):
		case( presentation::FadeEffect_MOVE_FROM_LOWERRIGHT ):
		case( presentation::FadeEffect_MOVE_FROM_BOTTOM ):
		case( presentation::FadeEffect_MOVE_FROM_LOWERLEFT ):
		case( presentation::FadeEffect_ROLL_FROM_LEFT ):
		case( presentation::FadeEffect_ROLL_FROM_TOP ):
		case( presentation::FadeEffect_ROLL_FROM_RIGHT ):
		case( presentation::FadeEffect_ROLL_FROM_BOTTOM ):
		case( presentation::FadeEffect_STRETCH_FROM_LEFT ):
		case( presentation::FadeEffect_STRETCH_FROM_TOP ):
		case( presentation::FadeEffect_STRETCH_FROM_RIGHT ):
		case( presentation::FadeEffect_STRETCH_FROM_BOTTOM ):
		break;

		default:
		{
			const ULONG nOldDrawMode = pShowWindow->GetDrawMode();
			pShowWindow->SetDrawMode( DRAWMODE_DEFAULT );
			pShowWindow->SetFillColor( Color( COL_BLACK ) );
			pShowWindow->DrawRect( Rectangle( pShowWindow->PixelToLogic( Point() ), pShowWindow->GetOutputSize() ) );
			pShowWindow->SetDrawMode( nOldDrawMode );
		}
		break;
	}

	// in der Preview muessen wir zunaechst einmal alle
	// Text- oder Grafikanimation stoppen, damit nicht
	// immer mehr Animation auf einem OutDev gestartet werden
	if ( ANIMATIONMODE_PREVIEW == eAnimationMode )
	{
		for ( ULONG nObject = 0; nObject < nObjectCount; nObject++ )
		{
			pObject	= pPage->GetObj(nObject);

			if ( pObject->IsInserted() )
			{
				SdAnimationInfo* pInfo = pDoc->GetAnimationInfo( pObject );

				if ( !pInfo || ( pInfo && pInfo->eEffect == presentation::AnimationEffect_NONE ) )
					StopTextOrGraphicAnimation( pObject, TRUE );

				// auch animierte Grafiken innerhalb von Gruppen sollen gestartet werden
				if ( pObject->GetObjInventor() == SdrInventor && pObject->GetObjIdentifier() == OBJ_GRUP )
				{
					SdrObjList*		pSubList = pObject->GetSubList();
					SdrObjListIter	aIter(*pSubList, IM_DEEPWITHGROUPS);

					for( SdrObject* pGrpObj = aIter.Next(); pGrpObj; pGrpObj = aIter.Next() )
						if ( !pInfo || ( pInfo && pInfo->eEffect == presentation::AnimationEffect_NONE ) )
							StopTextOrGraphicAnimation( pGrpObj, TRUE );
				}
			}
		}
	}

	DoPageFade();

	// Key-Events simulieren bis nichts mehr zu animieren oder abzublenden ist
	// (oder bis die Show im Reschedule eines Effekts zerstoert wurde)
	const KeyEvent aKEvt( 32, KeyCode( KEY_SPACE ) );

	while( nMagic == SLIDESHOW_MAGIC && ( pCurAnmList->Count() || pDimObject ) )
		KeyInput( aKEvt );

	return bAbort;
}

/*************************************************************************
|*
|* Effekt mit getrennter Grafik- und Textanimation
|*
\************************************************************************/

BOOL FuSlideShow::CompoundEffect()
{
	BOOL bAbort = FALSE;

	SdrObject*		pAnmObject = (SdrObject*)pCurAnmList->First();
	SdrRectObj*		pBckgndClone = (SdrRectObj*)pAnmObject->Clone();
	const Rectangle aLogicRect( pBckgndClone->GetLogicRect() );
	const BOOL		bAnimTxtObj = OBJIS_TEXTANIM( pAnmObject );

	// dessen Text loeschen
	pBckgndClone->NbcSetOutlinerParaObject(NULL);
	pBckgndClone->NbcSetLogicRect( aLogicRect );

	// die Animationsinfo des Clones patchen: ohne Text hat der Texteffekt
	// keinen Sinn
	SdAnimationInfo* pInfo = pDoc->GetAnimationInfo( pBckgndClone );
	presentation::AnimationEffect eTextEffect(pInfo->eTextEffect);
	pInfo->eTextEffect = presentation::AnimationEffect_NONE;

	// animieren; statt des Originalobjektes den Clone benutzen
	const BOOL bSoundOn = pInfo->bSoundOn;

	if( presentation::AnimationEffect_NONE == pInfo->eEffect )
		pInfo->bSoundOn = FALSE;

	bAbort = !AnimateObject( pBckgndClone );
	pInfo->bSoundOn = bSoundOn;

	/*******************************************************************
	|* jetzt der Text, wenn es kein Lauftext ist
	\******************************************************************/
	if( ( SLIDESHOW_MAGIC == nMagic ) && pAnmObject->GetOutlinerParaObject() && !bAnimTxtObj )
	{
		switch( eTextEffect )
		{
			case presentation::AnimationEffect_APPEAR:
			case presentation::AnimationEffect_FADE_FROM_LEFT:
			case presentation::AnimationEffect_FADE_FROM_UPPERLEFT:
			case presentation::AnimationEffect_FADE_FROM_TOP:
			case presentation::AnimationEffect_FADE_FROM_UPPERRIGHT:
			case presentation::AnimationEffect_FADE_FROM_RIGHT:
			case presentation::AnimationEffect_FADE_FROM_LOWERRIGHT:
			case presentation::AnimationEffect_FADE_FROM_BOTTOM:
			case presentation::AnimationEffect_FADE_FROM_LOWERLEFT:
			case presentation::AnimationEffect_FADE_TO_CENTER:
			case presentation::AnimationEffect_FADE_FROM_CENTER:
			case presentation::AnimationEffect_VERTICAL_STRIPES:
			case presentation::AnimationEffect_HORIZONTAL_STRIPES:
			case presentation::AnimationEffect_VERTICAL_LINES:
			case presentation::AnimationEffect_HORIZONTAL_LINES:
			case presentation::AnimationEffect_VERTICAL_CHECKERBOARD:
			case presentation::AnimationEffect_HORIZONTAL_CHECKERBOARD:
			case presentation::AnimationEffect_CLOCKWISE:
			case presentation::AnimationEffect_COUNTERCLOCKWISE:
			case presentation::AnimationEffect_CLOSE_VERTICAL:
			case presentation::AnimationEffect_CLOSE_HORIZONTAL:
			case presentation::AnimationEffect_OPEN_VERTICAL:
			case presentation::AnimationEffect_OPEN_HORIZONTAL:
			case presentation::AnimationEffect_SPIRALIN_LEFT:
			case presentation::AnimationEffect_SPIRALIN_RIGHT:
			case presentation::AnimationEffect_SPIRALOUT_LEFT:
			case presentation::AnimationEffect_SPIRALOUT_RIGHT:
			case presentation::AnimationEffect_DISSOLVE:
			case presentation::AnimationEffect_WAVYLINE_FROM_LEFT:
			case presentation::AnimationEffect_WAVYLINE_FROM_TOP:
			case presentation::AnimationEffect_WAVYLINE_FROM_RIGHT:
			case presentation::AnimationEffect_WAVYLINE_FROM_BOTTOM:
			case presentation::AnimationEffect_HIDE:

			case presentation::AnimationEffect_MOVE_FROM_LEFT:
			case presentation::AnimationEffect_MOVE_FROM_UPPERLEFT:
			case presentation::AnimationEffect_MOVE_FROM_TOP:
			case presentation::AnimationEffect_MOVE_FROM_UPPERRIGHT:
			case presentation::AnimationEffect_MOVE_FROM_RIGHT:
			case presentation::AnimationEffect_MOVE_FROM_LOWERRIGHT:
			case presentation::AnimationEffect_MOVE_FROM_BOTTOM:
			case presentation::AnimationEffect_MOVE_FROM_LOWERLEFT:

			case presentation::AnimationEffect_MOVE_SHORT_FROM_LEFT:
			case presentation::AnimationEffect_MOVE_SHORT_FROM_UPPERLEFT:
			case presentation::AnimationEffect_MOVE_SHORT_FROM_TOP:
			case presentation::AnimationEffect_MOVE_SHORT_FROM_UPPERRIGHT:
			case presentation::AnimationEffect_MOVE_SHORT_FROM_RIGHT:
			case presentation::AnimationEffect_MOVE_SHORT_FROM_LOWERRIGHT:
			case presentation::AnimationEffect_MOVE_SHORT_FROM_BOTTOM:
			case presentation::AnimationEffect_MOVE_SHORT_FROM_LOWERLEFT:

			case presentation::AnimationEffect_STRETCH_FROM_LEFT:
			case presentation::AnimationEffect_STRETCH_FROM_UPPERLEFT:
			case presentation::AnimationEffect_STRETCH_FROM_TOP:
			case presentation::AnimationEffect_STRETCH_FROM_UPPERRIGHT:
			case presentation::AnimationEffect_STRETCH_FROM_RIGHT:
			case presentation::AnimationEffect_STRETCH_FROM_LOWERRIGHT:
			case presentation::AnimationEffect_STRETCH_FROM_BOTTOM:
			case presentation::AnimationEffect_STRETCH_FROM_LOWERLEFT:

			case presentation::AnimationEffect_HORIZONTAL_STRETCH:
			case presentation::AnimationEffect_VERTICAL_STRETCH:

			case presentation::AnimationEffect_HORIZONTAL_ROTATE:
			case presentation::AnimationEffect_VERTICAL_ROTATE:

			case presentation::AnimationEffect_LASER_FROM_LEFT:
			case presentation::AnimationEffect_LASER_FROM_TOP:
			case presentation::AnimationEffect_LASER_FROM_RIGHT:
			case presentation::AnimationEffect_LASER_FROM_BOTTOM:
			case presentation::AnimationEffect_LASER_FROM_UPPERLEFT:
			case presentation::AnimationEffect_LASER_FROM_UPPERRIGHT:
			case presentation::AnimationEffect_LASER_FROM_LOWERLEFT:
			case presentation::AnimationEffect_LASER_FROM_LOWERRIGHT:
			{
				// der hier erzeugte Clone wird innerhalb
				// von AnimateLayoutText an pLayoutClone
				// gesetzt und somit wieder automatisch zerstoert
				delete pLayoutClone;
				pLayoutClone = NULL;
				pLayoutText = NULL;
				pCompoundText = (SdrRectObj*) pAnmObject->Clone();
				pInfo = pDoc->GetAnimationInfo( pCompoundText );
				pInfo->eEffect = eTextEffect;
				pInfo->eTextEffect = presentation::AnimationEffect_NONE;

				// da das Object nach dem obigen AnimateObject
				// entfernt wurde, jetzt noch einmal einfuegen
				pCurAnmList->Insert( pAnmObject, (ULONG) 0 );
				bAbort = !AnimateObject();
			}
			break;

			default:
				DBG_ASSERT(FALSE, "verbotener Effekt als Texteffekt");
			break;
		}
	}

	delete pBckgndClone;

	return !bAbort;
}

