/*************************************************************************
 *
 *  $RCSfile: insrtdsk.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:50:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SETUP_INSRTDSK_HXX
#define _SETUP_INSRTDSK_HXX

#ifndef _SV_DIALOG_HXX //autogen
#include <vcl/dialog.hxx>
#endif

#ifndef _SV_EDIT_HXX //autogen
#include <vcl/edit.hxx>
#endif

#ifndef _SV_FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif

#ifndef _SV_BUTTON_HXX //autogen
#include <vcl/button.hxx>
#endif

#define RET_IGNORE	100

class SetupInsertDiskDialog : public ModalDialog
{
	FixedImage	 m_aLogoImg;

	Edit         m_aPathNameEdit;
	PushButton   m_aDirButton;
	OKButton     m_aOKButton;
	Point		 m_pntOKButton;
	CancelButton m_aCancelButton;
	PushButton 	 m_aIgnoreButton;

	FixedText    m_aFileText;
	FixedText    m_a2Text;
	FixedText    m_aDiskNameText;
	FixedText    m_a3Text;
	FixedText    m_a4Text;

	String		m_sFileStr;
	String 		m_aSourcePath;

	String		 m_aUpdate1;
	String		 m_aUpdate2;
	String		 m_aUpdate3;

	void CancelHdl( Button * );

	DECL_LINK( OKHdl, Button * );
	DECL_LINK( DirHdl, Button * );
	DECL_LINK( IgnoreHdl, Button * );

public:

	SetupInsertDiskDialog
	(
		Window		* pParent,
		Point  const& aPoint,
		ByteString const& aProgramName,
		ByteString const& aDiskName,
		ByteString const& aSourcePath
	);

	virtual short Execute();

	void 	SetUpdateMode(const ByteString& rRequiredVersion, const ByteString& rUpdateName);
	void	SetFileText( const ByteString& rNew );

	void 	SetDiskText( const String& rDisk ) { m_aDiskNameText.SetText( rDisk );}

	void	SetError();
	String	GetSourcePath() const { return m_aSourcePath; }
};

#endif

