<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:cfg="http://openoffice.org/2000/registry/instance"  xmlns:oor="http://openoffice.org/2001/registry" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" cfg:package="org.openoffice.Office" xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xmlns="http://www.w3.org/2001/XMLSchema">

    <xsl:output encoding="UTF-8"/>

    <xsl:template match="/*">
        <xsl:element name="oor:component-data">
            <xsl:call-template name="component-attribs"/>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="/*//*">
        <xsl:choose>
            <xsl:when test="(count(@cfg:type) and @cfg:type!='set') or @xsi:null='true'">
                <xsl:call-template name="prop-element"/>
            </xsl:when>
            <xsl:when test="name()='cfg:value'">
                <xsl:call-template name="value-element"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="node-element"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="component-attribs">
        <xsl:attribute name="xmlns:oor">http://openoffice.org/2001/registry</xsl:attribute>
        <xsl:attribute name="xmlns:xs">http://www.w3.org/2001/XMLSchema</xsl:attribute>
        <xsl:attribute name="xmlns:xsi">http://www.w3.org/2001/XMLSchema-instance</xsl:attribute>
        <xsl:attribute name="oor:name">
            <xsl:choose>
                <xsl:when test="@cfg:name!=''">
                    <xsl:value-of select="@cfg:name"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="local-name()"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:attribute>
        <xsl:attribute name="oor:package">
            <xsl:value-of select="@cfg:package"/>
        </xsl:attribute>
    </xsl:template>

    <xsl:template name="node-element">
        <xsl:element name="node">
            <xsl:call-template name="node-attribs"/>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template name="node-attribs">
        <xsl:attribute name="oor:name">
            <xsl:choose>
                <xsl:when test="@cfg:name!=''">
                    <xsl:value-of select="@cfg:name"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="local-name()"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:attribute>
        <xsl:choose>
            <xsl:when test="@state='deleted'">
                <xsl:attribute name="oor:op">remove</xsl:attribute>
            </xsl:when>
            <xsl:when test="@state='default'">
                <xsl:attribute name="oor:op">reset</xsl:attribute>
            </xsl:when>
            <xsl:when test="@state='replaced' or (../@cfg:element-type!='' and ancestor::*/@state='replaced')">
                <xsl:attribute name="oor:op">replace</xsl:attribute>
            </xsl:when>
            <xsl:otherwise/>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="prop-element">
        <xsl:element name="prop">
            <xsl:call-template name="prop-attribs"/>
            <xsl:choose>
                <xsl:when test="cfg:value">
                    <xsl:apply-templates select="cfg:value"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="value-element"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:element>
    </xsl:template>

    <xsl:template name="prop-attribs">
        <xsl:attribute name="oor:name">
            <xsl:choose>
                <xsl:when test="@cfg:name!=''">
                    <xsl:value-of select="@cfg:name"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="local-name()"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:attribute>
        <xsl:choose>
            <xsl:when test="@state='deleted'">
                <xsl:attribute name="oor:op">remove</xsl:attribute>
            </xsl:when>
            <xsl:when test="@state='default'">
                <xsl:attribute name="oor:op">reset</xsl:attribute>
            </xsl:when>
            <xsl:when test="@state='replaced' or ../@cfg:element-type!=''">
                <xsl:attribute name="oor:op">replace</xsl:attribute>
            </xsl:when>
            <xsl:otherwise/>
        </xsl:choose>
        <xsl:if test="@cfg:type!=''">
            <xsl:choose>
                <xsl:when test="@cfg:type='binary'">
                    <xsl:choose>
                        <xsl:when test="@cfg:derivedBy='list'">
                            <xsl:attribute name="oor:type">oor:hexBinary-list</xsl:attribute>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:attribute name="oor:type">xs:hexBinary</xsl:attribute>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:choose>
                        <xsl:when test="@cfg:derivedBy='list'">
                            <xsl:attribute name="oor:type">oor:<xsl:value-of select="@cfg:type"/>-list</xsl:attribute>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:attribute name="oor:type">xs:<xsl:value-of select="@cfg:type"/></xsl:attribute>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>

    <xsl:template name="value-element">
        <xsl:element name="value">
            <xsl:if test="@xml:lang!=''">
                <xsl:attribute name="xml:lang"><xsl:value-of select="@xml:lang"/></xsl:attribute>
            </xsl:if>
            <xsl:choose>
                <xsl:when test="@xsi:null = 'true'">
                    <xsl:attribute name="xsi:nil">true</xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="."/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:element>
    </xsl:template>

</xsl:stylesheet>
