/*************************************************************************
 *
 *  $RCSfile: wrapper.cxx,v $
 *
 *  $Revision: 1.8.60.1 $
 *
 *  last change: $Author: hr $ $Date: 2004/01/09 18:52:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef __SBX_SBXPROPERTY_HXX //autogen
#include <svtools/sbxprop.hxx>
#endif

#ifndef _SBXCLASS_HXX //autogen
#include <svtools/sbx.hxx>
#endif

#include "wrapper.hxx"
#include "fields.hxx"
#include "sihelp.hxx"

// =======================================================================
// =======================================================================
//	PagePool
// =======================================================================

SibPagePool::SibPagePool() :
	SbxObject( UniString::CreateFromAscii("UIPool") )
{
	Insert(new SbxProperty(UniString::CreateFromAscii("PAGE_WELCOME"),				SbxINTEGER) );
	Insert(new SbxProperty(UniString::CreateFromAscii("PAGE_LICENSE"),				SbxINTEGER) );
	Insert(new SbxProperty(UniString::CreateFromAscii("PAGE_SERIALNUMBER"),			SbxINTEGER) );
	Insert(new SbxProperty(UniString::CreateFromAscii("PAGE_INSTALLMODE"),			SbxINTEGER) );
	Insert(new SbxProperty(UniString::CreateFromAscii("PAGE_INSTPATH"),	   			SbxINTEGER) );
	Insert(new SbxProperty(UniString::CreateFromAscii("PAGE_USERDEFINED"),			SbxINTEGER) );
	Insert(new SbxProperty(UniString::CreateFromAscii("PAGE_READYGO"),	   			SbxINTEGER) );
	Insert(new SbxProperty(UniString::CreateFromAscii("PAGE_README"),	  			SbxINTEGER) );
	Insert(new SbxProperty(UniString::CreateFromAscii("PAGE_ADDRESS"),	  			SbxINTEGER) );
	Insert(new SbxProperty(UniString::CreateFromAscii("PAGE_HAVEFUN"),	   			SbxINTEGER) );
	Insert(new SbxProperty(UniString::CreateFromAscii("PAGE_WRONGSETUP"),	  		SbxINTEGER) );
	Insert(new SbxProperty(UniString::CreateFromAscii("PAGE_REINSTALLATION"),		SbxINTEGER) );
	Insert(new SbxProperty(UniString::CreateFromAscii("PAGE_UNINSTALL"),	  	  	SbxINTEGER) );
	Insert(new SbxProperty(UniString::CreateFromAscii("PAGE_RECOVER"),	 	  		SbxINTEGER) );
	Insert(new SbxProperty(UniString::CreateFromAscii("PAGE_TOPLEVEL"),	 	  		SbxINTEGER) );
	Insert(new SbxProperty(UniString::CreateFromAscii("PAGE_CRCCHECK"),	 			SbxINTEGER) );
	Insert(new SbxProperty(UniString::CreateFromAscii("PAGE_LANGUAGE"),	 			SbxINTEGER) );
	Insert(new SbxProperty(UniString::CreateFromAscii("PAGE_ASRV_REINSTALLATION"),	SbxINTEGER) );
	Insert(new SbxProperty(UniString::CreateFromAscii("PAGE_ASRV_UNINSTALL"),		SbxINTEGER) );
	Insert(new SbxProperty(UniString::CreateFromAscii("PAGE_ASRV_START"),			SbxINTEGER) );
	Insert(new SbxProperty(UniString::CreateFromAscii("PAGE_ASRV_USERNAME"),		SbxINTEGER) );
	Insert(new SbxProperty(UniString::CreateFromAscii("PAGE_ASRV_USERPATH"),		SbxINTEGER) );
	Insert(new SbxProperty(UniString::CreateFromAscii("PAGE_ASRV_SERVERPATH"),		SbxINTEGER) );
	Insert(new SbxProperty(UniString::CreateFromAscii("PAGE_ASRV_REMEMBER"),		SbxINTEGER) );
	Insert(new SbxProperty(UniString::CreateFromAscii("PAGE_USERREGISTRATION"),		SbxINTEGER) );
	Insert(new SbxProperty(UniString::CreateFromAscii("PAGE_WARNADDRESS"),	   		SbxINTEGER) );
	Insert(new SbxProperty(UniString::CreateFromAscii("PAGE_REPAIR"),				SbxINTEGER) );
	Insert(new SbxProperty(UniString::CreateFromAscii("PAGE_PAGESCRIPTNOTFOUND"),  	SbxINTEGER) );

	Insert(new SbxProperty(UniString::CreateFromAscii("RETURN_1"),					SbxINTEGER) );
	Insert(new SbxProperty(UniString::CreateFromAscii("RETURN_2"),					SbxINTEGER) );
	Insert(new SbxProperty(UniString::CreateFromAscii("RETURN_3"),					SbxINTEGER) );
}

SibPagePool::~SibPagePool()
{
}

void SibPagePool::Notify( SfxBroadcaster& rBC, SfxHint const& rHint )
{
	const SbxHint* pHint = (SbxHint*) &rHint;

	if( pHint->GetId() == SBX_HINT_DATAWANTED )
	{
		SbxVariable* pVar = pHint->GetVar();
		ByteString aName = ByteString( pVar->GetName(), osl_getThreadTextEncoding() );

		USHORT nId = SiHelp::GetUIPageIdByName(aName);
		if( nId )
			pVar->PutInt( nId );
		else if( aName.CompareIgnoreCaseToAscii("RETURN_0") == COMPARE_EQUAL )
			pVar->PutInt( 0 );
		else if( aName.CompareIgnoreCaseToAscii("RETURN_1") == COMPARE_EQUAL )
			pVar->PutInt( 1 );
		else if( aName.CompareIgnoreCaseToAscii("RETURN_2") == COMPARE_EQUAL )
			pVar->PutInt( 2 );
		else if( aName.CompareIgnoreCaseToAscii("RETURN_3") == COMPARE_EQUAL )
			pVar->PutInt( 3 );

		return ;
	}
	SbxObject::Notify(rBC, rHint);
}

// =======================================================================
// =======================================================================
//	Environment
// =======================================================================
SibEnvironment::SibEnvironment(SiEnvironment const* pEnv)
: SbxObject( UniString::CreateFromAscii("Environment") )
{
	m_pEnv = pEnv;

	Insert( new SbxProperty(UniString::CreateFromAscii("DestPath"),		SbxSTRING) );
	Insert( new SbxProperty(UniString::CreateFromAscii("SourcePath"),	SbxSTRING) );
	Insert( new SbxProperty(UniString::CreateFromAscii("StartPath"),	SbxSTRING) );
	Insert( new SbxProperty(UniString::CreateFromAscii("ProductName"),	SbxSTRING) );
	Insert( new SbxProperty(UniString::CreateFromAscii("InstallMode"),	SbxSTRING) );
	Insert( new SbxProperty(UniString::CreateFromAscii("InstallType"),	SbxSTRING) );

	Insert( new SbxProperty(UniString::CreateFromAscii("IsFirstInstallation"),	SbxBOOL) );
	Insert( new SbxProperty(UniString::CreateFromAscii("IsLocal"),				SbxBOOL) );
	Insert( new SbxProperty(UniString::CreateFromAscii("IsInstallFromNet"),	 	SbxBOOL) );
	Insert( new SbxProperty(UniString::CreateFromAscii("IsBigMode"),			SbxBOOL) );
	Insert( new SbxProperty(UniString::CreateFromAscii("IsInstallForAllUser"),	SbxBOOL) );
	Insert( new SbxProperty(UniString::CreateFromAscii("IsUpdateOldVersion"),	SbxBOOL) );
}

void SibEnvironment::Notify(SfxBroadcaster& rBC, SfxHint const& rHint)
{
	const SbxHint* pHint = (SbxHint*) &rHint;

	if (pHint->GetId() == SBX_HINT_DATAWANTED)
	{
		SbxVariable *pVar = pHint->GetVar();
		ByteString aName = ByteString( pVar->GetName(), osl_getThreadTextEncoding() );

		if( aName.CompareIgnoreCaseToAscii("DestPath") == COMPARE_EQUAL )
		{
			// #91499#
			// pVar->PutString( UniString::CreateFromAscii(m_pEnv->GetDestPath().GetBuffer()) );
			pVar->PutString( UniString(m_pEnv->GetDestPath(), osl_getThreadTextEncoding()) );
		}
		else if( aName.CompareIgnoreCaseToAscii("SourcePath") == COMPARE_EQUAL )
		{
			ByteString aPath( m_pEnv->GetSourcePath() );
			if( m_pEnv->IsBigMode() )
			{
				SiDirEntry aEntry( aPath );
				SiDirEntry temp = aEntry.GetPath();
				aPath = temp.GetFull();
			}
			// pVar->PutString( UniString::CreateFromAscii(aPath.GetBuffer()) );
			pVar->PutString( UniString(aPath, osl_getThreadTextEncoding()) );
		}
		else if( aName.CompareIgnoreCaseToAscii("StartPath") == COMPARE_EQUAL )
		{
			// pVar->PutString( UniString::CreateFromAscii(m_pEnv->GetStartPath().GetBuffer()) );
			pVar->PutString( UniString(m_pEnv->GetStartPath(), osl_getThreadTextEncoding()) );
		}
		else if( aName.CompareIgnoreCaseToAscii("ProductName") == COMPARE_EQUAL )
		{
			pVar->PutString( UniString::CreateFromAscii(m_pEnv->GetProductName().GetBuffer()) );
		}
		else if( aName.CompareIgnoreCaseToAscii("InstallMode") == COMPARE_EQUAL )
		{
			ByteString aInstMode;
			switch( m_pEnv->GetInstallMode() )
			{
				case IM_STANDALONE :	aInstMode = "IM_STANDALONE";
										break;
				case IM_NETWORK :       if ( m_pEnv->IsUpdateOldVersion() )
                                        {
                                            if ( m_pEnv->IsLocal() )
                                                aInstMode = "IM_WORKSTATION";
                                            else
                                                aInstMode = "IM_NETWORK";
                                        }
                                        else
                                            aInstMode = "IM_NETWORK";
										break;
				case IM_WORKSTATION :	aInstMode = "IM_WORKSTATION";
										break;
				case IM_APPSERVER :     aInstMode = "IM_APPSERVER";
										break;
				case IM_TOPLEVEL :		aInstMode = "IM_TOPLEVEL";
										break;
                case IM_PATCH:          aInstMode = "IM_PATCH";
										break;
                case IM_INVALID :
				default:				aInstMode = "IM_INVALID";
										break;
			}
			pVar->PutString( UniString::CreateFromAscii(aInstMode.GetBuffer()) );
		}
		else if( aName.CompareIgnoreCaseToAscii("InstallType") == COMPARE_EQUAL )
		{
			ByteString aInstType;
			switch( m_pEnv->GetInstallType() )
			{
				case IT_MAXIMAL :		aInstType = "IT_MAXIMAL";
										break;
				case IT_USERDEFINED :	aInstType = "IT_USERDEFINED";
										break;
				case IT_MINIMAL :		aInstType = "IT_MINIMAL";
										break;
				case IT_WORKSTATION :	aInstType = "IT_WORKSTATION";
										break;
				case IT_CHANGE :		aInstType = "IT_CHANGE";
										break;
				case IT_RECOVER :		aInstType = "IT_RECOVER";
										break;
				case IT_UNINSTALL :		aInstType = "IT_UNINSTALL";
										break;
				case IT_INVALID :
				default:				aInstType = "IT_INVALID";
										break;
			}
			pVar->PutString( UniString::CreateFromAscii(aInstType.GetBuffer()) );
		}
		else if( aName.CompareIgnoreCaseToAscii("IsFirstInstallation") == COMPARE_EQUAL )
		{
			pVar->PutBool( m_pEnv->IsFirstInstallation() );
		}
		else if( aName.CompareIgnoreCaseToAscii("IsLocal") == COMPARE_EQUAL )
		{
			pVar->PutBool( m_pEnv->IsLocal() );
		}
		else if( aName.CompareIgnoreCaseToAscii("IsInstallFromNet") == COMPARE_EQUAL )
		{
			pVar->PutBool( m_pEnv->InstallFromNet() );
		}
		else if( aName.CompareIgnoreCaseToAscii("IsBigMode") == COMPARE_EQUAL )
		{
			pVar->PutBool( m_pEnv->IsBigMode() );
		}
		else if( aName.CompareIgnoreCaseToAscii("IsInstallForAllUser") == COMPARE_EQUAL )
		{
			pVar->PutBool( m_pEnv->InstallForAllUser() );
		}
		else if( aName.CompareIgnoreCaseToAscii("IsUpdateOldVersion") == COMPARE_EQUAL )
		{
			pVar->PutBool( m_pEnv->IsUpdateOldVersion() );
		}
		return;
	}

	SbxObject::Notify(rBC, rHint);
}


// =======================================================================
// =======================================================================
//	DataCarrier
// =======================================================================
SibDataCarrier::SibDataCarrier(SiDataCarrier const* pDC)
: SbxObject( UniString::CreateFromAscii("DataCarrier") )
{
	m_pDC = pDC;
	Insert(new SbxProperty(UniString::CreateFromAscii(PROPERTY_NAME),	  SbxSTRING));
	Insert(new SbxProperty(UniString::CreateFromAscii(PROPERTY_ARCHIVE),  SbxSTRING));
	Insert(new SbxProperty(UniString::CreateFromAscii(PROPERTY_DISKNO),   SbxINTEGER));
}

void SibDataCarrier::Notify(SfxBroadcaster& rBC, SfxHint const& rHint)
{
	const SbxHint* pHint = (SbxHint*) &rHint;

	if (pHint->GetId() == SBX_HINT_DATAWANTED)
	{
		SbxVariable *pVar  = pHint->GetVar();
		ByteString		 aName = ByteString( pVar->GetName(), osl_getThreadTextEncoding() );

		if (aName.CompareIgnoreCaseToAscii(PROPERTY_NAME) == COMPARE_EQUAL)
		{
			pVar->PutString(UniString::CreateFromAscii(m_pDC->GetName().GetBuffer()));
		}
		else if (aName.CompareIgnoreCaseToAscii(PROPERTY_ARCHIVE) == COMPARE_EQUAL)
		{
			pVar->PutString(UniString::CreateFromAscii(m_pDC->GetArchive().GetBuffer()));
		}
		else if (aName.CompareIgnoreCaseToAscii(PROPERTY_DISKNO) == COMPARE_EQUAL)
		{
			pVar->PutInt(m_pDC->GetDiskNo());
		}

		return;
	}

	SbxObject::Notify(rBC, rHint);
}


// =======================================================================
// =======================================================================
//	Directory
// =======================================================================
SibDirectory::SibDirectory(SiDirectory const* pDir)
: SbxObject(UniString::CreateFromAscii("Directory"))
{
	m_pDir = pDir;
	Insert(new SbxProperty(UniString::CreateFromAscii(PROPERTY_NAME),	  SbxSTRING));
	Insert(new SbxProperty(UniString::CreateFromAscii(PROPERTY_PARENTID), SbxOBJECT));
	Insert(new SbxProperty(UniString::CreateFromAscii(VALUE_WORKSTATION), SbxBOOL));
}

void SibDirectory::Notify(SfxBroadcaster& rBC, SfxHint const& rHint)
{
	const SbxHint* pHint = (SbxHint*) &rHint;

	if (pHint->GetId() == SBX_HINT_DATAWANTED)
	{
		SbxVariable *pVar  = pHint->GetVar();
		ByteString		 aName = ByteString( pVar->GetName(), osl_getThreadTextEncoding() );

		if (aName.CompareIgnoreCaseToAscii(PROPERTY_NAME) == COMPARE_EQUAL)
		{
			pVar->PutString(UniString::CreateFromAscii(m_pDir->GetName().GetBuffer()));
		}
		else if (aName.CompareIgnoreCaseToAscii(PROPERTY_PARENTID) == COMPARE_EQUAL)
		{
			if (m_pDir->GetParent() != NULL)
				pVar->PutObject(new SibDirectory(m_pDir->GetParent()));
			else
				pVar->PutNull();
		}
		else if (aName.CompareIgnoreCaseToAscii(VALUE_WORKSTATION) == COMPARE_EQUAL)
		{
			pVar->PutBool(m_pDir->InstallOnWorkstation());
		}

		return;
	}

	SbxObject::Notify(rBC, rHint);
}


// =======================================================================
// =======================================================================
//	File
// =======================================================================
SibFile::SibFile(SiFile const* pFile)
: SbxObject(UniString::CreateFromAscii("File"))
{
	m_pFile = pFile;
	Insert(new SbxProperty(UniString::CreateFromAscii(PROPERTY_NAME),		SbxSTRING));
	Insert(new SbxProperty(UniString::CreateFromAscii(PROPERTY_PACKEDNAME), SbxSTRING));
	Insert(new SbxProperty(UniString::CreateFromAscii(PROPERTY_CARRIER),	SbxOBJECT));
	Insert(new SbxProperty(UniString::CreateFromAscii(PROPERTY_DIR),		SbxOBJECT));
	Insert(new SbxProperty(UniString::CreateFromAscii(PROPERTY_NETDIR),		SbxOBJECT));
	Insert(new SbxProperty(UniString::CreateFromAscii(VALUE_WORKSTATION),	SbxBOOL));
}

void SibFile::Notify(SfxBroadcaster& rBC, SfxHint const& rHint)
{
	const SbxHint* pHint = (SbxHint*) &rHint;

	if (pHint->GetId() == SBX_HINT_DATAWANTED)
	{
		SbxVariable *pVar  = pHint->GetVar();
		ByteString		 aName = ByteString( pVar->GetName(), osl_getThreadTextEncoding() );

		if (aName.CompareIgnoreCaseToAscii(PROPERTY_NAME) == COMPARE_EQUAL)
		{
			pVar->PutString(UniString::CreateFromAscii(m_pFile->GetName().GetBuffer()));
		}
		else if (aName.CompareIgnoreCaseToAscii(PROPERTY_PACKEDNAME) == COMPARE_EQUAL)
		{
			pVar->PutString(UniString::CreateFromAscii(m_pFile->GetPackedName().GetBuffer()));
		}
		else if (aName.CompareIgnoreCaseToAscii(PROPERTY_DIR) == COMPARE_EQUAL)
		{
			pVar->PutObject(new SibDirectory(m_pFile->GetDirectory()));
		}
		else if (aName.CompareIgnoreCaseToAscii(PROPERTY_NETDIR) == COMPARE_EQUAL)
		{
			pVar->PutObject(new SibDirectory(m_pFile->GetNetDirectory()));
		}
		else if (aName.CompareIgnoreCaseToAscii(PROPERTY_CARRIER) == COMPARE_EQUAL)
		{
			pVar->PutObject(new SibDataCarrier(m_pFile->GetDataCarrier()));
		}
		else if (aName.CompareIgnoreCaseToAscii(VALUE_WORKSTATION) == COMPARE_EQUAL)
		{
			pVar->PutBool(m_pFile->InstallOnWorkstation());
		}

		return;
	}

	SbxObject::Notify(rBC, rHint);
}


// =======================================================================
// =======================================================================
//	Profile
// =======================================================================
SibProfile::SibProfile(SiProfile const* pProfile)
: SbxObject(UniString::CreateFromAscii("Profile"))
{
	m_pProfile = pProfile;
	Insert(new SbxProperty(UniString::CreateFromAscii(PROPERTY_NAME), SbxSTRING));
	Insert(new SbxProperty(UniString::CreateFromAscii(PROPERTY_DIR),  SbxOBJECT));
	Insert(new SbxProperty(UniString::CreateFromAscii(VALUE_NETWORK), SbxBOOL));
}

void SibProfile::Notify(SfxBroadcaster& rBC, SfxHint const& rHint)
{
	const SbxHint* pHint = (SbxHint*) &rHint;

	if (pHint->GetId() == SBX_HINT_DATAWANTED)
	{
		SbxVariable *pVar  = pHint->GetVar();
		ByteString		 aName = ByteString( pVar->GetName(), osl_getThreadTextEncoding() );

		if (aName.CompareIgnoreCaseToAscii(PROPERTY_NAME) == COMPARE_EQUAL)
		{
			pVar->PutString(UniString::CreateFromAscii(m_pProfile->GetName().GetBuffer()));
		}
		else if (aName.CompareIgnoreCaseToAscii(PROPERTY_DIR) == COMPARE_EQUAL)
		{
			if (m_pProfile->GetDirectory() != NULL)
				pVar->PutObject(new SibDirectory(m_pProfile->GetDirectory()));
			else
				pVar->PutNull();
		}
		else if (aName.CompareIgnoreCaseToAscii(VALUE_NETWORK) == COMPARE_EQUAL)
		{
			pVar->PutBool(m_pProfile->InstallOnNetwork());
		}

		return;
	}

	SbxObject::Notify(rBC, rHint);
}


// =======================================================================
// =======================================================================
//	ProfileItem
// =======================================================================
SibProfileItem::SibProfileItem(SiProfileItem const* pPI)
: SbxObject(UniString::CreateFromAscii("ProfileItem"))
{
	m_pPI = pPI;
	Insert( new SbxProperty(UniString::CreateFromAscii(PROPERTY_PROFILEID),			SbxOBJECT) );
	Insert( new SbxProperty(UniString::CreateFromAscii(PROPERTY_SECTION),			SbxSTRING) );
	Insert( new SbxProperty(UniString::CreateFromAscii(PROPERTY_KEY),				SbxSTRING) );
	Insert( new SbxProperty(UniString::CreateFromAscii(PROPERTY_VALUE),				SbxSTRING) );
	Insert( new SbxProperty(UniString::CreateFromAscii(PROPERTY_WORKSTATIONVALUE),	SbxSTRING) );
	Insert( new SbxProperty(UniString::CreateFromAscii(PROPERTY_STANDALONEVALUE),	SbxSTRING) );
}

void SibProfileItem::Notify(SfxBroadcaster& rBC, SfxHint const& rHint)
{
	const SbxHint* pHint = (SbxHint*) &rHint;

	if (pHint->GetId() == SBX_HINT_DATAWANTED)
	{
		SbxVariable *pVar  = pHint->GetVar();
		ByteString		 aName = ByteString( pVar->GetName(), osl_getThreadTextEncoding() );

		if (aName.CompareIgnoreCaseToAscii(PROPERTY_PROFILEID) == COMPARE_EQUAL)
		{
			if (m_pPI->GetProfile() != NULL)
				pVar->PutObject(new SibProfile(m_pPI->GetProfile()));
			else
				pVar->PutNull();
		}
		else if (aName.CompareIgnoreCaseToAscii(PROPERTY_SECTION) == COMPARE_EQUAL)
		{
			pVar->PutString(UniString::CreateFromAscii(m_pPI->GetSection().GetBuffer()));
		}
		else if (aName.CompareIgnoreCaseToAscii(PROPERTY_KEY) == COMPARE_EQUAL)
		{
			pVar->PutString(UniString::CreateFromAscii(m_pPI->GetKey().GetBuffer()));
		}
		else if (aName.CompareIgnoreCaseToAscii(PROPERTY_VALUE) == COMPARE_EQUAL)
		{
			pVar->PutString(UniString::CreateFromAscii(m_pPI->GetValue().GetBuffer()));
		}
		else if (aName.CompareIgnoreCaseToAscii(PROPERTY_WORKSTATIONVALUE) == COMPARE_EQUAL)
		{
			pVar->PutString(UniString::CreateFromAscii(m_pPI->GetWorkstationValue().GetBuffer()));
		}
		else if (aName.CompareIgnoreCaseToAscii(PROPERTY_STANDALONEVALUE) == COMPARE_EQUAL)
		{
			pVar->PutString(UniString::CreateFromAscii(m_pPI->GetStandaloneValue().GetBuffer()));
		}

		return;
	}

	SbxObject::Notify(rBC, rHint);
}


// =======================================================================
// =======================================================================
//	RegistryItem
// =======================================================================
SibRegistryItem::SibRegistryItem(SiRegistryItem const* pRI)
: SbxObject(UniString::CreateFromAscii("RegistryItem"))
{
	m_pRI = pRI;
	Insert(new SbxProperty(UniString::CreateFromAscii(PROPERTY_PARENTID),	SbxOBJECT));
	Insert(new SbxProperty(UniString::CreateFromAscii(PROPERTY_KEY),		SbxSTRING));
	Insert(new SbxProperty(UniString::CreateFromAscii(PROPERTY_SUBKEY),		SbxSTRING));
	Insert(new SbxProperty(UniString::CreateFromAscii(PROPERTY_NAME),		SbxSTRING));
	Insert(new SbxProperty(UniString::CreateFromAscii(PROPERTY_VALUE),		SbxSTRING));
}

void SibRegistryItem::Notify(SfxBroadcaster& rBC, SfxHint const& rHint)
{
	const SbxHint* pHint = (SbxHint*) &rHint;

	if (pHint->GetId() == SBX_HINT_DATAWANTED)
	{
		SbxVariable *pVar  = pHint->GetVar();
		ByteString		 aName = ByteString( pVar->GetName(), osl_getThreadTextEncoding() );

		if (aName.CompareIgnoreCaseToAscii(PROPERTY_PARENTID) == COMPARE_EQUAL)
		{
			if (m_pRI->GetParent() != NULL)
				pVar->PutObject(new SibRegistryItem(m_pRI->GetParent()));
			else
				pVar->PutNull();
		}
		else if (aName.CompareIgnoreCaseToAscii(PROPERTY_KEY) == COMPARE_EQUAL)
		{
			pVar->PutString(UniString::CreateFromAscii(m_pRI->GetKey().GetBuffer()));
		}
		else if (aName.CompareIgnoreCaseToAscii(PROPERTY_SUBKEY) == COMPARE_EQUAL)
		{
			pVar->PutString(UniString::CreateFromAscii(m_pRI->GetSubkey().GetBuffer()));
		}
		else if (aName.CompareIgnoreCaseToAscii(PROPERTY_NAME) == COMPARE_EQUAL)
		{
			pVar->PutString(UniString::CreateFromAscii(m_pRI->GetName().GetBuffer()));
		}
		else if (aName.CompareIgnoreCaseToAscii(PROPERTY_VALUE) == COMPARE_EQUAL)
		{
			pVar->PutString(UniString::CreateFromAscii(m_pRI->GetValue().GetBuffer()) );
		}

		return;
	}

	SbxObject::Notify(rBC, rHint);
}

