/*************************************************************************
 *
 *  $RCSfile: regmimetypes.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: tra $ $Date: 2002/02/18 15:21:45 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _REGMIMETYPES_HXX_
#define _REGMIMETYPES_HXX_

#include "sicustom.hxx" 
#include <rtl/string.hxx>
#include <rtl/ustring.hxx>

#ifndef _FILEHELPER_HXX_
#include "filehelper.hxx"
#endif

//--------------------------------------------
// typedefs
//--------------------------------------------

typedef bool ( SAL_CALL *QueryIncludeModuleFnc_t)( BOOL bIsSelected, BOOL bIsInstalled );
typedef void ( SAL_CALL *IncludeEntryFnc_t)( const rtl::OString& aKeyName, const rtl::OString& aKeyValue, OStringList_t& aEntryList, void* aParam );

//--------------------------------------------
//
//--------------------------------------------

void SAL_CALL fileAppendEntries( osl::File& aFile, const OStringList_t aEntryList );

bool SAL_CALL installQueryIncludeModule( BOOL bIsSelected, BOOL bIsInstalled );

bool SAL_CALL deinstallQueryIncludeModule( BOOL bIsSelected, BOOL bIsInstalled );

bool SAL_CALL modifyInstallQueryIncludeModule( BOOL bIsSelected, BOOL bIsInstalled );

bool SAL_CALL modifyDeinstallQueryIncludeModule( BOOL bIsSelected, BOOL bIsInstalled );

void SAL_CALL setupModuleList( SiCustomModuleList* pModList, const QueryIncludeModuleFnc_t pfncQryIncMod, OStringList_t& aInstModList );

void SAL_CALL fileAddEntries( const rtl::OUString& aFileName, const OStringList_t& aEntryList );

void SAL_CALL fileAddEntries( osl::File& aFile, OStringList_t& aEntryList );

void SAL_CALL fileRemoveEntries( const rtl::OUString& aFileName, const OStringList_t& aEntryList );

rtl::OString SAL_CALL makeAbsPath( const rtl::OString& aBasePath, const rtl::OString& aRelativePath );

//---------------------------------
// some helper functions
//---------------------------------

inline bool SAL_CALL IsInstallation( SiCustomEnvironment* pEnv )      
{ return (!pEnv->IsModify() && !pEnv->IsRepair() && pEnv->IsInstallation() ); }

inline bool SAL_CALL IsDeinstallation( SiCustomEnvironment* pEnv )    
{ return ( !pEnv->IsModify() && !pEnv->IsRepair() && pEnv->IsDeinstallation() ); }

inline bool SAL_CALL IsSetupModification( SiCustomEnvironment* pEnv ) 
{ return pEnv->IsModify(); }

inline bool SAL_CALL IsSetupRepair( SiCustomEnvironment* pEnv )
{ return pEnv->IsRepair(); }

#endif

