/*************************************************************************
 *
 *  $RCSfile: progress.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2003/04/17 10:02:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#include "progress.hxx"

#define COL_SUN_BLUE    Color(RGB_COLORDATA( 0x59, 0x4F, 0xBF ))
#define COL_SUN_BORDER  Color(RGB_COLORDATA( 0xCC, 0xCC, 0xCC ))

SiProgressBar::SiProgressBar( Window* pParent, ResId& rResId ) :
	Control( pParent, rResId )
{
	CommonConstruct();
}

SiProgressBar::SiProgressBar( Window* pParent, WinBits aWinBits ) :
	Control( pParent, aWinBits )
{
	CommonConstruct();
}

void SiProgressBar::CommonConstruct()
{
	m_nPercent = 0;
    m_bIsBlack = FALSE;

	SetLineColor();
	SetBackground();

	Font aNewFont( GetFont() );
	aNewFont.SetColor( COL_WHITE );
	aNewFont.SetTransparent( TRUE );
	#ifdef OS2
	aNewFont.SetWeight( WEIGHT_BOLD );
	#endif
	SetFont( aNewFont );
}

void SiProgressBar::Paint( const Rectangle& )
{
	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	Point	  	aPoint;
	Rectangle 	aFullRect( aPoint, GetOutputSizePixel() );

	Color aLastLC = GetLineColor();
    Color aLineCol;
    Color aFillCol;

    if ( IsBlack() )
    {
        aLineCol = Color( COL_WHITE );
        aFillCol = Color( COL_BLACK );
    }
    else
    {
        aLineCol = COL_SUN_BORDER;
        aFillCol = Color( COL_WHITE );
    }

    SetLineColor( aLineCol );
	SetFillColor( aFillCol );
    
    DrawRect( aFullRect );

    SetLineColor( aLastLC );

    aFullRect.Left()   += 2;
    aFullRect.Top()    += 2;
    aFullRect.Right()  -= 2;
    aFullRect.Bottom() -= 2;

    Rectangle 	aRect( aFullRect );

	Point	  	aPos( aRect.Center() );
	String		aStr( UniString::CreateFromInt32(m_nPercent) );
	long		nTextWidth( GetTextWidth(aStr) );
	long		nTextHeight( GetTextHeight() );
	Font 		aOldFont( GetFont() );
	Font 		aPercentFont( aOldFont );

    aStr += UniString::CreateFromAscii("%");
	aPos.X() -= nTextWidth >> 1;
	aPos.Y() -= nTextHeight >> 1;

	aRect.Right() = aRect.Left() + ( ( aRect.Right()-aRect.Left() ) * m_nPercent / 100 );

	if ( IsBlack() )
        SetFillColor( Color( COL_WHITE ) );
    else
        SetFillColor( COL_SUN_BLUE );

    DrawRect( aRect );

	SetClipRegion( Region(aRect) );

	if ( IsBlack() )
    {
        aPercentFont.SetColor( COL_BLACK );
    }
    else
        aPercentFont.SetColor( COL_WHITE );

    SetFont( aPercentFont );
	DrawText( aPos, aStr );

	Rectangle aWhiteRect( aRect.TopRight(), Size(aFullRect.Right() - aRect.Right(),
						  aFullRect.Bottom() - aRect.Top() + 1 ) );

	SetClipRegion( Region(aWhiteRect) );

    if ( IsBlack() )
        SetFillColor( Color( COL_BLACK ) );
    else
        SetFillColor( Color( COL_WHITE ) );

    DrawRect( aWhiteRect );

	if ( IsBlack() )
    {
        AllSettings	  aSysSettings( Application::GetSettings() );
        StyleSettings aSysStyle( aSysSettings.GetStyleSettings() );
        Color         aColor( aSysStyle.GetLabelTextColor() );
        
        aPercentFont.SetColor( aColor );
    }
    else
        aPercentFont.SetColor( COL_BLACK );

    SetFont( aPercentFont );

	DrawText( aPos, aStr );
	SetClipRegion();
}

void SiProgressBar::SetPercent( USHORT nNewPercent )
{
	if( m_nPercent != nNewPercent )
	{
		NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

		m_nPercent = nNewPercent > 100 ? 100 : nNewPercent;
		Invalidate();
		Update();
		Flush();
	}
}
