/*************************************************************************
 *
 *  $RCSfile: exchobj.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2001/08/09 13:40:28 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EXCHOBJ_HXX
#define _EXCHOBJ_HXX

// includes *******************************************************************


#ifndef _DEBUG_HXX //autogen
#include <tools/debug.hxx>
#endif
#ifndef _SO2REF_HXX //autogen
#include <so3/so2ref.hxx>
#endif

// forwards *******************************************************************

class SfxExchangeObject;

//*****************************************************************************
// SfxExchangeObjectRef
//*****************************************************************************

SO2_DECL_REF( SfxExchangeObject )

//*****************************************************************************
// SfxDataObjectMemberList
//*****************************************************************************

/*
  [Beschreibung]
  Instanzen dieser Klasse halten Referenzen auf mehrere Instanzen der Klasse
  <SvDataObject>.
  */

SV_DECL_IMPL_REF_LIST( SvDataObject, SvDataObject* )

//*****************************************************************************
// SfxExchangeObject
//*****************************************************************************

/*
  [Beschreibung]
  Die Klasse erweitert die Basisklasse um die Moeglichkeit mehrere Instanzen
  der Klasse <SvDataObject> an einem Datenaustausch innerhalb einer Applikation
  zu beteiligen. Zu diesem Zwecke stellt sie Methoden zur Verfuegung, mit deren
  Hilfe die einzelnen Instanzen abgefragt werden koennen. Unterstuetzt ein
  Applikationsteil die Klasse nicht bzw. wird der Datenaustausch mit einem
  Bereich ausserhalb der Applikation durchgefuehrt, so werden alle Aufrufe an
  die Instanz auf ein Objekt aus dem Datenaustausch delegiert. Werden nur
  Instanzen verwendet, die das Format fuer den Austausche von Dateien
  unterstuetzen <FORMAT_FILE>, so generiert eine Instanz der Klasse
  <SfxExchangeObject> zusaetzlich das Format und die Daten fuer mehrere
  Dateien <FORMAT_FILE_LIST>.

  [Beispiel fuer eine Quelle]
  ...
  #include<sfxexch.hxx>
  ...
  // pSelection ist ein beliebiges Objekt, das eine Mehrfachselektion
  // repraesentiert
  SfxExchangeObjectRef xObj = new SfxExchangeObject();
  USHORT nPos = pSelection->Count();
  while ( nPos-- )
  {
	  // Daten in das Objekt einfuegen
	  xObj->Insert( pSelection->GetSelItem( nPos )->CreateDataObject() );
  }
  xObj->CopyClipboard();
  ...

  [Beispiel fuer ein Ziel]
  SfxExchangeObjectRef xObj = SfxExchangeObject::PasteClipboard();
  if ( xObj.Is() )
  {
	  // Iteration ueber alle am Datenaustausch beteiligten Objekte
	  ULONG nPos = xObj->Count();
	  while ( nPos-- )
	  {
		  SvDataObject* pItem = xObj->GetObject( nPos );
		  pItem->GetDataHere( .... );
		  ...
	  }
  }
  */

class SfxExchangeObject : public SvDataObject
{

	SvDataObjectMemberList*       _pObjList;
	SvDataTypeList*               _pTypeList;

private:

#if _SOLAR__PRIVATE
	static SfxExchangeObjectRef   DetectObject_Impl( SvDataObject* pObj );

	BOOL                          SetFileList_Impl( SvData* ) const;
#endif

public:

	SO2_DECL_BASIC_CLASS( SfxExchangeObject )

								  SfxExchangeObject();
								  SfxExchangeObject( SvDataObject* pExternal );
	virtual                       ~SfxExchangeObject();

	virtual const SvDataTypeList& GetTypeList() const;
	virtual const SvDataTypeList& GetSetDataTypeList() const;

	virtual BOOL	              SetData( SvData* pData );
	virtual BOOL	              GetData( SvData* pData );
	virtual BOOL	              GetDataHere( SvData* pData );
	virtual BOOL	              QueryDataType( SvDataType& rInOutType );

	inline void                   Insert( SvDataObject* pObj );
	inline SvDataObject*          GetObject( ULONG nIndex ) const;
	inline ULONG                  Count() const;

	static SfxExchangeObjectRef   PasteClipboard();
	static SfxExchangeObjectRef   PasteDragServer( const DropEvent& rEvt );

};

// inlines ********************************************************************

inline void SfxExchangeObject::Insert( SvDataObject* pObj )
{
	DBG_ASSERT( pObj, "SfxExchangeObject:ungueltiges Objekt" );
	_pObjList->Insert( pObj, LIST_APPEND );
}

inline SvDataObject* SfxExchangeObject::GetObject( ULONG nIndex ) const
{
	DBG_ASSERT( nIndex < Count(), "SfxExchangeObject:ungueltige Indizierung" );
	return _pObjList->GetObject( nIndex );
}

inline ULONG SfxExchangeObject::Count() const
{
	return _pObjList->Count();
}

//*****************************************************************************
// SfxExchangeObjectRef
//*****************************************************************************

SO2_IMPL_REF( SfxExchangeObject )

#endif


