/*************************************************************************
 *
 *  $RCSfile: exptypes.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: as $ $Date: 2000/11/08 14:25:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SFX_EXPTYPES_HXX
#define _SFX_EXPTYPES_HXX

// include ---------------------------------------------------------------

#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif

class FileStat;
#ifdef ENABLE_INIMANAGER//MUSTINI
class SfxIniManager;
#endif
class FixedText;
class BigInt;
class DateTime;
class DirEntry;
class Window;

// Hilfsfunktionen -------------------------------------------------------

/*	[Beschreibung]

	Diese Funktion erzeugt aus der "ubergebenen Gr"o\senangabe <nSize>
	einen String der Art:

	x KB

	Nur wenn x in Bytes tatsaechlich 0 ist, wird selbiger Wert angegeben, sonst
	mindestens 1 KB.

	[R"uckgabewert]

	der erzeugte String.
*/
String CreateKBText( ULONG nSize );


/*	[Beschreibung]

	Diese Funktion erzeugt aus der "ubergebenen Gr"o\senangabe <nSize>
	einen String der Art:

	n1 Unit (n2 Bytes)

	wobei n1 ggf. gek"urzt wird und die Unit dann KB, MB oder sogar GB ist.
	n2 == nSize.

	Sind SmartExtraBytes angeschaltet, wird bei Einheit GB zus"atzlich der
	MB-Wert ausgegeben, da GB-Stufigkeit u.U. zu ungenau ist.

	[R"uckgabewert]

	der erzeugte String.
*/

#if SUPD < 535
String CreateSizeText( ULONG nSize, BOOL bExtraBytes = TRUE );
String CreateSizeText( ULONG nSize, BOOL bExtraBytes, BOOL bSmartExtraBytes );
#else
String CreateSizeText( ULONG nSize, BOOL bExtraBytes = TRUE, BOOL bSmartExtraBytes = FALSE );
#endif

#if SUPD < 535
String ExtendedCreateSizeText( const BigInt& rInt );
String ExtendedCreateSizeText( const BigInt& rInt, BOOL bExtraBytes, BOOL bSmartExtraBytes );
#else
String ExtendedCreateSizeText( const BigInt& rInt, BOOL bExtraBytes = TRUE, BOOL bSmartExtraBytes = FALSE );
#endif


String CreateExactSizeText( ULONG nSize );
String CreateExactSizeText( const BigInt& nSize );

/*	[Beschreibung]

	Diese Funktion kopiert den "ubergebenen String, wobei eine gefundene
	Tilde verdoppelt wird, damit sie im FixedText eines Dialoges/TabPages
	nicht als Accelerator, sondern direkt, angezeigt wird.

	[R"uckgabewert]

	der String mit ggf. doppelten Tilden.
*/
String ConvertWithTilde( const String& rTxt );

/*	[Beschreibung]

	Diese Funktion erzeugt aus dem "ubergebenden DateTime einen String
	mit Hilfe der International Klasse.
*/
void CreateDateTimeText( const DateTime& rDT, String& rText );

/*	[Beschreibung]

	Diese Funktion erzeugt aus dem "ubergebenden FileStat einen String
	mit dem Erstellungsdatum des dazugeh"origen Files

	[R"uckgabewert]

	der String mit dem Erstellungsdatum
*/
String Create_CreateDate_Text( const FileStat& rFileStat );

/*	[Beschreibung]

	Diese Funktion erzeugt aus dem "ubergebenden FileStat einen String
	mit dem "Anderungsdatum des dazugeh"origen Files

	[R"uckgabewert]

	der String mit dem "Anderungsdatum
*/
String Create_ChangeDate_Text( const FileStat& rFileStat );
#ifdef ENABLE_INIMANAGER//MUSTINI
/*	[Beschreibung]

	Diese Funktion liest aus der Ini den Adress-String und gibt
	das verlangte Token zur"uck. Sollte ein SfxIniManager im
	aufrufenden Sourcecode schon vorhanden sein, kann man ihn mit
	"ubergeben.

	[R"uckgabewert]

	das verlangte Token.
*/
String GetAddressToken( USHORT nToken, SfxIniManager* pMgr = NULL );

#define ADRPOS_COMPANY		((USHORT) 0)
#define ADRPOS_STREET		((USHORT) 1)
#define ADRPOS_COUNTRY		((USHORT) 2)
#define ADRPOS_PLZ			((USHORT) 3)
#define ADRPOS_CITY			((USHORT) 4)
#define ADRPOS_TITLE		((USHORT) 5)
#define ADRPOS_POSITION		((USHORT) 6)
#define ADRPOS_TEL_PRIVATE	((USHORT) 7)
#define ADRPOS_TEL_COMPANY	((USHORT) 8)
#define ADRPOS_FAX			((USHORT) 9)
#define ADRPOS_EMAIL		((USHORT)10)
#define ADRPOS_STATE		((USHORT)11)
#endif
/*	[Beschreibung]

	Diese Funktion setzt einen Pfad in einen FixedText. Dabei wird
	die L"ange des Pfades mit der Breite des FixedTextes mit Hilfe
	der Methode <DirEntry::GetFull((FSysPathStyle, BOOL, USHORT)>
	abgeglichen.
*/
void InsertPathInFixedText( FixedText& rFT, const DirEntry& rEntry );

/*
  [Beschreibung]
  Die Methode entfernt die ueberfluessigen Zeichen des Textes des Fensters
  und prueft, ob er mehr als 0 Zeichen hat.

  [Rueckgabewert]
  FALSE  - 0 Zeichen lang
  ...
  */
BOOL Trim_And_Test_Text( Window& rWnd );


#endif

